/*
 * Decompiled with CFR 0.152.
 */
package omero.grid;

import Ice.Current;
import Ice.InputStream;
import Ice.OutputStream;
import Ice.ReadObjectCallback;
import Ice.UnmarshalOutOfBoundsException;
import Ice.Util;
import ome.model.jobs.ParseJob;
import ome.parameters.Parameters;
import ome.security.AdminAction;
import ome.security.SecuritySystem;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import omero.InternalException;
import omero.ServerError;
import omero.grid.InteractiveProcessorPrx;
import omero.grid.JobParams;
import omero.model.Job;
import omero.model.OriginalFileI;
import omero.model.ParseJobI;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

public class ParamsHelper {
    private static final Log log = LogFactory.getLog(ParamsHelper.class);
    public static final String PYTHONSCRIPT = "text/x-python";
    public static final String OCTETSTREAM = "application/octet-stream";
    private final Acquirer acq;
    private final Executor ex;
    private final Principal p;
    private final SecuritySystem secSys;

    public ParamsHelper(Acquirer acq, Executor ex, Principal p) {
        this.acq = acq;
        this.ex = ex;
        this.p = p;
        this.secSys = (SecuritySystem)ex.getContext().getBean("securitySystem");
    }

    public ParseJobI buildParseJob(long id) throws ServerError {
        OriginalFileI file = new OriginalFileI(id, false);
        ParseJobI job = new ParseJobI();
        job.linkOriginalFile(file);
        job.setMessage(rtypes.rstring(String.format("Parsing script %s", id)));
        return job;
    }

    public JobParams getOrCreateParams(long id, Current __current) throws ServerError {
        JobParams params = this.getParamsOrNull(id, __current);
        if (params == null) {
            return this.generateScriptParams(id, __current);
        }
        return params;
    }

    JobParams getParamsOrNull(long scriptId, Current __current) {
        ParseJob job = this.getParseJobForScript(scriptId);
        if (job != null) {
            return this.parse(job.getParams(), __current);
        }
        return null;
    }

    ParseJob getParseJobForScript(final long scriptId) {
        ParseJob job = (ParseJob)this.ex.execute(this.p, (Executor.Work)new Executor.SimpleWork(this, "getParseJobForScript", new Object[]{scriptId}){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                Parameters p = new Parameters();
                p.page(Integer.valueOf(0), Integer.valueOf(1));
                p.addLong("id", Long.valueOf(scriptId));
                return sf.getQueryService().findByQuery("select job from ParseJob job join job.originalFileLinks scriptlinks join scriptlinks.child script where job.params is not null and script.id = :id and script.details.updateEvent.id <= job.details.updateEvent.id order by job.details.updateEvent.id desc", p);
            }
        });
        return job;
    }

    JobParams generateScriptParams(long id, Current __current) throws ServerError {
        omero.model.ParseJob job = this.buildParseJob(id);
        InteractiveProcessorPrx proc = this.acq.acquireProcessor(job, 10, __current);
        if (proc == null) {
            throw new InternalException(null, null, "No processor acquired.");
        }
        job = (omero.model.ParseJob)proc.getJob();
        JobParams rv = proc.params();
        this.saveScriptParams(rv, job, __current);
        return rv;
    }

    void saveScriptParams(JobParams params, final omero.model.ParseJob job, Current __current) throws ServerError {
        final byte[] data = this.parse(params, __current);
        this.ex.execute(this.p, (Executor.Work)new Executor.SimpleWork(this, "saveScriptParams", new Object[]{job.getId().getValue()}){

            @Transactional(readOnly=false)
            public Object doWork(final Session session, ServiceFactory sf) {
                ParseJob parseJob = (ParseJob)sf.getQueryService().get(ParseJob.class, job.getId().getValue());
                parseJob.setParams(data);
                ParamsHelper.this.secSys.runAsAdmin(new AdminAction(){

                    public void runAsAdmin() {
                        session.flush();
                    }
                });
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] parse(JobParams params, Current current) {
        OutputStream os = Util.createOutputStream(current.adapter.getCommunicator());
        byte[] bytes = null;
        try {
            os.writeObject(params);
            os.writePendingObjects();
            bytes = os.finished();
        }
        finally {
            os.destroy();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobParams parse(byte[] data, Current current) {
        if (data == null) {
            return null;
        }
        InputStream is = Util.createInputStream(current.adapter.getCommunicator(), data);
        final JobParams[] params = new JobParams[1];
        try {
            is.readObject(new ReadObjectCallback(){

                public void invoke(Ice.Object arg0) {
                    params[0] = (JobParams)arg0;
                }
            });
            is.readPendingObjects();
        }
        catch (UnmarshalOutOfBoundsException oob) {
        }
        catch (OutOfMemoryError oom) {
            log.warn((Object)"http://www.zeroc.com/forums/bug-reports/4782-3-3-1-outofmemory-client-when-slice-definition-modified.html");
        }
        finally {
            is.destroy();
        }
        return params[0];
    }

    public static interface Acquirer {
        public InteractiveProcessorPrx acquireProcessor(Job var1, int var2, Current var3) throws ServerError;
    }
}

