/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import ome.util.Filter;
import ome.util.Filterable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextFilter
implements Filter {
    private static Log log = LogFactory.getLog(ContextFilter.class);
    private Object dummy;
    protected Map _cache = new IdentityHashMap();
    protected LinkedList _context = new LinkedList();

    protected void beforeFilter(String fieldId, Object o) {
        this.enter(o);
        this.addSeen(o);
    }

    protected void doFilter(String fieldId, Object o) {
    }

    protected void doFilter(String fieldId, Filterable f) {
        f.acceptFilter(this);
    }

    protected void doFilter(String fieldId, Collection c) {
        ArrayList<Object> copy = new ArrayList<Object>();
        for (Object item : c) {
            Object result = this.filter(fieldId, item);
            copy.add(result);
        }
        try {
            c.clear();
            c.addAll(copy);
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
    }

    protected void afterFilter(String fieldId, Object o) {
        this.exit(o);
    }

    public Filterable filter(String fieldId, Filterable f) {
        if (f != null && this.hasntSeen(f)) {
            this.beforeFilter(fieldId, f);
            this.doFilter(fieldId, f);
            this.afterFilter(fieldId, f);
        }
        return f;
    }

    public Collection filter(String fieldId, Collection c) {
        if (c != null && this.hasntSeen(c)) {
            this.beforeFilter(fieldId, c);
            this.doFilter(fieldId, c);
            this.afterFilter(fieldId, c);
        }
        return c;
    }

    public Map filter(String fieldId, Map m) {
        if (m != null && this.hasntSeen(m)) {
            this.beforeFilter(fieldId, m);
            HashMap<Object, Object> add = new HashMap<Object, Object>();
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry _entry = iter.next();
                Entry entry = new Entry(_entry.getKey(), _entry.getValue());
                Entry result = this.filter(fieldId, entry);
                if (null == result) {
                    iter.remove();
                    continue;
                }
                if (result.key == entry.key && result.value == entry.value) continue;
                iter.remove();
                add.put(result.key, result.value);
            }
            m.putAll(add);
            this.afterFilter(fieldId, m);
        }
        return m;
    }

    public Object filter(String fieldId, Object o) {
        Object result;
        if (o instanceof Filterable) {
            result = this.filter(fieldId, (Filterable)o);
        } else if (o instanceof Collection) {
            result = this.filter(fieldId, (Collection)o);
        } else if (o instanceof Map) {
            result = this.filter(fieldId, (Map)o);
        } else {
            this.beforeFilter(fieldId, o);
            this.doFilter(fieldId, o);
            this.afterFilter(fieldId, o);
            result = o;
        }
        return result;
    }

    protected Entry filter(String fieldId, Entry entry) {
        if (entry != null && this.hasntSeen(entry)) {
            this.addSeen(entry);
            this.enter(entry);
            Object key = this.filter(fieldId, entry.key);
            Object value = this.filter(fieldId, entry.value);
            this.exit(entry);
            entry.key = key;
            entry.value = value;
        }
        return entry;
    }

    public boolean enter(Object o) {
        this.push(o);
        return true;
    }

    public boolean exit(Object o) {
        this.pop(o);
        return true;
    }

    public Object currentContext() {
        return this._context.size() > 0 ? this._context.getLast() : null;
    }

    public Object previousContext(int index) {
        if (index < 0 || index >= this._context.size()) {
            return null;
        }
        return this._context.get(this._context.size() - index - 1);
    }

    protected void push(Object o) {
        this._context.addLast(o);
    }

    protected void pop(Object o) {
        Object last = this._context.removeLast();
        if (o != last) {
            throw new IllegalStateException("Context is invalid. Trying to remove Object " + o + " and removed Object " + last);
        }
    }

    protected void addSeen(Object o) {
        this._cache.put(o, this.dummy);
    }

    protected boolean hasntSeen(Object o) {
        return !this._cache.containsKey(o);
    }

    class Entry {
        Object key;
        Object value;

        public String toString() {
            return "(" + this.key + ":" + this.value + ")";
        }

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

