/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.RString;
import omero.model.Plate;
import omero.model.PlateI;
import omero.model.ScreenPlateLink;
import omero.rtypes;
import pojos.DataObject;
import pojos.ImageData;
import pojos.ScreenData;
import pojos.SetMutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateData
extends DataObject {
    public static final String NAME = "ome.model.screen.Plate_name";
    public static final String DESCRIPTION = "ome.model.screen.Plate_description";
    public static final String WELLS = "ome.model.screen.Plate_wells";
    public static final String SCREEN_LINKS = "ome.model.screen.Plate_screenLinks";
    public static final String ANNOTATIONS = "ome.model.screen.Plate_annotationLinks";
    private Set<ImageData> wells;
    private Set<ScreenData> screens;
    private Long annotationCount;

    public PlateData() {
        this.setDirty(true);
        this.setValue(new PlateI());
    }

    public PlateData(Plate plate) {
        if (plate == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(plate);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asPlate().setName(rtypes.rstring(name));
    }

    public String getName() {
        RString n = this.asPlate().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have bee null.");
        }
        return n.getValue();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asPlate().setDescription(rtypes.rstring(description));
    }

    public String getDescription() {
        RString d = this.asPlate().getDescription();
        return d == null ? null : d.getValue();
    }

    public Map<Long, Long> getAnnotationsCounts() {
        return this.asPlate().getAnnotationLinksCountPerOwner();
    }

    public Set getScreens() {
        if (this.screens == null && this.asPlate().sizeOfScreenLinks() >= 0) {
            this.screens = new HashSet<ScreenData>();
            List<ScreenPlateLink> links = this.asPlate().copyScreenLinks();
            for (ScreenPlateLink link : links) {
                this.screens.add(new ScreenData(link.getParent()));
            }
        }
        return this.screens == null ? null : new HashSet<ScreenData>(this.screens);
    }

    public void setScreens(Set<ScreenData> value) {
        Set currentValue = this.getScreens();
        SetMutator<ScreenData> m = new SetMutator<ScreenData>(currentValue, value);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asPlate().unlinkScreen(m.nextDeletion().asScreen());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asPlate().linkScreen(m.nextAddition().asScreen());
        }
        this.screens = new HashSet<ScreenData>(m.result());
    }
}

