/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.ArrayList;
import java.util.List;
import omero.RString;
import omero.model.Experimenter;
import omero.model.ExperimenterI;
import omero.model.GroupExperimenterMap;
import omero.rtypes;
import pojos.DataObject;
import pojos.GroupData;
import pojos.SetMutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimenterData
extends DataObject {
    public static final String FIRSTNAME = "ome.model.meta.Experimenter_firstName";
    public static final String MIDDLENAME = "ome.model.meta.Experimenter_middleName";
    public static final String LASTNAME = "ome.model.meta.Experimenter_lastName";
    public static final String EMAIL = "ome.model.meta.Experimenter_email";
    public static final String OMENAME = "ome.model.meta.Experimenter_omeName";
    public static final String INSTITUTION = "ome.model.meta.Experimenter_institution";
    public static final String GROUP_EXPERIMENTER_MAP = "ome.model.meta.Experimenter_groupExperimenterMap";
    private List<GroupData> groups;

    public ExperimenterData() {
        this.setDirty(true);
        this.setValue(new ExperimenterI());
    }

    public ExperimenterData(Experimenter experimenter) {
        if (experimenter == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(experimenter);
    }

    public void setFirstName(String firstName) {
        this.setDirty(true);
        this.asExperimenter().setFirstName(rtypes.rstring(firstName));
    }

    public String getFirstName() {
        RString n = this.asExperimenter().getFirstName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null");
        }
        return n.getValue();
    }

    public void setLastName(String lastName) {
        this.setDirty(true);
        this.asExperimenter().setLastName(rtypes.rstring(lastName));
    }

    public String getLastName() {
        RString n = this.asExperimenter().getLastName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null");
        }
        return n.getValue();
    }

    public void setEmail(String email) {
        this.setDirty(true);
        this.asExperimenter().setEmail(rtypes.rstring(email));
    }

    public String getEmail() {
        RString e = this.asExperimenter().getEmail();
        return e == null ? null : e.getValue();
    }

    public void setInstitution(String institution) {
        this.setDirty(true);
        this.asExperimenter().setInstitution(institution == null ? null : rtypes.rstring(institution));
    }

    public String getInstitution() {
        RString i = this.asExperimenter().getInstitution();
        return i == null ? null : i.getValue();
    }

    public List<GroupData> getGroups() {
        if (this.groups == null && this.asExperimenter().sizeOfGroupExperimenterMap() >= 0) {
            this.groups = new ArrayList<GroupData>();
            List<GroupExperimenterMap> links = this.asExperimenter().copyGroupExperimenterMap();
            for (GroupExperimenterMap link : links) {
                this.groups.add(new GroupData(link.getParent()));
            }
        }
        return this.groups == null ? null : new ArrayList<GroupData>(this.groups);
    }

    public void setGroups(List<GroupData> newValue) {
        ArrayList<GroupData> currentValue = new ArrayList<GroupData>(this.getGroups());
        SetMutator<GroupData> m = new SetMutator<GroupData>(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asExperimenter().unlinkExperimenterGroup(m.nextDeletion().asGroup());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asExperimenter().linkExperimenterGroup(m.nextAddition().asGroup());
        }
        this.groups = m.result();
    }

    public GroupData getDefaultGroup() {
        return this.getGroups().get(0);
    }
}

