/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Pixels;
import omero.model.Thumbnail;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailI
extends Thumbnail
implements ModelBased {
    public static final String PIXELS = "ome.model.display.Thumbnail_pixels";
    public static final String MIMETYPE = "ome.model.display.Thumbnail_mimeType";
    public static final String SIZEX = "ome.model.display.Thumbnail_sizeX";
    public static final String SIZEY = "ome.model.display.Thumbnail_sizeY";
    public static final String REF = "ome.model.display.Thumbnail_ref";
    public static final String DETAILS = "ome.model.display.Thumbnail_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public ThumbnailI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ThumbnailI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ThumbnailI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadPixels();
        this.unloadMimeType();
        this.unloadSizeX();
        this.unloadSizeY();
        this.unloadRef();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ThumbnailI copy = new ThumbnailI();
        copy.id = this.id;
        copy.version = this.version;
        copy.pixels = this.pixels == null ? null : (Pixels)this.pixels.proxy();
        copy.mimeType = this.mimeType;
        copy.sizeX = this.sizeX;
        copy.sizeY = this.sizeY;
        copy.ref = this.ref;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ThumbnailI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadPixels() {
        this.pixels = null;
    }

    @Override
    public Pixels getPixels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.pixels;
    }

    @Override
    public void setPixels(Pixels pixels, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.pixels = pixels;
    }

    private void copyPixels(ome.model.display.Thumbnail source, IceMapper mapper) {
        this.pixels = (Pixels)mapper.findTarget(source.getPixels());
    }

    private void fillPixels(ome.model.display.Thumbnail target, IceMapper mapper) {
        target.putAt(PIXELS, (Object)mapper.reverse((ModelBased)((Object)this.getPixels())));
    }

    public void unloadMimeType() {
        this.mimeType = null;
    }

    @Override
    public RString getMimeType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.mimeType;
    }

    @Override
    public void setMimeType(RString mimeType, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.mimeType = mimeType;
    }

    private void copyMimeType(ome.model.display.Thumbnail source, IceMapper mapper) {
        this.mimeType = source.getMimeType() == null ? null : rtypes.rstring(source.getMimeType());
    }

    private void fillMimeType(ome.model.display.Thumbnail target, IceMapper mapper) {
        try {
            target.setMimeType((String)mapper.fromRType(this.getMimeType()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSizeX() {
        this.sizeX = null;
    }

    @Override
    public RInt getSizeX(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sizeX;
    }

    @Override
    public void setSizeX(RInt sizeX, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sizeX = sizeX;
    }

    private void copySizeX(ome.model.display.Thumbnail source, IceMapper mapper) {
        this.sizeX = source.getSizeX() == null ? null : rtypes.rint(source.getSizeX());
    }

    private void fillSizeX(ome.model.display.Thumbnail target, IceMapper mapper) {
        try {
            target.setSizeX((Integer)mapper.fromRType(this.getSizeX()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSizeY() {
        this.sizeY = null;
    }

    @Override
    public RInt getSizeY(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sizeY;
    }

    @Override
    public void setSizeY(RInt sizeY, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sizeY = sizeY;
    }

    private void copySizeY(ome.model.display.Thumbnail source, IceMapper mapper) {
        this.sizeY = source.getSizeY() == null ? null : rtypes.rint(source.getSizeY());
    }

    private void fillSizeY(ome.model.display.Thumbnail target, IceMapper mapper) {
        try {
            target.setSizeY((Integer)mapper.fromRType(this.getSizeY()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadRef() {
        this.ref = null;
    }

    @Override
    public RString getRef(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.ref;
    }

    @Override
    public void setRef(RString ref, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.ref = ref;
    }

    private void copyRef(ome.model.display.Thumbnail source, IceMapper mapper) {
        this.ref = source.getRef() == null ? null : rtypes.rstring(source.getRef());
    }

    private void fillRef(ome.model.display.Thumbnail target, IceMapper mapper) {
        try {
            target.setRef((String)mapper.fromRType(this.getRef()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.display.Thumbnail) {
            ome.model.display.Thumbnail source = (ome.model.display.Thumbnail)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyPixels(source, mapper);
                this.copyMimeType(source, mapper);
                this.copySizeX(source, mapper);
                this.copySizeY(source, mapper);
                this.copyRef(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Thumbnail cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.display.Thumbnail target = new ome.model.display.Thumbnail();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillPixels(target, mapper);
            this.fillMimeType(target, mapper);
            this.fillSizeX(target, mapper);
            this.fillSizeY(target, mapper);
            this.fillRef(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<ThumbnailI> cast(List list) {
        return list;
    }
}

