/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.common.RandomAccessStream;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.TiffTools;
import loci.formats.meta.MetadataRetrieve;

public class TiffWriter
extends FormatWriter {
    protected long lastOffset = 0L;
    protected RandomAccessOutputStream out;
    protected Vector imageCounts;
    protected boolean isBigTiff;

    public TiffWriter() {
        this("Tagged Image File Format", new String[]{"tif", "tiff"});
    }

    public TiffWriter(String format, String[] exts) {
        super(format, exts);
        this.compressionTypes = new String[]{"Uncompressed", "LZW", "J2K", "JPEG"};
        this.isBigTiff = false;
    }

    public void saveImage(Image image, Hashtable ifd, boolean last) throws IOException, FormatException {
        this.saveImage(image, ifd, 0, last, last);
    }

    public void saveImage(Image image, Hashtable ifd, int series, boolean lastInSeries, boolean last) throws IOException, FormatException {
        boolean littleEndian;
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        Boolean bigEndian = retrieve.getPixelsBigEndian(series, 0);
        boolean bl = bigEndian == null ? false : (littleEndian = bigEndian == false);
        if (!this.initialized) {
            this.imageCounts = new Vector();
            this.initialized = true;
            this.out = new RandomAccessOutputStream(this.currentId);
            RandomAccessStream tmp = new RandomAccessStream(this.currentId);
            if (tmp.length() == 0L) {
                if (littleEndian) {
                    this.out.writeByte(73);
                    this.out.writeByte(73);
                } else {
                    this.out.writeByte(77);
                    this.out.writeByte(77);
                }
                if (this.isBigTiff) {
                    DataTools.writeShort(this.out, 43, littleEndian);
                } else {
                    DataTools.writeShort(this.out, 42, littleEndian);
                }
                DataTools.writeInt(this.out, 8, littleEndian);
                this.lastOffset = 8L;
                if (this.isBigTiff) {
                    DataTools.writeLong(this.out, 16L, littleEndian);
                    this.lastOffset = 16L;
                }
            } else {
                TiffTools.checkHeader(tmp);
                long offset = TiffTools.getFirstOffset(tmp);
                long ifdMax = (tmp.length() - 8L) / 18L;
                for (long ifdNum = 0L; ifdNum < ifdMax; ++ifdNum) {
                    TiffTools.getIFD(tmp, ifdNum, offset);
                    offset = tmp.readInt();
                    if (offset <= 0L || offset >= tmp.length()) break;
                }
                this.lastOffset = offset;
            }
            tmp.close();
        }
        BufferedImage img = AWTImageTools.makeBuffered(image, this.cm);
        int plane = img.getWidth() * img.getHeight() * img.getRaster().getNumBands() * FormatTools.getBytesPerPixel(AWTImageTools.getPixelType(img));
        if (!this.isBigTiff) {
            RandomAccessStream tmp = new RandomAccessStream(this.currentId);
            boolean bl2 = this.isBigTiff = tmp.length() + (long)(2 * plane) >= 0x100000000L;
            if (this.isBigTiff) {
                throw new FormatException("File is too large; call setBigTiff(true)");
            }
            tmp.close();
        }
        ifd.put(new Integer(0), new Boolean(littleEndian));
        this.out.seek(this.out.length());
        this.lastOffset += TiffTools.writeImage(img, ifd, this.out, this.lastOffset, last, this.isBigTiff);
        if (last) {
            this.close();
        }
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        Hashtable<Integer, Integer> h = new Hashtable<Integer, Integer>();
        if (this.compression == null) {
            this.compression = "";
        }
        Integer compressType = new Integer(1);
        if (this.compression.equals("LZW")) {
            compressType = new Integer(5);
        } else if (this.compression.equals("J2K")) {
            compressType = new Integer(33003);
        } else if (this.compression.equals("JPEG")) {
            compressType = new Integer(7);
        }
        h.put(new Integer(259), compressType);
        this.saveImage(image, h, series, lastInSeries, last);
    }

    public boolean canDoStacks() {
        return true;
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
        this.lastOffset = 0L;
        this.imageCounts = null;
        this.isBigTiff = false;
    }

    public void setBigTiff(boolean bigTiff) {
        FormatTools.assertId(this.currentId, false, 1);
        this.isBigTiff = bigTiff;
    }
}

