/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.common.RandomAccessStream;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.out.LegacyQTWriter;

public class QTWriter
extends FormatWriter {
    public static final int CODEC_MOTION_JPEG_B = 1835692130;
    public static final int CODEC_CINEPAK = 1668704612;
    public static final int CODEC_ANIMATION = 1919706400;
    public static final int CODEC_H_263 = 1748121139;
    public static final int CODEC_SORENSON = 1398165809;
    public static final int CODEC_SORENSON_3 = 1398165811;
    public static final int CODEC_MPEG_4 = 1836070006;
    public static final int CODEC_RAW = 0;
    public static final int QUALITY_LOW = 256;
    public static final int QUALITY_NORMAL = 512;
    public static final int QUALITY_HIGH = 768;
    public static final int QUALITY_MAXIMUM = 1023;
    protected RandomAccessOutputStream out;
    protected int codec = 0;
    protected int quality = 512;
    protected int numWritten;
    protected long byteCountOffset;
    protected int numBytes;
    protected Vector offsets;
    protected int created;
    protected boolean needLegacy = false;
    protected LegacyQTWriter legacy;

    public QTWriter() {
        super("QuickTime", "mov");
        this.compressionTypes = new String[]{"Uncompressed", "Motion JPEG-B", "Cinepak", "Animation", "H.263", "Sorenson", "Sorenson 3", "MPEG 4"};
    }

    public void setCodec(int codec) {
        this.codec = codec;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (image == null) {
            throw new FormatException("Image is null");
        }
        if (this.legacy == null) {
            this.legacy = new LegacyQTWriter();
        }
        if (this.needLegacy) {
            this.legacy.setId(this.currentId);
            this.legacy.saveImage(image, last);
            return;
        }
        BufferedImage img = AWTImageTools.makeBuffered(image, this.cm);
        int width = img.getWidth();
        int height = img.getHeight();
        byte[][] byteData = AWTImageTools.getPixelBytes(img, false);
        int pad = width % 4;
        pad = (4 - pad) % 4;
        int bytesPerPixel = byteData[0].length / (width * height);
        byte[][] temp = byteData;
        byteData = new byte[temp.length][temp[0].length + height * (pad *= bytesPerPixel)];
        int rowLength = width * bytesPerPixel;
        for (int c = 0; c < temp.length; ++c) {
            for (int row = 0; row < height; ++row) {
                System.arraycopy(temp[c], row * rowLength, byteData[c], row * (rowLength + pad), rowLength);
            }
        }
        if (byteData.length == 1 && bytesPerPixel == 1) {
            for (int i = 0; i < byteData.length; ++i) {
                for (int k = 0; k < byteData[0].length; ++k) {
                    byteData[i][k] = (byte)(255 - byteData[i][k]);
                }
            }
        }
        byte[] buffer = new byte[byteData.length * byteData[0].length];
        for (int i = 0; i < byteData[0].length; ++i) {
            for (int j = 0; j < byteData.length; ++j) {
                buffer[i * byteData.length + j] = byteData[j][i];
            }
        }
        if (!this.initialized) {
            this.initialized = true;
            this.setCodec();
            if (this.codec != 0) {
                this.needLegacy = true;
                this.legacy.setCodec(this.codec);
                this.legacy.setId(this.currentId);
                this.legacy.saveImage(image, last);
                return;
            }
            this.offsets = new Vector();
            this.out = new RandomAccessOutputStream(this.currentId);
            this.created = (int)System.currentTimeMillis();
            this.numWritten = 0;
            this.numBytes = buffer.length;
            this.byteCountOffset = 8L;
            if (this.out.length() == 0L) {
                DataTools.writeInt(this.out, 8, false);
                this.out.writeBytes("wide");
                DataTools.writeInt(this.out, this.numBytes + 8, false);
                this.out.writeBytes("mdat");
            } else {
                this.out.seek(this.byteCountOffset);
                RandomAccessStream in = new RandomAccessStream(this.currentId);
                in.seek(this.byteCountOffset);
                this.numBytes = (int)DataTools.read4UnsignedBytes(in, false) - 8;
                in.close();
                this.numWritten = this.numBytes / buffer.length;
                this.numBytes += buffer.length;
                this.out.seek(this.byteCountOffset);
                DataTools.writeInt(this.out, this.numBytes + 8, false);
                for (int i = 0; i < this.numWritten; ++i) {
                    this.offsets.add(new Integer(16 + i * buffer.length));
                }
                this.out.seek(this.out.length());
            }
            this.offsets.add(new Integer((int)this.out.length()));
            ++this.numWritten;
            this.out.write(buffer);
        } else {
            int planeOffset = this.numBytes;
            this.numBytes += buffer.length;
            this.out.seek(this.byteCountOffset);
            DataTools.writeInt(this.out, this.numBytes + 8, false);
            this.out.seek(this.out.length());
            this.out.write(buffer);
            this.offsets.add(new Integer(planeOffset + 16));
            ++this.numWritten;
        }
        if (last) {
            int i;
            int bitsPerPixel;
            int timeScale = 100;
            int duration = this.numWritten * (timeScale / this.fps);
            int n = bitsPerPixel = byteData.length > 1 ? bytesPerPixel * 24 : bytesPerPixel * 8 + 32;
            if (bytesPerPixel == 2) {
                bitsPerPixel = byteData.length > 1 ? 16 : 40;
            }
            int channels = bitsPerPixel >= 40 ? 1 : 3;
            int atomLength = 685 + 8 * this.numWritten;
            DataTools.writeInt(this.out, atomLength, false);
            this.out.writeBytes("moov");
            DataTools.writeInt(this.out, 108, false);
            this.out.writeBytes("mvhd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, this.created, false);
            DataTools.writeInt(this.out, (int)System.currentTimeMillis(), false);
            DataTools.writeInt(this.out, timeScale, false);
            DataTools.writeInt(this.out, duration, false);
            this.out.write(new byte[]{0, 1, 0, 0});
            this.out.write(new byte[]{0, -1, 0, 0, 0, 0, 0, 0, 0, 0});
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 16384, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 2, false);
            DataTools.writeInt(this.out, atomLength -= 116, false);
            this.out.writeBytes("trak");
            DataTools.writeInt(this.out, 92, false);
            DataTools.writeString(this.out, "tkhd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 15, false);
            DataTools.writeInt(this.out, this.created, false);
            DataTools.writeInt(this.out, (int)System.currentTimeMillis(), false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, duration, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 16384, false);
            DataTools.writeInt(this.out, width, false);
            DataTools.writeInt(this.out, height, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 36, false);
            this.out.writeBytes("edts");
            DataTools.writeInt(this.out, 28, false);
            this.out.writeBytes("elst");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, duration, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, atomLength -= 136, false);
            this.out.writeBytes("mdia");
            DataTools.writeInt(this.out, 32, false);
            this.out.writeBytes("mdhd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, this.created, false);
            DataTools.writeInt(this.out, (int)System.currentTimeMillis(), false);
            DataTools.writeInt(this.out, timeScale, false);
            DataTools.writeInt(this.out, duration, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 58, false);
            this.out.writeBytes("hdlr");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            this.out.writeBytes("mhlr");
            this.out.writeBytes("vide");
            this.out.writeBytes("appl");
            this.out.write(new byte[]{16, 0, 0, 0, 0, 1, 1, 11, 25});
            this.out.writeBytes("Apple Video Media Handler");
            DataTools.writeInt(this.out, atomLength -= 98, false);
            this.out.writeBytes("minf");
            DataTools.writeInt(this.out, 20, false);
            this.out.writeBytes("vmhd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeShort(this.out, 64, false);
            DataTools.writeShort(this.out, 32768, false);
            DataTools.writeShort(this.out, 32768, false);
            DataTools.writeShort(this.out, 32768, false);
            DataTools.writeInt(this.out, 57, false);
            this.out.writeBytes("hdlr");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            this.out.writeBytes("dhlr");
            this.out.writeBytes("alis");
            this.out.writeBytes("appl");
            this.out.write(new byte[]{16, 0, 0, 1, 0, 1, 1, 31, 24});
            this.out.writeBytes("Apple Alias Data Handler");
            DataTools.writeInt(this.out, 36, false);
            this.out.writeBytes("dinf");
            DataTools.writeInt(this.out, 28, false);
            this.out.writeBytes("dref");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 1, false);
            this.out.write(new byte[]{0, 0, 0, 12});
            this.out.writeBytes("alis");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeInt(this.out, atomLength -= 121, false);
            this.out.writeBytes("stbl");
            DataTools.writeInt(this.out, 118, false);
            this.out.writeBytes("stsd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            this.out.write(new byte[]{0, 0, 0, 102});
            this.out.writeBytes("raw ");
            this.out.write(new byte[]{0, 0, 0, 0, 0, 0});
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeShort(this.out, 1, false);
            this.out.writeBytes("appl");
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 768, false);
            DataTools.writeShort(this.out, width, false);
            DataTools.writeShort(this.out, height, false);
            this.out.write(new byte[]{0, 72, 0, 0});
            this.out.write(new byte[]{0, 72, 0, 0});
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeShort(this.out, 12, false);
            this.out.writeBytes("Uncompressed");
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeShort(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, 65535, false);
            this.out.write(new byte[]{12, 103, 97, 108});
            this.out.write(new byte[]{97, 1, -52, -52, 0, 0, 0, 0});
            DataTools.writeInt(this.out, 24, false);
            this.out.writeBytes("stts");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, this.numWritten, false);
            DataTools.writeInt(this.out, timeScale / this.fps, false);
            DataTools.writeInt(this.out, 28, false);
            this.out.writeBytes("stsc");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 20 + 4 * this.numWritten, false);
            this.out.writeBytes("stsz");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, this.numWritten, false);
            for (i = 0; i < this.numWritten; ++i) {
                DataTools.writeInt(this.out, channels * height * (width + pad) * bytesPerPixel, false);
            }
            DataTools.writeInt(this.out, 16 + 4 * this.numWritten, false);
            this.out.writeBytes("stco");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, this.numWritten, false);
            for (i = 0; i < this.numWritten; ++i) {
                DataTools.writeInt(this.out, (Integer)this.offsets.get(i), false);
            }
            this.out.close();
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes() {
        return new int[]{1};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.numWritten = 0;
        this.byteCountOffset = 0L;
        this.numBytes = 0;
        this.created = 0;
        this.offsets = null;
        this.currentId = null;
        this.initialized = false;
    }

    private void setCodec() {
        if (this.compression == null) {
            return;
        }
        if (this.compression.equals("Uncompressed")) {
            this.codec = 0;
        } else if (this.compression.equals("Motion JPEG-B")) {
            this.codec = 1835692130;
        } else if (this.compression.equals("Cinepak")) {
            this.codec = 1668704612;
        } else if (this.compression.equals("Animation")) {
            this.codec = 1919706400;
        } else if (this.compression.equals("H.263")) {
            this.codec = 1748121139;
        } else if (this.compression.equals("Sorenson")) {
            this.codec = 1398165809;
        } else if (this.compression.equals("Sorenson 3")) {
            this.codec = 1398165811;
        } else if (this.compression.equals("MPEG 4")) {
            this.codec = 1836070006;
        }
    }
}

