/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.codec.Base64Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.MetadataRetrieve;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class OMEXMLWriter
extends FormatWriter {
    private Vector xmlFragments;
    private RandomAccessOutputStream out;
    private String currentFragment;

    public OMEXMLWriter() {
        super("OME-XML", "ome");
        this.compressionTypes = new String[]{"Uncompressed", "zlib", "J2K", "JPEG"};
        this.compression = this.compressionTypes[0];
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.xmlFragments = null;
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        if (!this.initialized) {
            this.out = new RandomAccessOutputStream(this.currentId);
            String xml = MetadataTools.getOMEXML(retrieve);
            this.xmlFragments = new Vector();
            this.currentFragment = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            DataTools.parseXML(xml, (DefaultHandler)new OMEHandler());
            this.xmlFragments.add(this.currentFragment);
            this.out.writeBytes((String)this.xmlFragments.get(0));
            this.initialized = true;
        }
        boolean littleEndian = retrieve.getPixelsBigEndian(series, 0) == false;
        BufferedImage buffImage = AWTImageTools.makeBuffered(image);
        byte[][] pix = AWTImageTools.getPixelBytes(buffImage, littleEndian);
        String type = retrieve.getPixelsPixelType(series, 0);
        int pixelType = FormatTools.pixelTypeFromString(type);
        CodecOptions options = new CodecOptions();
        options.width = buffImage.getWidth();
        options.height = buffImage.getHeight();
        options.channels = 1;
        options.interleaved = false;
        options.littleEndian = littleEndian;
        options.signed = FormatTools.isSigned(pixelType);
        buffImage = null;
        for (int i = 0; i < pix.length; ++i) {
            int bytes = pix[i].length / (options.width * options.height);
            options.bitsPerSample = bytes * 8;
            if (this.compression.equals("J2K")) {
                pix[i] = new JPEG2000Codec().compress(pix[i], options);
            } else if (this.compression.equals("JPEG")) {
                pix[i] = new JPEGCodec().compress(pix[i], options);
            } else if (this.compression.equals("zlib")) {
                pix[i] = new ZlibCodec().compress(pix[i], options);
            }
            byte[] encodedPix = new Base64Codec().compress(pix[i], options);
            StringBuffer plane = new StringBuffer("\n<Bin:BinData Length=\"");
            plane.append(encodedPix.length);
            plane.append("\"");
            if (this.compression != null && !this.compression.equals("Uncompressed")) {
                plane.append(" Compression=\"");
                plane.append(this.compression);
                plane.append("\"");
            }
            plane.append(">");
            plane.append(new String(encodedPix));
            plane.append("</Bin:BinData>");
            this.out.writeBytes(plane.toString());
        }
        if (lastInSeries) {
            this.out.writeBytes((String)this.xmlFragments.get(series + 1));
            this.close();
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    class OMEHandler
    extends DefaultHandler {
        OMEHandler() {
        }

        public void characters(char[] ch, int start, int length) {
            OMEXMLWriter.this.currentFragment = OMEXMLWriter.this.currentFragment + new String(ch, start, length);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            StringBuffer toAppend = new StringBuffer("\n<");
            toAppend.append(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                toAppend.append(" ");
                toAppend.append(attributes.getQName(i));
                toAppend.append("=\"");
                toAppend.append(attributes.getValue(i));
                toAppend.append("\"");
            }
            toAppend.append(">");
            OMEXMLWriter.this.currentFragment = OMEXMLWriter.this.currentFragment + toAppend.toString();
            if (qName.equals("Pixels")) {
                OMEXMLWriter.this.xmlFragments.add(OMEXMLWriter.this.currentFragment);
                OMEXMLWriter.this.currentFragment = "";
            }
        }

        public void endElement(String uri, String localName, String qName) {
            OMEXMLWriter.this.currentFragment = OMEXMLWriter.this.currentFragment + ("</" + qName + ">");
        }
    }
}

