/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.io.IOException;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.TiffWriter;

public class OMETiffWriter
extends TiffWriter {
    private static final String WARNING_COMMENT = "<!-- Warning: this comment is an OME-XML metadata block, which contains crucial dimensional parameters and other important metadata. Please edit cautiously (if at all), and back up the original data before doing so. For more information, see the OME-TIFF web site: http://loci.wisc.edu/ome/ome-tiff.html. -->";
    private Vector seriesMap;

    public OMETiffWriter() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff"});
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        if (this.currentId != null) {
            MetadataRetrieve retrieve = this.getMetadataRetrieve();
            IMetadata omeMeta = MetadataTools.getOMEMetadata(retrieve);
            for (int series = 0; series < omeMeta.getImageCount(); ++series) {
                String dimensionOrder = omeMeta.getPixelsDimensionOrder(series, 0);
                int sizeZ = omeMeta.getPixelsSizeZ(series, 0);
                int sizeC = omeMeta.getPixelsSizeC(series, 0);
                int sizeT = omeMeta.getPixelsSizeT(series, 0);
                int imageCount = 0;
                for (int q = 0; q < this.seriesMap.size(); ++q) {
                    if ((Integer)this.seriesMap.get(q) != series) continue;
                    ++imageCount;
                }
                if (imageCount < sizeZ * sizeC * sizeT) {
                    sizeC = imageCount / (sizeZ * sizeT);
                }
                Integer samplesPerPixel = new Integer(sizeZ * sizeC * sizeT / imageCount);
                for (int c = 0; c < omeMeta.getLogicalChannelCount(series); ++c) {
                    omeMeta.setLogicalChannelSamplesPerPixel(samplesPerPixel, series, c);
                }
                int num = 0;
                for (int plane = 0; plane < imageCount; ++plane) {
                    while ((Integer)this.seriesMap.get(num) != series) {
                        ++num;
                    }
                    int[] zct = FormatTools.getZCTCoords(dimensionOrder, sizeZ, sizeC, sizeT, imageCount, plane);
                    omeMeta.setTiffDataFileName(this.currentId, series, 0, plane);
                    omeMeta.setTiffDataFirstZ(new Integer(zct[0]), series, 0, plane);
                    omeMeta.setTiffDataFirstC(new Integer(zct[1]), series, 0, plane);
                    omeMeta.setTiffDataFirstT(new Integer(zct[2]), series, 0, plane);
                    omeMeta.setTiffDataIFD(new Integer(num), series, 0, plane);
                    omeMeta.setTiffDataNumPlanes(new Integer(1), series, 0, plane);
                    ++num;
                }
            }
            String xml = MetadataTools.getOMEXML(omeMeta);
            String prefix = xml.substring(0, xml.indexOf(">") + 1);
            String suffix = xml.substring(xml.indexOf(">") + 1);
            xml = prefix + WARNING_COMMENT + suffix;
            try {
                TiffTools.overwriteComment(this.currentId, xml);
            }
            catch (FormatException exc) {
                IOException io = new IOException("Unable to append OME-XML comment");
                io.initCause(exc);
                throw io;
            }
        }
        super.close();
        this.seriesMap = null;
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (this.seriesMap == null) {
            this.seriesMap = new Vector();
        }
        this.seriesMap.add(new Integer(series));
        super.saveImage(image, series, lastInSeries, last);
    }
}

