/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.out.ImageIOWriter;

public class JPEGWriter
extends ImageIOWriter {
    public JPEGWriter() {
        super("JPEG", new String[]{"jpg", "jpeg", "jpe"}, "jpeg");
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        BufferedImage img = AWTImageTools.makeBuffered(image, this.cm);
        int type = AWTImageTools.getPixelType(img);
        int[] types = this.getPixelTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != type) continue;
            super.saveImage(image, series, lastInSeries, last);
            return;
        }
        throw new FormatException("Unsupported data type - > 8 bit images cannot be saved.");
    }

    public int[] getPixelTypes() {
        return new int[]{1};
    }
}

