/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.common.RandomAccessOutputStream;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatWriter;

public abstract class ImageIOWriter
extends FormatWriter {
    protected String kind;
    protected RandomAccessOutputStream out;

    public ImageIOWriter(String format, String suffix, String kind) {
        super(format, suffix);
        this.kind = kind;
    }

    public ImageIOWriter(String format, String[] suffixes, String kind) {
        super(format, suffixes);
        this.kind = kind;
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        BufferedImage img = AWTImageTools.makeBuffered(image, this.cm);
        if (AWTImageTools.getPixelType(img) == 6) {
            throw new FormatException("Floating point data not supported.");
        }
        this.out = new RandomAccessOutputStream(this.currentId);
        ImageIO.write((RenderedImage)img, this.kind, this.out);
    }

    public int[] getPixelTypes() {
        return new int[]{1, 3};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
    }
}

