/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.FilterMetadata;

public class PerkinElmerReader
extends FormatReader {
    public static final String[] CFG_SUFFIX = new String[]{"cfg"};
    public static final String[] ANO_SUFFIX = new String[]{"ano"};
    public static final String[] REC_SUFFIX = new String[]{"rec"};
    public static final String[] TIM_SUFFIX = new String[]{"tim"};
    public static final String[] CSV_SUFFIX = new String[]{"csv"};
    public static final String[] ZPO_SUFFIX = new String[]{"zpo"};
    public static final String[] HTM_SUFFIX = new String[]{"htm"};
    protected MinimalTiffReader tiff;
    protected String[] files;
    private boolean isTiff = true;
    private Vector allFiles;
    private String details;
    private String sliceSpace;
    private float pixelSizeX = 1.0f;
    private float pixelSizeY = 1.0f;
    private String finishTime = null;
    private String startTime = null;
    private float originX = 0.0f;
    private float originY = 0.0f;
    private float originZ = 0.0f;

    public PerkinElmerReader() {
        super("PerkinElmer", new String[]{"ano", "cfg", "csv", "htm", "rec", "tim", "zpo"});
    }

    public boolean isThisType(String name, boolean open) {
        Location htmlFile;
        boolean binFile;
        block9: {
            if (super.isThisType(name, open)) {
                return true;
            }
            if (!open) {
                return false;
            }
            String ext = name;
            if (ext.indexOf(".") != -1) {
                ext = ext.substring(ext.lastIndexOf(".") + 1);
            }
            binFile = true;
            try {
                Integer.parseInt(ext, 16);
            }
            catch (NumberFormatException e) {
                ext = ext.toLowerCase();
                if (ext.equals("tif") || ext.equals("tiff")) break block9;
                binFile = false;
            }
        }
        String prefix = name;
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (prefix.indexOf("_") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("_"));
        }
        if (!(htmlFile = new Location(prefix + ".htm")).exists()) {
            htmlFile = new Location(prefix + ".HTM");
            while (!htmlFile.exists() && prefix.indexOf("_") != -1) {
                htmlFile = new Location((prefix = prefix.substring(0, prefix.indexOf("_"))) + ".htm");
                if (htmlFile.exists()) continue;
                htmlFile = new Location(prefix + ".HTM");
            }
        }
        return htmlFile.exists() && (binFile || super.isThisType(name, false));
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        if (this.isTiff) {
            this.tiff.setId(this.files[no / this.getSizeC()]);
            return this.tiff.openBytes(0, buf, x, y, w, h);
        }
        FormatTools.checkBufferSize(this, buf.length, w, h);
        RandomAccessStream ras = new RandomAccessStream(this.files[no]);
        ras.seek(6L);
        this.readPlane(ras, x, y, w, h, buf);
        ras.close();
        return buf;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.allFiles.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.tiff != null) {
                this.tiff.close();
            }
        } else {
            this.close();
        }
    }

    public void close() throws IOException {
        this.currentId = null;
        if (this.tiff != null) {
            this.tiff.close();
        }
        this.tiff = null;
        this.allFiles = null;
        this.files = null;
        this.sliceSpace = null;
        this.details = null;
        this.isTiff = true;
    }

    protected void initFile(String id) throws FormatException, IOException {
        SimpleDateFormat parse;
        RandomAccessStream read;
        int tNum;
        int i;
        String workingDirPath;
        if (this.currentId != null && (id.equals(this.currentId) || this.isUsedFile(id))) {
            return;
        }
        this.status("Finding HTML companion file");
        if (debug) {
            this.debug("PerkinElmerReader.initFile(" + id + ")");
        }
        if (!PerkinElmerReader.checkSuffix(id, HTM_SUFFIX)) {
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            String[] ls = parent.list();
            for (int i2 = 0; i2 < ls.length; ++i2) {
                if (!PerkinElmerReader.checkSuffix(ls[i2], HTM_SUFFIX) || ls[i2].startsWith(".")) continue;
                id = new Location(parent.getAbsolutePath(), ls[i2]).getAbsolutePath();
                break;
            }
        }
        super.initFile(id);
        this.allFiles = new Vector();
        File tmpFile = new File(id).getAbsoluteFile();
        File workingDir = tmpFile.getParentFile();
        if (workingDir == null) {
            workingDir = new File(".");
        }
        if (!(workingDirPath = workingDir.getPath()).equals("")) {
            workingDirPath = workingDirPath + File.separator;
        }
        String[] ls = workingDir.list();
        if (!new File(id).exists()) {
            ls = Location.getIdMap().keySet().toArray(new String[0]);
            workingDirPath = "";
        }
        Vector<String> v = new Vector<String>();
        for (int i3 = 0; i3 < ls.length; ++i3) {
            String file = ls[i3];
            if (file.indexOf(File.separator) != -1) {
                file = file.substring(file.lastIndexOf(File.separator) + 1);
            }
            if (file.startsWith(".")) continue;
            v.add(ls[i3]);
        }
        ls = v.toArray(new String[0]);
        this.status("Searching for all metadata companion files");
        int cfgPos = -1;
        int anoPos = -1;
        int recPos = -1;
        int timPos = -1;
        int csvPos = -1;
        int zpoPos = -1;
        int htmPos = -1;
        int filesPt = 0;
        this.files = new String[ls.length];
        int dot = id.lastIndexOf(".");
        String check = dot < 0 ? id : id.substring(0, dot);
        check = check.substring(check.lastIndexOf(File.separator) + 1);
        String prefix = null;
        Location tempFile = null;
        for (int i4 = 0; i4 < ls.length; ++i4) {
            String s;
            int d = ls[i4].lastIndexOf(".");
            while (d == -1 && i4 < ls.length - 1) {
                d = ls[++i4].lastIndexOf(".");
            }
            String string = s = d < 0 ? ls[i4] : ls[i4].substring(0, d);
            if (!s.startsWith(check) && !check.startsWith(s) && (prefix == null || !s.startsWith(prefix))) continue;
            if (cfgPos == -1 && PerkinElmerReader.checkSuffix(ls[i4], CFG_SUFFIX)) {
                cfgPos = i4;
                prefix = ls[i4].substring(0, d);
            }
            if (anoPos == -1 && PerkinElmerReader.checkSuffix(ls[i4], ANO_SUFFIX)) {
                anoPos = i4;
                prefix = ls[i4].substring(0, d);
            }
            if (recPos == -1 && PerkinElmerReader.checkSuffix(ls[i4], REC_SUFFIX)) {
                recPos = i4;
                prefix = ls[i4].substring(0, d);
            }
            if (timPos == -1 && PerkinElmerReader.checkSuffix(ls[i4], TIM_SUFFIX)) {
                timPos = i4;
                prefix = ls[i4].substring(0, d);
            }
            if (csvPos == -1 && PerkinElmerReader.checkSuffix(ls[i4], CSV_SUFFIX)) {
                csvPos = i4;
                prefix = ls[i4].substring(0, d);
            }
            if (zpoPos == -1 && PerkinElmerReader.checkSuffix(ls[i4], ZPO_SUFFIX)) {
                zpoPos = i4;
                prefix = ls[i4].substring(0, d);
            }
            if (htmPos == -1 && PerkinElmerReader.checkSuffix(ls[i4], HTM_SUFFIX)) {
                htmPos = i4;
                prefix = ls[i4].substring(0, d);
            }
            if (PerkinElmerReader.checkSuffix(ls[i4], TiffReader.TIFF_SUFFIXES)) {
                this.files[filesPt] = workingDirPath + ls[i4];
                ++filesPt;
            }
            try {
                String ext = ls[i4].substring(ls[i4].lastIndexOf(".") + 1);
                Integer.parseInt(ext, 16);
                this.isTiff = false;
                this.files[filesPt] = workingDirPath + ls[i4];
                ++filesPt;
                continue;
            }
            catch (NumberFormatException exc) {
                if (!debug) continue;
                this.trace(exc);
            }
        }
        String[] tempFiles = this.files;
        this.files = new String[filesPt];
        this.status("Finding image files");
        int extCount = 0;
        Vector<String> foundExts = new Vector<String>();
        for (i = 0; i < filesPt; ++i) {
            String ext = tempFiles[i].substring(tempFiles[i].lastIndexOf(".") + 1);
            if (foundExts.contains(ext)) continue;
            ++extCount;
            foundExts.add(ext);
        }
        for (i = 0; i < filesPt; i += extCount) {
            Vector<String> extSet = new Vector<String>();
            for (int j = 0; j < extCount; ++j) {
                if (extSet.size() == 0) {
                    extSet.add(tempFiles[i + j]);
                    continue;
                }
                if (tempFiles[i + j] == null) continue;
                String ext = tempFiles[i + j].substring(tempFiles[i + j].lastIndexOf(".") + 1);
                int extNum = Integer.parseInt(ext, 16);
                int insert = -1;
                for (int pos = 0; insert == -1 && pos < extSet.size(); ++pos) {
                    String posString = (String)extSet.get(pos);
                    int posNum = Integer.parseInt(posString = posString.substring(posString.lastIndexOf(".") + 1), 16);
                    if (extNum >= posNum) continue;
                    insert = pos;
                }
                if (insert == -1) {
                    extSet.add(tempFiles[i + j]);
                    continue;
                }
                extSet.add(insert, tempFiles[i + j]);
            }
            int length = Math.min(extCount, extSet.size());
            for (int j = 0; j < length; ++j) {
                this.files[i + j] = (String)extSet.get(j);
            }
        }
        for (i = 0; i < this.files.length; ++i) {
            this.allFiles.add(this.files[i]);
        }
        if (this.isTiff) {
            Arrays.sort(this.files);
        } else {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int cmp;
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    String prefix1 = s1;
                    String prefix2 = s2;
                    String suffix1 = s1;
                    String suffix2 = s2;
                    if (s1.indexOf(".") != -1) {
                        prefix1 = s1.substring(0, s1.lastIndexOf("."));
                        suffix1 = s1.substring(s1.lastIndexOf(".") + 1);
                    }
                    if (s2.indexOf(".") != -1) {
                        prefix2 = s2.substring(0, s2.lastIndexOf("."));
                        suffix2 = s2.substring(s2.lastIndexOf(".") + 1);
                    }
                    if ((cmp = prefix1.compareTo(prefix2)) != 0) {
                        return cmp;
                    }
                    return Integer.parseInt(suffix1, 16) - Integer.parseInt(suffix2, 16);
                }
            };
            Arrays.sort(this.files, c);
        }
        this.core[0].imageCount = this.files.length;
        this.tiff = new MinimalTiffReader();
        this.status("Parsing metadata values");
        if (cfgPos != -1) {
            tempFile = new Location(workingDirPath, ls[cfgPos]);
            if (!workingDirPath.equals("")) {
                this.allFiles.add(tempFile.getAbsolutePath());
            } else {
                this.allFiles.add(ls[cfgPos]);
            }
        }
        if (anoPos != -1) {
            tempFile = new Location(workingDirPath, ls[anoPos]);
            if (!workingDirPath.equals("")) {
                this.allFiles.add(tempFile.getAbsolutePath());
            } else {
                this.allFiles.add(ls[anoPos]);
            }
        }
        if (recPos != -1) {
            tempFile = new Location(workingDirPath, ls[recPos]);
            if (!workingDirPath.equals("")) {
                this.allFiles.add(tempFile.getAbsolutePath());
            } else {
                this.allFiles.add(ls[recPos]);
            }
        }
        if (timPos != -1) {
            tempFile = new Location(workingDirPath, ls[timPos]);
            if (!workingDirPath.equals("")) {
                this.allFiles.add(tempFile.getAbsolutePath());
            } else {
                this.allFiles.add(ls[timPos]);
            }
            RandomAccessStream read2 = new RandomAccessStream((String)this.allFiles.get(this.allFiles.size() - 1));
            StringTokenizer t = new StringTokenizer(read2.readString((int)read2.length()));
            String[] hashKeys = new String[]{"Number of Wavelengths/Timepoints", "Zero 1", "Zero 2", "Number of slices", "Extra int", "Calibration Unit", "Pixel Size Y", "Pixel Size X", "Image Width", "Image Length", "Origin X", "SubfileType X", "Dimension Label X", "Origin Y", "SubfileType Y", "Dimension Label Y", "Origin Z", "SubfileType Z", "Dimension Label Z"};
            for (tNum = 0; t.hasMoreTokens() && tNum < hashKeys.length; ++tNum) {
                String token = t.nextToken();
                if (token.equals("um")) {
                    tNum = 5;
                }
                while (!(tNum != 1 && tNum != 2 || token.trim().equals("0"))) {
                    ++tNum;
                }
                if (tNum == 4) {
                    try {
                        Integer.parseInt(token);
                    }
                    catch (NumberFormatException e) {}
                }
                int n = ++tNum;
                this.parseKeyValue(hashKeys[n], token);
            }
            read2.close();
        }
        if (csvPos != -1) {
            tempFile = new Location(workingDirPath, ls[csvPos]);
            if (!workingDirPath.equals("")) {
                this.allFiles.add(tempFile.getAbsolutePath());
            } else {
                this.allFiles.add(ls[csvPos]);
            }
            RandomAccessStream read3 = new RandomAccessStream((String)this.allFiles.get(this.allFiles.size() - 1));
            StringTokenizer t = new StringTokenizer(read3.readString((int)read3.length()));
            tNum = 0;
            String[] hashKeys = new String[]{"Calibration Unit", "Pixel Size X", "Pixel Size Y", "Z slice space"};
            int pt = 0;
            while (t.hasMoreTokens()) {
                String key = null;
                String value = null;
                if (tNum < 7) {
                    t.nextToken();
                } else if (tNum > 7 && tNum < 12 || tNum > 12 && tNum < 18 || tNum > 18 && tNum < 22) {
                    t.nextToken();
                } else if (pt < hashKeys.length) {
                    key = hashKeys[pt];
                    value = t.nextToken();
                    ++pt;
                } else {
                    key = t.nextToken() + t.nextToken();
                    value = t.nextToken();
                }
                this.parseKeyValue(key, value);
                ++tNum;
            }
            read3.close();
        }
        if (zpoPos != -1) {
            tempFile = new Location(workingDirPath, ls[zpoPos]);
            if (!workingDirPath.equals("")) {
                this.allFiles.add(tempFile.getAbsolutePath());
            } else {
                this.allFiles.add(ls[zpoPos]);
            }
            if (csvPos < 0) {
                RandomAccessStream read4 = new RandomAccessStream((String)this.allFiles.get(this.allFiles.size() - 1));
                StringTokenizer t = new StringTokenizer(read4.readString((int)read4.length()));
                tNum = 0;
                while (t.hasMoreTokens()) {
                    this.addMeta("Z slice #" + tNum + " position", t.nextToken());
                    ++tNum;
                }
                read4.close();
            }
        }
        Vector<Float> exposureTimes = new Vector<Float>();
        Vector<Float> zPositions = new Vector<Float>();
        Vector<Integer> emWaves = new Vector<Integer>();
        Vector<Integer> exWaves = new Vector<Integer>();
        if (htmPos != -1) {
            int j;
            String[] tokens;
            block119: {
                tempFile = new Location(workingDirPath, ls[htmPos]);
                if (!workingDirPath.equals("")) {
                    this.allFiles.add(tempFile.getAbsolutePath());
                } else {
                    this.allFiles.add(ls[htmPos]);
                }
                read = new RandomAccessStream((String)this.allFiles.get(this.allFiles.size() - 1));
                byte[] data = new byte[(int)read.length()];
                read.read(data);
                String regex = "<p>|</p>|<br>|<hr>|<b>|</b>|<HTML>|<HEAD>|</HTML>|</HEAD>|<h1>|</h1>|<HR>|</body>";
                Class c = String.class;
                tokens = new String[]{};
                Object th = null;
                try {
                    Method split = c.getMethod("split", c);
                    tokens = (String[])split.invoke((Object)new String(data), regex);
                }
                catch (NoSuchMethodException exc) {
                    if (debug) {
                        this.trace(exc);
                    }
                }
                catch (IllegalAccessException exc) {
                    if (debug) {
                        this.trace(exc);
                    }
                }
                catch (InvocationTargetException exc) {
                    if (!debug) break block119;
                    this.trace(exc);
                }
            }
            for (j = 0; j < tokens.length; ++j) {
                if (tokens[j].indexOf("<") == -1) continue;
                tokens[j] = "";
            }
            for (j = 0; j < tokens.length - 1; j += 2) {
                if (tokens[j].indexOf("Exposure") != -1) {
                    this.addMeta("Camera Data " + tokens[j].charAt(13), tokens[j]);
                    int ndx = tokens[j].indexOf("Exposure") + 9;
                    String exposure = tokens[j].substring(ndx, tokens[j].indexOf(" ", ndx)).trim();
                    if (exposure.endsWith(",")) {
                        exposure = exposure.substring(0, exposure.length() - 1);
                    }
                    exposureTimes.add(new Float(Float.parseFloat(exposure) / 1000.0f));
                    if (tokens[j].indexOf("nm") != -1) {
                        int nmIndex = tokens[j].indexOf("nm");
                        int paren = tokens[j].lastIndexOf("(", nmIndex);
                        int slash = tokens[j].lastIndexOf("/", nmIndex);
                        if (slash == -1) {
                            slash = nmIndex;
                        }
                        emWaves.add(new Integer(tokens[j].substring(paren + 1, slash).trim()));
                        if (tokens[j].indexOf("nm", nmIndex + 3) != -1) {
                            nmIndex = tokens[j].indexOf("nm", nmIndex + 3);
                            paren = tokens[j].lastIndexOf(" ", nmIndex);
                            slash = tokens[j].lastIndexOf("/", nmIndex);
                            if (slash == -1) {
                                slash = nmIndex + 2;
                            }
                            exWaves.add(new Integer(tokens[j].substring(paren + 1, slash).trim()));
                        }
                    }
                    --j;
                    continue;
                }
                if (tokens[j + 1].trim().equals("Slice Z positions")) {
                    for (int q = j + 2; q < tokens.length; ++q) {
                        if (tokens[q].trim().equals("")) continue;
                        zPositions.add(new Float(tokens[q].trim()));
                    }
                    continue;
                }
                if (tokens[j].trim().equals("")) continue;
                tokens[j] = tokens[j].trim();
                tokens[j + 1] = tokens[j + 1].trim();
                this.parseKeyValue(tokens[j], tokens[j + 1]);
            }
        } else {
            throw new FormatException("Valid header files not found.");
        }
        read.close();
        if (this.details != null) {
            StringTokenizer t = new StringTokenizer(this.details);
            int tokenNum = 0;
            String prevToken = "";
            while (t.hasMoreTokens()) {
                String token = t.nextToken();
                if (token.equals("Wavelengths")) {
                    this.core[0].sizeC = Integer.parseInt(prevToken);
                } else if (token.equals("Frames")) {
                    this.core[0].sizeT = Integer.parseInt(prevToken);
                } else if (token.equals("Slices")) {
                    this.core[0].sizeZ = Integer.parseInt(prevToken);
                }
                ++tokenNum;
                prevToken = token;
            }
        }
        this.status("Populating metadata");
        if (this.isTiff) {
            this.tiff.setId(this.files[0]);
            this.core[0].pixelType = this.tiff.getPixelType();
        } else {
            RandomAccessStream tmp = new RandomAccessStream(this.files[0]);
            int bpp = (int)(tmp.length() - 6L) / (this.getSizeX() * this.getSizeY());
            tmp.close();
            switch (bpp) {
                case 1: 
                case 3: {
                    this.core[0].pixelType = 1;
                    break;
                }
                case 2: {
                    this.core[0].pixelType = 3;
                    break;
                }
                case 4: {
                    this.core[0].pixelType = 5;
                }
            }
        }
        if (this.getSizeZ() <= 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() <= 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() <= 0) {
            this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
        } else {
            this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            if (this.getImageCount() > this.files.length) {
                this.core[0].imageCount = this.files.length;
                this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
            }
        }
        int calcCount = this.getSizeZ() * this.getEffectiveSizeC() * this.getSizeT();
        if (this.files.length > this.getImageCount() || this.getImageCount() != calcCount) {
            this.status("Removing extraneous files");
            String[] tmpFiles = this.files;
            int imageCount = Math.min(this.getImageCount(), calcCount);
            this.files = new String[imageCount];
            Hashtable<String, Integer> zSections = new Hashtable<String, Integer>();
            for (int i5 = 0; i5 < tmpFiles.length; ++i5) {
                int dotIndex;
                int underscore = tmpFiles[i5].lastIndexOf("_");
                String z = tmpFiles[i5].substring(underscore + 1, dotIndex = tmpFiles[i5].lastIndexOf("."));
                if (zSections.get(z) == null) {
                    zSections.put(z, new Integer(1));
                    continue;
                }
                int count = (Integer)zSections.get(z) + 1;
                zSections.put(z, new Integer(count));
            }
            int nextFile = 0;
            int oldFile = 0;
            Arrays.sort(tmpFiles, new PEComparator());
            Object[] keys = zSections.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i6 = 0; i6 < keys.length; ++i6) {
                int oldCount = (Integer)zSections.get(keys[i6]);
                int nPlanes = (this.isTiff ? this.tiff.getEffectiveSizeC() : this.getSizeC()) * this.getSizeT();
                int count = Math.min(oldCount, nPlanes);
                for (int j = 0; j < count; ++j) {
                    this.files[nextFile++] = tmpFiles[oldFile++];
                }
                if (count >= oldCount) continue;
                oldFile += oldCount - count;
            }
            this.core[0].imageCount = this.getSizeZ() * this.getEffectiveSizeC() * this.getSizeT();
        }
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].rgb = this.isTiff ? this.tiff.isRGB() : false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = this.isTiff ? this.tiff.isLittleEndian() : true;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = this.isTiff ? this.tiff.isIndexed() : false;
        this.core[0].falseColor = false;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), 0, 0);
        store.setImageName("", 0);
        if (this.finishTime != null) {
            SimpleDateFormat parse2 = new SimpleDateFormat("HH:mm:ss (MM/dd/yyyy)");
            Date date = parse2.parse(this.finishTime, new ParsePosition(0));
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.finishTime = fmt.format(date);
            store.setImageCreationDate(this.finishTime, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        for (int i7 = 0; i7 < this.getSizeC(); ++i7) {
            if (i7 < emWaves.size()) {
                store.setLogicalChannelEmWave((Integer)emWaves.get(i7), 0, i7);
            }
            if (i7 >= exWaves.size()) continue;
            store.setLogicalChannelExWave((Integer)exWaves.get(i7), 0, i7);
        }
        long start = 0L;
        long end = 0L;
        if (this.startTime != null) {
            parse = new SimpleDateFormat("HH:mm:ss (MM/dd/yyyy)");
            Date date = parse.parse(this.startTime, new ParsePosition(0));
            start = date.getTime();
        }
        if (this.finishTime != null) {
            parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date date = parse.parse(this.finishTime, new ParsePosition(0));
            end = date.getTime();
        }
        long range = end - start;
        float msPerPlane = (float)range / (float)this.getImageCount();
        int plane = 0;
        for (int zi = 0; zi < this.getSizeZ(); ++zi) {
            for (int ti = 0; ti < this.getSizeT(); ++ti) {
                for (int ci = 0; ci < this.getSizeC(); ++ci) {
                    store.setPlaneTimingDeltaT(new Float((float)plane * msPerPlane / 1000.0f), 0, 0, plane);
                    if (ci < exposureTimes.size()) {
                        store.setPlaneTimingExposureTime((Float)exposureTimes.get(ci), 0, 0, plane);
                    }
                    ++plane;
                }
            }
        }
        for (int i8 = 0; i8 < this.getImageCount(); ++i8) {
            int[] zct = this.getZCTCoords(i8);
            if (zct[0] >= zPositions.size()) continue;
            store.setStagePositionPositionX(new Float(0.0), 0, 0, plane);
            store.setStagePositionPositionY(new Float(0.0), 0, 0, plane);
            store.setStagePositionPositionZ((Float)zPositions.get(zct[0]), 0, 0, plane);
        }
    }

    private void parseKeyValue(String key, String value) {
        block26: {
            if (key == null || value == null) {
                return;
            }
            this.addMeta(key, value);
            try {
                if (key.equals("Image Width")) {
                    this.core[0].sizeX = Integer.parseInt(value);
                } else if (key.equals("Image Length")) {
                    this.core[0].sizeY = Integer.parseInt(value);
                } else if (key.equals("Number of slices")) {
                    this.core[0].sizeZ = Integer.parseInt(value);
                } else if (key.equals("Experiment details:")) {
                    this.details = value;
                } else if (key.equals("Z slice space")) {
                    this.sliceSpace = value;
                } else if (key.equals("Pixel Size X")) {
                    this.pixelSizeX = Float.parseFloat(value);
                } else if (key.equals("Pixel Size Y")) {
                    this.pixelSizeY = Float.parseFloat(value);
                } else if (key.equals("Finish Time:")) {
                    this.finishTime = value;
                } else if (key.equals("Start Time:")) {
                    this.startTime = value;
                } else if (key.equals("Origin X")) {
                    this.originX = Float.parseFloat(value);
                } else if (key.equals("Origin Y")) {
                    this.originY = Float.parseFloat(value);
                } else if (key.equals("Origin Z")) {
                    this.originZ = Float.parseFloat(value);
                }
            }
            catch (NumberFormatException exc) {
                if (!debug) break block26;
                LogTools.trace(exc);
            }
        }
    }

    class PEComparator
    implements Comparator {
        PEComparator() {
        }

        public int compare(Object o1, Object o2) {
            int z2;
            String prefix2;
            String s2;
            String s1 = o1.toString();
            if (s1.equals(s2 = o2.toString())) {
                return 0;
            }
            int underscore1 = s1.lastIndexOf("_");
            int underscore2 = s2.lastIndexOf("_");
            int dot1 = s1.lastIndexOf(".");
            int dot2 = s2.lastIndexOf(".");
            String prefix1 = s1.substring(0, underscore1);
            if (!prefix1.equals(prefix2 = s2.substring(0, underscore2))) {
                return prefix1.compareTo(prefix2);
            }
            int z1 = Integer.parseInt(s1.substring(underscore1 + 1, dot1));
            if (z1 < (z2 = Integer.parseInt(s2.substring(underscore2 + 1, dot2)))) {
                return -1;
            }
            if (z2 < z1) {
                return 1;
            }
            try {
                int ext1 = Integer.parseInt(s1.substring(dot1 + 1), 16);
                int ext2 = Integer.parseInt(s2.substring(dot2 + 1), 16);
                if (ext1 < ext2) {
                    return -1;
                }
                return 1;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        public boolean equals(Object o) {
            return this.compare(this, o) == 0;
        }
    }
}

