/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffIFDEntry;
import loci.formats.TiffRational;
import loci.formats.TiffTools;
import loci.formats.UnknownTagException;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetamorphHandler;
import loci.formats.meta.FilterMetadata;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphReader
extends BaseTiffReader {
    public static final String[] ND_SUFFIX = new String[]{"nd"};
    public static final String[] STK_SUFFIX = new String[]{"stk", "tif", "tiff"};
    private static final int METAMORPH_ID = 33628;
    private static final int UIC1TAG = 33628;
    private static final int UIC2TAG = 33629;
    private static final int UIC3TAG = 33630;
    private static final int UIC4TAG = 33631;
    private static final String DATE_FORMAT = "yyyyMMdd HH:mm:ss.SSS";
    private String imageName;
    private String imageCreationDate;
    private long[] emWavelength;
    private double[] wave;
    private String binning;
    private float zoom;
    private float stepSize;
    private Float exposureTime;
    private Vector waveNames;
    private long[] internalStamps;
    private double[] zDistances;
    private double[] stageX;
    private double[] stageY;
    private int mmPlanes;
    private MetamorphReader stkReader;
    private String[][] stks;
    private String ndFilename;

    public MetamorphReader() {
        super("Metamorph STK", new String[]{"stk", "nd"});
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            return 0;
        }
        Location l = new Location(id).getAbsoluteFile();
        String[] files = l.getParentFile().list();
        for (int i = 0; i < files.length; ++i) {
            if (!MetamorphReader.checkSuffix(files[i], ND_SUFFIX) || !id.startsWith(files[i].substring(0, files[i].lastIndexOf(".")))) continue;
            return 0;
        }
        return 2;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null) {
            return super.getUsedFiles();
        }
        Vector<String> v = new Vector<String>();
        if (this.ndFilename != null) {
            v.add(this.ndFilename);
        }
        for (int i = 0; i < this.stks.length; ++i) {
            for (int j = 0; j < this.stks[i].length; ++j) {
                v.add(this.stks[i][j]);
            }
        }
        return v.toArray(new String[0]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        int[] coords = FormatTools.getZCTCoords(this, no % this.getSizeZ());
        int ndx = no / this.getSizeZ();
        if (this.stks[this.series].length == 1) {
            ndx = 0;
        }
        String file = this.stks[this.series][ndx];
        if (this.stkReader == null) {
            this.stkReader = new MetamorphReader();
        }
        this.stkReader.setId(file);
        int plane = this.stks[this.series].length == 1 ? no : coords[0];
        return this.stkReader.openBytes(plane, buf, x, y, w, h);
    }

    public void close() throws IOException {
        super.close();
        if (this.stkReader != null) {
            this.stkReader.close();
        }
        this.stkReader = null;
        this.imageCreationDate = null;
        this.imageName = null;
        this.emWavelength = null;
        this.stks = null;
        this.mmPlanes = 0;
        this.ndFilename = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int i2;
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            this.status("Initializing " + id);
            String stkFile = id.substring(0, id.lastIndexOf("."));
            if (stkFile.indexOf(File.separator) != -1) {
                stkFile = stkFile.substring(stkFile.lastIndexOf(File.separator) + 1);
            }
            String parentPath = id.substring(0, id.lastIndexOf(File.separator) + 1);
            Location parent = new Location(parentPath).getAbsoluteFile();
            this.status("Looking for STK file in " + parent.getAbsolutePath());
            String[] dirList = parent.list();
            for (int i3 = 0; i3 < dirList.length; ++i3) {
                if (dirList[i3].indexOf(stkFile) == -1 || !MetamorphReader.checkSuffix(dirList[i3], STK_SUFFIX)) continue;
                stkFile = new Location(parent.getAbsolutePath(), dirList[i3]).getAbsolutePath();
                break;
            }
            if (!MetamorphReader.checkSuffix(stkFile, STK_SUFFIX)) {
                throw new FormatException("STK file not found in " + parent.getAbsolutePath() + ".");
            }
            super.initFile(stkFile);
        } else {
            super.initFile(id);
        }
        Location ndfile = null;
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            ndfile = new Location(id);
        }
        String creationTime = null;
        if (ndfile != null && ndfile.exists() && (this.fileGroupOption(id) == 0 || this.isGroupFiles())) {
            this.ndFilename = ndfile.getAbsolutePath();
            RandomAccessStream ndStream = new RandomAccessStream(this.ndFilename);
            String line = ndStream.readLine().trim();
            int zc = this.getSizeZ();
            int cc = this.getSizeC();
            int tc = this.getSizeT();
            String z = null;
            String c = null;
            String t = null;
            Vector<Boolean> hasZ = new Vector<Boolean>();
            this.waveNames = new Vector();
            while (!line.equals("\"EndFile\"")) {
                String key = line.substring(1, line.indexOf(",") - 1).trim();
                String value = line.substring(line.indexOf(",") + 1).trim();
                this.addMeta(key, value);
                if (key.equals("NZSteps")) {
                    z = value;
                } else if (key.equals("NWavelengths")) {
                    c = value;
                } else if (key.equals("NTimePoints")) {
                    t = value;
                } else if (key.startsWith("WaveDoZ")) {
                    hasZ.add(new Boolean(value.toLowerCase()));
                } else if (key.startsWith("WaveName")) {
                    this.waveNames.add(value);
                } else if (key.startsWith("StartTime")) {
                    creationTime = value;
                } else if (key.equals("ZStepSize")) {
                    this.stepSize = Float.parseFloat(value);
                }
                line = ndStream.readLine().trim();
            }
            if (z != null) {
                zc = Integer.parseInt(z);
            }
            if (c != null) {
                cc = Integer.parseInt(c);
            }
            if (t != null) {
                tc = Integer.parseInt(t);
            }
            int numFiles = cc * tc;
            int seriesCount = 1;
            for (int i4 = 0; i4 < cc; ++i4) {
                boolean hasZ2;
                boolean hasZ1 = (Boolean)hasZ.get(i4);
                boolean bl = hasZ2 = i4 != 0 && (Boolean)hasZ.get(i4 - 1) != false;
                if (i4 <= 0 || hasZ1 == hasZ2) continue;
                seriesCount = 2;
            }
            int channelsInFirstSeries = cc;
            if (seriesCount == 2) {
                channelsInFirstSeries = 0;
                for (int i5 = 0; i5 < cc; ++i5) {
                    if (!((Boolean)hasZ.get(i5)).booleanValue()) continue;
                    ++channelsInFirstSeries;
                }
            }
            this.stks = new String[seriesCount][];
            if (seriesCount == 1) {
                this.stks[0] = new String[numFiles];
            } else {
                this.stks[0] = new String[channelsInFirstSeries * tc];
                this.stks[1] = new String[(cc - channelsInFirstSeries) * tc];
            }
            String prefix = ndfile.getPath();
            prefix = prefix.substring(prefix.lastIndexOf(File.separator) + 1, prefix.lastIndexOf("."));
            for (int i6 = 0; i6 < cc; ++i6) {
                if (this.waveNames.get(i6) == null) continue;
                String name = (String)this.waveNames.get(i6);
                this.waveNames.setElementAt(name.substring(1, name.length() - 1), i6);
            }
            int[] pt = new int[seriesCount];
            for (int i7 = 0; i7 < tc; ++i7) {
                for (int j = 0; j < cc; ++j) {
                    boolean validZ = (Boolean)hasZ.get(j);
                    int seriesNdx = seriesCount == 1 || validZ ? 0 : 1;
                    this.stks[seriesNdx][pt[seriesNdx]] = prefix;
                    if (this.waveNames.get(j) != null) {
                        String[] stringArray = this.stks[seriesNdx];
                        int n = pt[seriesNdx];
                        stringArray[n] = stringArray[n] + "_w" + (j + 1) + this.waveNames.get(j);
                    }
                    String[] stringArray = this.stks[seriesNdx];
                    int n = pt[seriesNdx];
                    stringArray[n] = stringArray[n] + "_t" + (i7 + 1) + ".STK";
                    int n2 = seriesNdx;
                    pt[n2] = pt[n2] + 1;
                }
            }
            ndfile = ndfile.getAbsoluteFile();
            for (int s = 0; s < this.stks.length; ++s) {
                for (int f = 0; f < this.stks[s].length; ++f) {
                    Location l = new Location(ndfile.getParent(), this.stks[s][f]);
                    if (!l.exists()) {
                        if (this.stks[s][f].indexOf("%") != -1) {
                            this.stks[s][f] = this.stks[s][f].replaceAll("%", "-");
                            l = new Location(ndfile.getParent(), this.stks[s][f]);
                            if (!l.exists()) {
                                this.stks[s][f] = this.stks[s][f].substring(0, this.stks[s][f].lastIndexOf(".")) + ".TIF";
                                l = new Location(ndfile.getParent(), this.stks[s][f]);
                                if (!l.exists()) {
                                    String filename = this.stks[s][f];
                                    this.stks = null;
                                    throw new FormatException("Missing STK file: " + filename);
                                }
                            }
                        }
                        if (!l.exists()) {
                            this.stks[s][f] = this.stks[s][f].substring(0, this.stks[s][f].lastIndexOf(".")) + ".TIF";
                            l = new Location(ndfile.getParent(), this.stks[s][f]);
                            if (!l.exists()) {
                                String filename = this.stks[s][f];
                                this.stks = null;
                                throw new FormatException("Missing STK file: " + filename);
                            }
                        }
                    }
                    if (this.stks == null) break;
                    this.stks[s][f] = l.getAbsolutePath();
                }
                if (this.stks == null) break;
            }
            this.core[0].sizeZ = zc;
            this.core[0].sizeC = cc;
            this.core[0].sizeT = tc;
            this.core[0].imageCount = zc * tc * cc;
            this.core[0].dimensionOrder = "XYZCT";
            if (this.stks != null && this.stks.length > 1) {
                CoreMetadata[] newCore = new CoreMetadata[this.stks.length];
                for (int i8 = 0; i8 < this.stks.length; ++i8) {
                    newCore[i8] = new CoreMetadata();
                    newCore[i8].sizeX = this.getSizeX();
                    newCore[i8].sizeY = this.getSizeY();
                    newCore[i8].sizeZ = this.getSizeZ();
                    newCore[i8].sizeC = this.getSizeC();
                    newCore[i8].sizeT = this.getSizeT();
                    newCore[i8].pixelType = this.getPixelType();
                    newCore[i8].imageCount = this.getImageCount();
                    newCore[i8].dimensionOrder = this.getDimensionOrder();
                    newCore[i8].rgb = this.isRGB();
                    newCore[i8].littleEndian = this.isLittleEndian();
                    newCore[i8].interleaved = this.isInterleaved();
                    newCore[i8].orderCertain = true;
                }
                newCore[0].sizeC = this.stks[0].length / this.getSizeT();
                newCore[1].sizeC = this.stks[1].length / newCore[1].sizeT;
                newCore[1].sizeZ = 1;
                newCore[0].imageCount = newCore[0].sizeC * newCore[0].sizeT * newCore[0].sizeZ;
                newCore[1].imageCount = newCore[1].sizeC * newCore[1].sizeT;
                this.core = newCore;
            }
        }
        String comment = TiffTools.getComment(this.ifds[0]);
        MetamorphHandler handler = new MetamorphHandler(this.getMetadata());
        if (comment != null && comment.startsWith("<MetaData>")) {
            DataTools.parseXML(comment, (DefaultHandler)handler);
        }
        Vector timestamps = handler.getTimestamps();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            if (creationTime != null) {
                store.setImageCreationDate(DataTools.formatDate(creationTime, "yyyyMMdd HH:mm:ss"), 0);
            } else if (i2 > 0) {
                MetadataTools.setDefaultCreationDate(store, id, i2);
            }
            if (i2 == 0) {
                store.setImageName(handler.getImageName(), 0);
            } else {
                store.setImageName("", i2);
            }
            store.setImageDescription("", i2);
        }
        for (i2 = 0; i2 < timestamps.size(); ++i2) {
            this.addMeta("timestamp " + i2, DataTools.formatDate((String)timestamps.get(i2), DATE_FORMAT));
        }
        long startDate = 0L;
        if (timestamps.size() > 0) {
            startDate = DataTools.getTime((String)timestamps.get(0), DATE_FORMAT);
        }
        Float positionX = new Float(handler.getStagePositionX());
        Float positionY = new Float(handler.getStagePositionY());
        Vector exposureTimes = handler.getExposures();
        if (exposureTimes.size() == 0) {
            for (i = 0; i < this.getImageCount(); ++i) {
                exposureTimes.add(this.exposureTime);
            }
        }
        for (i = 0; i < this.getImageCount(); ++i) {
            int[] coords = this.getZCTCoords(i);
            if (coords[2] < timestamps.size()) {
                String stamp = (String)timestamps.get(coords[2]);
                long ms = DataTools.getTime(stamp, DATE_FORMAT);
                store.setPlaneTimingDeltaT(new Float((float)(ms - startDate) / 1000.0f), 0, 0, i);
                store.setPlaneTimingExposureTime((Float)exposureTimes.get(i), 0, 0, i);
            } else if (this.internalStamps != null && i < this.internalStamps.length) {
                long delta = this.internalStamps[i] - this.internalStamps[0];
                store.setPlaneTimingDeltaT(new Float((float)delta / 1000.0f), 0, 0, i);
                store.setPlaneTimingExposureTime((Float)exposureTimes.get(i), 0, 0, i);
            }
            if (this.stageX != null && i < this.stageX.length) {
                store.setStagePositionPositionX(new Float((float)this.stageX[i]), 0, 0, i);
            }
            if (this.stageY == null || i >= this.stageY.length) continue;
            store.setStagePositionPositionY(new Float((float)this.stageY[i]), 0, 0, i);
        }
        store.setImagingEnvironmentTemperature(new Float(handler.getTemperature()), 0);
        store.setDimensionsPhysicalSizeX(new Float(handler.getPixelSizeX()), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(handler.getPixelSizeY()), 0, 0);
        if (this.zDistances != null) {
            this.stepSize = (float)this.zDistances[0];
        }
        store.setDimensionsPhysicalSizeZ(new Float(this.stepSize), 0, 0);
        for (i = 0; i < this.getEffectiveSizeC(); ++i) {
            if (this.waveNames != null && i < this.waveNames.size()) {
                store.setLogicalChannelName((String)this.waveNames.get(i), 0, i);
            }
            store.setDetectorSettingsBinning(this.binning, 0, i);
            if (handler.getBinning() != null) {
                store.setDetectorSettingsBinning(handler.getBinning(), 0, i);
            }
            if (handler.getReadOutRate() != 0.0f) {
                store.setDetectorSettingsReadOutRate(new Float(handler.getReadOutRate()), 0, i);
            }
            store.setDetectorSettingsDetector("Detector:0", 0, i);
            int index = this.getIndex(0, i, 0);
            if (this.wave == null || index >= this.wave.length || (int)this.wave[index] < 1) continue;
            store.setLightSourceSettingsWavelength(new Integer((int)this.wave[index]), 0, i);
            store.setLightSourceID("LightSource:" + i, 0, i);
            store.setLightSourceSettingsLightSource("LightSource:" + i, 0, i);
            store.setLaserType("Unknown", 0, i);
        }
        store.setDetectorID("Detector:0", 0, 0);
        store.setDetectorZoom(new Float(this.zoom), 0, 0);
        if (handler.getZoom() != 0.0f) {
            store.setDetectorZoom(new Float(handler.getZoom()), 0, 0);
        }
        store.setDetectorType("Unknown", 0, 0);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        block35: {
            block34: {
                super.initStandardMetadata();
                try {
                    int check;
                    TiffRational[] tiffRationalArray;
                    TiffIFDEntry uic1tagEntry = TiffTools.getFirstIFDEntry(this.in, 33628);
                    TiffIFDEntry uic2tagEntry = TiffTools.getFirstIFDEntry(this.in, 33629);
                    TiffIFDEntry uic4tagEntry = TiffTools.getFirstIFDEntry(this.in, 33631);
                    this.mmPlanes = uic4tagEntry.getValueCount();
                    this.parseUIC2Tags(uic2tagEntry.getValueOffset());
                    this.parseUIC4Tags(uic4tagEntry.getValueOffset());
                    this.parseUIC1Tags(uic1tagEntry.getValueOffset(), uic1tagEntry.getValueCount());
                    this.in.seek(uic4tagEntry.getValueOffset());
                    long[] uic2 = TiffTools.getIFDLongArray(this.ifds[0], 33629, true);
                    this.core[0].imageCount = uic2.length;
                    Object entry = TiffTools.getIFDValue(this.ifds[0], 33630);
                    if (entry instanceof TiffRational[]) {
                        tiffRationalArray = (TiffRational[])entry;
                    } else {
                        TiffRational[] tiffRationalArray2 = new TiffRational[1];
                        tiffRationalArray = tiffRationalArray2;
                        tiffRationalArray2[0] = (TiffRational)entry;
                    }
                    TiffRational[] uic3 = tiffRationalArray;
                    this.wave = new double[uic3.length];
                    for (int i = 0; i < uic3.length; ++i) {
                        this.wave[i] = uic3[i].doubleValue();
                        this.addMeta("Wavelength [" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.wave[i]);
                    }
                    Hashtable[] tempIFDs = new Hashtable[this.getImageCount()];
                    long[] oldOffsets = TiffTools.getStripOffsets(this.ifds[0]);
                    long[] stripByteCounts = TiffTools.getStripByteCounts(this.ifds[0]);
                    int rowsPerStrip = (int)TiffTools.getRowsPerStrip(this.ifds[0])[0];
                    int stripsPerImage = this.getSizeY() / rowsPerStrip;
                    if (stripsPerImage * rowsPerStrip != this.getSizeY()) {
                        ++stripsPerImage;
                    }
                    if ((check = TiffTools.getPhotometricInterpretation(this.ifds[0])) == 3) {
                        TiffTools.putIFDValue(this.ifds[0], 262, 1);
                    }
                    this.emWavelength = TiffTools.getIFDLongArray(this.ifds[0], 33630, true);
                    int pointer = 0;
                    for (int i = 0; i < this.getImageCount(); ++i) {
                        Hashtable<Integer, long[]> temp = new Hashtable<Integer, long[]>(this.ifds[0]);
                        long[] newOffsets = new long[stripsPerImage];
                        if (stripsPerImage * (i + 1) <= oldOffsets.length) {
                            System.arraycopy(oldOffsets, stripsPerImage * i, newOffsets, 0, stripsPerImage);
                        } else {
                            System.arraycopy(oldOffsets, 0, newOffsets, 0, stripsPerImage);
                            long image = stripByteCounts[0] / (long)rowsPerStrip * (long)this.getSizeY();
                            int q = 0;
                            while (q < stripsPerImage) {
                                int n = q++;
                                newOffsets[n] = newOffsets[n] + (long)i * image;
                            }
                        }
                        temp.put(new Integer(273), newOffsets);
                        long[] newByteCounts = new long[stripsPerImage];
                        if (stripsPerImage * i < stripByteCounts.length) {
                            System.arraycopy(stripByteCounts, stripsPerImage * i, newByteCounts, 0, stripsPerImage);
                        } else {
                            Arrays.fill(newByteCounts, stripByteCounts[0]);
                        }
                        temp.put(new Integer(279), newByteCounts);
                        tempIFDs[pointer] = temp;
                        ++pointer;
                    }
                    this.ifds = tempIFDs;
                }
                catch (UnknownTagException exc) {
                    this.trace(exc);
                }
                catch (NullPointerException exc) {
                    this.trace(exc);
                }
                catch (IOException exc) {
                    this.trace(exc);
                }
                catch (FormatException exc) {
                    this.trace(exc);
                }
                try {
                    super.initStandardMetadata();
                }
                catch (FormatException exc) {
                    if (debug) {
                        this.trace(exc);
                    }
                }
                catch (IOException exc) {
                    if (!debug) break block34;
                    this.trace(exc);
                }
            }
            String descr = TiffTools.getComment(this.ifds[0]);
            if (descr != null) {
                String[] lines = descr.split("\n");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i].trim();
                    int colon = line.indexOf(": ");
                    String descrValue = null;
                    if (colon < 0) {
                        if (line.length() <= 0) continue;
                        descrValue = line;
                        continue;
                    }
                    if (i == 0) {
                        int dot = line.lastIndexOf(".", colon);
                        if (dot >= 0) {
                            descrValue = line.substring(0, dot + 1);
                        }
                        line = line.substring(dot + 1);
                        colon -= dot + 1;
                    }
                    if (descrValue != null) {
                        sb.append(descrValue);
                        if (!descrValue.endsWith(".")) {
                            sb.append(".");
                        }
                        sb.append("  ");
                    }
                    String key = line.substring(0, colon);
                    String value = line.substring(colon + 2);
                    this.addMeta(key, value);
                    if (!key.equals("Exposure")) continue;
                    if (value.indexOf(" ") != -1) {
                        value = value.substring(0, value.indexOf(" "));
                    }
                    float exposure = Float.parseFloat(value);
                    this.exposureTime = new Float(exposure / 1000.0f);
                }
                descr = sb.toString().trim();
                if (descr.equals("")) {
                    this.metadata.remove("Comment");
                } else {
                    this.addMeta("Comment", descr);
                }
            }
            try {
                if (this.getSizeZ() == 0) {
                    this.core[0].sizeZ = TiffTools.getIFDLongArray(this.ifds[0], 33629, true).length;
                }
                if (this.getSizeT() == 0) {
                    this.core[0].sizeT = this.getImageCount() / this.getSizeZ();
                }
            }
            catch (FormatException exc) {
                if (!debug) break block35;
                this.trace(exc);
            }
        }
    }

    void parseUIC2Tags(long uic2offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic2offset);
        this.zDistances = new double[this.mmPlanes];
        this.internalStamps = new long[this.mmPlanes];
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            this.zDistances[i] = this.readRational(this.in).doubleValue();
            this.addMeta("zDistance[" + iAsString + "]", this.zDistances[i]);
            String cDate = MetamorphReader.decodeDate(this.in.readInt());
            String cTime = MetamorphReader.decodeTime(this.in.readInt());
            this.internalStamps[i] = DataTools.getTime(cDate + " " + cTime, "dd/MM/yyyy HH:mm:ss:SSS");
            this.addMeta("creationDate[" + iAsString + "]", cDate);
            this.addMeta("creationTime[" + iAsString + "]", cTime);
            this.in.skip(8L);
        }
        this.in.seek(saveLoc);
    }

    private void parseUIC4Tags(long uic4offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic4offset);
        short id = this.in.readShort();
        while (id != 0) {
            switch (id) {
                case 28: {
                    this.readStagePositions();
                    break;
                }
                case 29: {
                    this.readRationals(new String[]{"cameraXChipOffset", "cameraYChipOffset"});
                    break;
                }
                case 37: {
                    this.readStageLabels();
                    break;
                }
                case 40: {
                    this.readRationals(new String[]{"absoluteZ"});
                    break;
                }
                case 41: {
                    this.readAbsoluteZValid();
                }
            }
            id = this.in.readShort();
        }
        this.in.seek(saveLoc);
    }

    private void readStagePositions() throws IOException {
        this.stageX = new double[this.mmPlanes];
        this.stageY = new double[this.mmPlanes];
        for (int i = 0; i < this.mmPlanes; ++i) {
            String pos = MetamorphReader.intFormatMax(i, this.mmPlanes);
            this.stageX[i] = this.readRational(this.in).doubleValue();
            this.stageY[i] = this.readRational(this.in).doubleValue();
            this.addMeta("stageX[" + pos + "]", this.stageX[i]);
            this.addMeta("stageY[" + pos + "]", this.stageY[i]);
        }
    }

    private void readRationals(String[] labels) throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String pos = MetamorphReader.intFormatMax(i, this.mmPlanes);
            for (int q = 0; q < labels.length; ++q) {
                this.addMeta(labels[q] + "[" + pos + "]", this.readRational(this.in).doubleValue());
            }
        }
    }

    void readStageLabels() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int strlen = this.in.readInt();
            this.addMeta("stageLabel[" + iAsString + "]", this.in.readString(strlen));
        }
    }

    void readAbsoluteZValid() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            this.addMeta("absoluteZValid[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.in.readInt());
        }
    }

    private void parseUIC1Tags(long uic1offset, int uic1count) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic1offset);
        for (int i = 0; i < uic1count; ++i) {
            int currentID = this.in.readInt();
            int valOrOffset = this.in.readInt();
            long lastOffset = this.in.getFilePointer();
            String key = this.getKey(currentID);
            Object value = String.valueOf(valOrOffset);
            block0 : switch (currentID) {
                case 3: {
                    value = valOrOffset != 0 ? "on" : "off";
                    break;
                }
                case 4: 
                case 5: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 38: 
                case 39: {
                    value = this.readRational(this.in, valOrOffset);
                    break;
                }
                case 6: 
                case 25: {
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    value = this.in.readString(num);
                    break;
                }
                case 7: {
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    this.imageName = this.in.readString(num);
                    value = this.imageName;
                    break;
                }
                case 8: {
                    if (valOrOffset == 1) {
                        value = "inside";
                        break;
                    }
                    if (valOrOffset == 2) {
                        value = "outside";
                        break;
                    }
                    value = "off";
                    break;
                }
                case 17: {
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.imageCreationDate = thedate + " " + thetime;
                    value = this.imageCreationDate;
                    break;
                }
                case 16: {
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    value = thedate + " " + thetime;
                    break;
                }
                case 26: {
                    this.in.seek(valOrOffset);
                    int standardLUT = this.in.readInt();
                    switch (standardLUT) {
                        case 0: {
                            value = "monochrome";
                            break block0;
                        }
                        case 1: {
                            value = "pseudocolor";
                            break block0;
                        }
                        case 2: {
                            value = "Red";
                            break block0;
                        }
                        case 3: {
                            value = "Green";
                            break block0;
                        }
                        case 4: {
                            value = "Blue";
                            break block0;
                        }
                        case 5: {
                            value = "user-defined";
                            break block0;
                        }
                    }
                    value = "monochrome";
                    break;
                }
                case 34: {
                    value = String.valueOf(this.in.readInt());
                    break;
                }
                case 46: {
                    this.in.seek(valOrOffset);
                    int xBin = this.in.readInt();
                    int yBin = this.in.readInt();
                    this.binning = xBin + "x" + yBin;
                    value = this.binning;
                }
            }
            this.addMeta(key, value);
            this.in.seek(lastOffset);
            if (!"Zoom".equals(key) || value == null) continue;
            this.zoom = Float.parseFloat(value.toString());
        }
        this.in.seek(saveLoc);
    }

    public static String decodeDate(int julian) {
        long a;
        long z = julian + 1;
        if (z < 2299161L) {
            a = z;
        } else {
            long alpha = (long)(((double)z - 1867216.25) / 36524.25);
            a = z + 1L + alpha - alpha / 4L;
        }
        long b = a > 1721423L ? a + 1524L : a + 1158L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        short day = (short)(b - d - (long)(30.6001 * (double)e));
        short month = (short)((double)e < 13.5 ? e - 1L : e - 13L);
        short year = (short)((double)month > 2.5 ? c - 4716L : c - 4715L);
        return MetamorphReader.intFormat(day, 2) + "/" + MetamorphReader.intFormat(month, 2) + "/" + year;
    }

    public static String decodeTime(int millis) {
        Calendar time = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        time.setTimeInMillis(millis);
        String hours = MetamorphReader.intFormat(time.get(11), 2);
        String minutes = MetamorphReader.intFormat(time.get(12), 2);
        String seconds = MetamorphReader.intFormat(time.get(13), 2);
        String ms = MetamorphReader.intFormat(time.get(14), 3);
        return hours + ":" + minutes + ":" + seconds + ":" + ms;
    }

    public static String intFormat(int myint, int digits) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumIntegerDigits(digits);
        df.setMinimumIntegerDigits(digits);
        return df.format(myint);
    }

    public static String intFormatMax(int myint, int maxint) {
        return MetamorphReader.intFormat(myint, String.valueOf(maxint).length());
    }

    private TiffRational readRational(RandomAccessStream s) throws IOException {
        return this.readRational(s, s.getFilePointer());
    }

    private TiffRational readRational(RandomAccessStream s, long offset) throws IOException {
        s.seek(offset);
        int num = s.readInt();
        int denom = s.readInt();
        return new TiffRational(num, denom);
    }

    private String getKey(int id) {
        switch (id) {
            case 1: {
                return "MinScale";
            }
            case 2: {
                return "MaxScale";
            }
            case 3: {
                return "Spatial Calibration";
            }
            case 4: {
                return "XCalibration";
            }
            case 5: {
                return "YCalibration";
            }
            case 6: {
                return "CalibrationUnits";
            }
            case 7: {
                return "Name";
            }
            case 8: {
                return "ThreshState";
            }
            case 9: {
                return "ThreshStateRed";
            }
            case 11: {
                return "ThreshStateGreen";
            }
            case 12: {
                return "ThreshStateBlue";
            }
            case 13: {
                return "ThreshStateLo";
            }
            case 14: {
                return "ThreshStateHi";
            }
            case 15: {
                return "Zoom";
            }
            case 16: {
                return "DateTime";
            }
            case 17: {
                return "LastSavedTime";
            }
            case 18: {
                return "currentBuffer";
            }
            case 19: {
                return "grayFit";
            }
            case 20: {
                return "grayPointCount";
            }
            case 21: {
                return "grayX";
            }
            case 22: {
                return "gray";
            }
            case 23: {
                return "grayMin";
            }
            case 24: {
                return "grayMax";
            }
            case 25: {
                return "grayUnitName";
            }
            case 26: {
                return "StandardLUT";
            }
            case 27: {
                return "Wavelength";
            }
            case 30: {
                return "OverlayMask";
            }
            case 31: {
                return "OverlayCompress";
            }
            case 32: {
                return "Overlay";
            }
            case 33: {
                return "SpecialOverlayMask";
            }
            case 34: {
                return "SpecialOverlayCompress";
            }
            case 35: {
                return "SpecialOverlay";
            }
            case 36: {
                return "ImageProperty";
            }
            case 38: {
                return "AutoScaleLoInfo";
            }
            case 39: {
                return "AutoScaleHiInfo";
            }
            case 42: {
                return "Gamma";
            }
            case 43: {
                return "GammaRed";
            }
            case 44: {
                return "GammaGreen";
            }
            case 45: {
                return "GammaBlue";
            }
            case 46: {
                return "CameraBin";
            }
        }
        return null;
    }
}

