/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RABytes;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.POITools;
import loci.formats.TiffTools;
import loci.formats.in.BMPReader;
import loci.formats.meta.FilterMetadata;

public class FV1000Reader
extends FormatReader {
    public static final String[] OIB_SUFFIX = new String[]{"oib"};
    public static final String[] OIF_SUFFIX = new String[]{"oif"};
    public static final String[] FV1000_SUFFIXES = new String[]{"oib", "oif"};
    private static final int NUM_DIMENSIONS = 9;
    private static final int POINT = 2;
    private static final int LINE = 3;
    private static final int POLYLINE = 4;
    private static final int RECTANGLE = 5;
    private static final int CIRCLE = 6;
    private static final int ELLIPSE = 7;
    private static final int POLYGON = 8;
    private static final int FREE_SHAPE = 9;
    private static final int FREE_LINE = 10;
    private static final int GRID = 11;
    private static final int ARROW = 12;
    private static final int COLOR_BAR = 13;
    private static final int SCALE = 15;
    private Vector tiffs;
    private String thumbId;
    private BMPReader thumbReader;
    private Vector usedFiles;
    private boolean isOIB;
    private Hashtable oibMapping;
    private String[] code;
    private String[] size;
    private String[] pixelSize;
    private int imageDepth;
    private Vector previewNames;
    private String pixelSizeX;
    private String pixelSizeY;
    private Vector channelNames;
    private Vector emWaves;
    private Vector exWaves;
    private String gain;
    private String offset;
    private String voltage;
    private String pinholeSize;
    private String magnification;
    private String lensNA;
    private String objectiveName;
    private String workingDistance;
    private String creationDate;
    private POITools poi;
    private short[][][] lut;
    private int lastChannel;
    private int[] channelIndexes;
    private Vector pinholeSizes;
    private Vector dyeNames;
    private Vector wavelengths;
    private Vector illuminations;

    public FV1000Reader() {
        super("Olympus FV1000", new String[]{"oib", "oif", "pty", "lut"});
        this.blockCheckLen = 1024;
    }

    public boolean isThisType(String name, boolean open) {
        if (FV1000Reader.checkSuffix(name, FV1000_SUFFIXES)) {
            return true;
        }
        if (!open) {
            return false;
        }
        try {
            Location oif;
            Location parent = new Location(name).getAbsoluteFile().getParentFile();
            String path = parent.getPath();
            path = path.substring(path.lastIndexOf(File.separator) + 1);
            if (path.indexOf(".") != -1) {
                path = path.substring(0, path.lastIndexOf("."));
            }
            return (oif = new Location(parent.getParentFile(), path)).exists() && !oif.isDirectory();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        String s = DataTools.stripString(stream.readString(this.blockCheckLen));
        return s.indexOf("FileInformation") != -1 || s.indexOf("Acquisition Parameters") != -1;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        String name = id.toLowerCase();
        if (name.endsWith(".oib") || name.endsWith(".oif")) {
            return 2;
        }
        return 0;
    }

    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut == null ? (short[][])null : this.lut[this.lastChannel];
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        int[] coords = this.getZCTCoords(no);
        if (coords[1] < this.channelIndexes.length) {
            coords[1] = this.channelIndexes[coords[1]];
            this.lastChannel = coords[1];
        }
        int planeNum = coords[1];
        if (this.getSizeY() > 1 && this.getImageCount() > this.getSizeC()) {
            planeNum = FormatTools.getIndex(this.getDimensionOrder(), this.getSizeZ(), this.getEffectiveSizeC(), this.getSizeT(), this.getImageCount(), coords[0], coords[1], coords[2]);
        }
        String file = (String)(this.series == 0 ? this.tiffs.get(planeNum) : this.previewNames.get(planeNum));
        RandomAccessStream plane = this.getFile(file);
        Hashtable ifd = TiffTools.getFirstIFD(plane);
        if ((long)this.getSizeY() != TiffTools.getImageLength(ifd)) {
            TiffTools.getSamples(ifd, plane, buf, x, this.getIndex(coords[0], 0, coords[2]), w, 1L);
        } else {
            TiffTools.getSamples(ifd, plane, buf, x, y, w, h);
        }
        plane.close();
        plane = null;
        return buf;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.usedFiles == null) {
            return new String[]{this.currentId};
        }
        return this.usedFiles.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.thumbReader != null) {
            this.thumbReader.close(fileOnly);
        }
        if (!fileOnly) {
            super.close();
            this.usedFiles = null;
            this.tiffs = null;
            this.thumbReader = null;
            this.thumbId = null;
            this.previewNames = null;
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.lastChannel = 0;
            this.pinholeSizes = null;
            this.dyeNames = null;
            this.wavelengths = null;
            this.illuminations = null;
        }
    }

    public void close() throws IOException {
        this.close(false);
    }

    protected void initFile(String id) throws FormatException, IOException {
        float sizeT;
        float sizeZ;
        int q;
        Hashtable<Integer, String> roiFilenames;
        Vector<String> lutNames;
        String path;
        String value;
        String key;
        boolean mappedOIF;
        block185: {
            int i;
            int i2;
            String s;
            if (debug) {
                this.debug("FV1000Reader.initFile(" + id + ")");
            }
            super.initFile(id);
            this.isOIB = FV1000Reader.checkSuffix(id, OIB_SUFFIX);
            this.in = new RandomAccessStream(id);
            if (this.isOIB) {
                this.poi = new POITools(Location.getMappedId(id));
            }
            mappedOIF = !this.isOIB && !new File(id).getAbsoluteFile().exists();
            this.channelNames = new Vector();
            this.emWaves = new Vector();
            this.exWaves = new Vector();
            this.dyeNames = new Vector();
            this.wavelengths = new Vector();
            this.illuminations = new Vector();
            String line = null;
            key = null;
            value = null;
            String oifName = null;
            if (this.isOIB) {
                String infoFile = null;
                Vector list = this.poi.getDocumentList();
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    String name = (String)list.get(i3);
                    if (!name.endsWith("OibInfo.txt")) continue;
                    infoFile = name;
                    break;
                }
                if (infoFile == null) {
                    throw new FormatException("OibInfo.txt not found in " + id);
                }
                RandomAccessStream ras = this.poi.getDocumentStream(infoFile);
                this.oibMapping = new Hashtable();
                s = DataTools.stripString(ras.readString((int)ras.length()));
                ras.close();
                StringTokenizer lines = new StringTokenizer(s, "\n");
                String directoryKey = null;
                String directoryValue = null;
                while (lines.hasMoreTokens()) {
                    String last;
                    String first;
                    line = lines.nextToken().trim();
                    if (line.indexOf("=") == -1) continue;
                    key = line.substring(0, line.indexOf("="));
                    value = line.substring(line.indexOf("=") + 1);
                    if (key.startsWith("Stream")) {
                        if (directoryKey != null && directoryValue != null) {
                            value = value.replaceAll(directoryKey, directoryValue);
                        }
                        if (value.indexOf("GST") != -1) {
                            first = value.substring(0, value.indexOf("GST"));
                            last = value.substring(value.lastIndexOf("=") + 1);
                            value = first + last;
                        }
                        if (FV1000Reader.checkSuffix(value, OIF_SUFFIX)) {
                            oifName = value;
                        }
                        if (directoryKey != null) {
                            this.oibMapping.put(value, "Root Entry" + File.separator + directoryKey + File.separator + key);
                            continue;
                        }
                        this.oibMapping.put(value, "Root Entry" + File.separator + key);
                        continue;
                    }
                    if (!key.startsWith("Storage")) continue;
                    if (value.indexOf("GST") != -1) {
                        first = value.substring(0, value.indexOf("GST"));
                        last = value.substring(value.lastIndexOf("=") + 1);
                        value = first + last;
                    }
                    directoryKey = key;
                    directoryValue = value;
                }
                s = null;
            } else if (!FV1000Reader.checkSuffix(id, OIF_SUFFIX)) {
                Location current = new Location(id).getAbsoluteFile();
                String parent = current.getParent();
                Location tmp = new Location(parent);
                parent = tmp.getParent();
                id = current.getPath();
                String oifFile = id.substring(id.lastIndexOf(File.separator));
                oifFile = parent + oifFile.substring(0, oifFile.lastIndexOf("_")) + ".oif";
                tmp = new Location(oifFile);
                if (!tmp.exists()) {
                    tmp = new Location(oifFile = oifFile.substring(0, oifFile.lastIndexOf(".")) + ".OIF");
                    if (!tmp.exists()) {
                        if (parent.endsWith(File.separator)) {
                            parent = parent.substring(0, parent.length() - 1);
                        }
                        String dir = parent.substring(parent.lastIndexOf(File.separator));
                        tmp = new Location(parent);
                        oifFile = (parent = tmp.getParent()) + dir.substring(0, dir.lastIndexOf("."));
                        if (!new Location(oifFile).exists()) {
                            throw new FormatException("OIF file not found");
                        }
                    }
                    this.currentId = oifFile;
                } else {
                    this.currentId = oifFile;
                }
                super.initFile(this.currentId);
                this.in = new RandomAccessStream(this.currentId);
                oifName = this.currentId;
            } else {
                oifName = this.currentId;
            }
            String f = new Location(oifName).getAbsoluteFile().getAbsolutePath();
            path = this.isOIB || !f.endsWith(oifName) || mappedOIF ? "" : f.substring(0, f.lastIndexOf(File.separator) + 1);
            RandomAccessStream oif = null;
            try {
                oif = this.getFile(oifName);
            }
            catch (IOException e) {
                oif = this.getFile(oifName.replaceAll(".oif", ".OIF"));
            }
            s = oif.readString((int)oif.length());
            oif.close();
            this.code = new String[9];
            this.size = new String[9];
            this.pixelSize = new String[9];
            StringTokenizer st = new StringTokenizer(s, "\r\n");
            this.previewNames = new Vector();
            boolean laserEnabled = true;
            String ptyStart = null;
            String ptyEnd = null;
            String ptyPattern = null;
            Vector<String> channels = new Vector<String>();
            lutNames = new Vector<String>();
            Hashtable<Integer, String> filenames = new Hashtable<Integer, String>();
            roiFilenames = new Hashtable<Integer, String>();
            String prefix = "";
            while (st.hasMoreTokens()) {
                line = DataTools.stripString(st.nextToken().trim());
                if (!line.startsWith("[") && line.indexOf("=") > 0) {
                    String last;
                    int ndx;
                    key = line.substring(0, line.indexOf("=")).trim();
                    value = line.substring(line.indexOf("=") + 1).trim();
                    if (value.startsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if (key.startsWith("IniFileName") && key.indexOf("Thumb") == -1 && !this.isPreviewName(value)) {
                        value = value.replaceAll("/", File.separator);
                        value = value.replace('\\', File.separatorChar);
                        while (value.indexOf("GST") != -1) {
                            String first = value.substring(0, value.indexOf("GST"));
                            ndx = value.indexOf(File.separator) < value.indexOf("GST") ? value.length() : value.indexOf(File.separator);
                            last = value.substring(value.lastIndexOf("=", ndx) + 1);
                            value = first + last;
                        }
                        if (mappedOIF) {
                            value = value.substring(value.lastIndexOf(File.separator) + 1);
                        }
                        filenames.put(new Integer(key.substring(11)), value.trim());
                    } else if (key.startsWith("RoiFileName") && key.indexOf("Thumb") == -1 && !this.isPreviewName(value)) {
                        value = value.replaceAll("/", File.separator);
                        value = value.replace('\\', File.separatorChar);
                        while (value.indexOf("GST") != -1) {
                            String first = value.substring(0, value.indexOf("GST"));
                            ndx = value.indexOf(File.separator) < value.indexOf("GST") ? value.length() : value.indexOf(File.separator);
                            last = value.substring(value.lastIndexOf("=", ndx) + 1);
                            value = first + last;
                        }
                        if (mappedOIF) {
                            value = value.substring(value.lastIndexOf(File.separator) + 1);
                        }
                        try {
                            roiFilenames.put(new Integer(key.substring(11)), value.trim());
                        }
                        catch (NumberFormatException e) {}
                    } else if (key.equals("PtyFileNameS")) {
                        ptyStart = value;
                    } else if (key.equals("PtyFileNameE")) {
                        ptyEnd = value;
                    } else if (key.equals("PtyFileNameT2")) {
                        ptyPattern = value;
                    } else if (key.indexOf("Thumb") != -1) {
                        value = value.replaceAll("/", File.separator);
                        value = value.replace('\\', File.separatorChar);
                        while (value.indexOf("GST") != -1) {
                            String first = value.substring(0, value.indexOf("GST"));
                            ndx = value.indexOf(File.separator) < value.indexOf("GST") ? value.length() : value.indexOf(File.separator);
                            last = value.substring(value.lastIndexOf("=", ndx) + 1);
                            value = first + last;
                        }
                        if (mappedOIF) {
                            value = value.substring(value.lastIndexOf(File.separator) + 1);
                        }
                        if (this.thumbId == null) {
                            this.thumbId = value.trim();
                        }
                    } else if (key.startsWith("LutFileName")) {
                        if (!this.isPreviewName(value)) {
                            value = value.replaceAll("/", File.separator);
                            value = value.replace('\\', File.separatorChar);
                            while (value.indexOf("GST") != -1) {
                                String first = value.substring(0, value.indexOf("GST"));
                                ndx = value.indexOf(File.separator) < value.indexOf("GST") ? value.length() : value.indexOf(File.separator);
                                last = value.substring(value.lastIndexOf("=", ndx) + 1);
                                value = first + last;
                            }
                        }
                        if (mappedOIF) {
                            value = value.substring(value.lastIndexOf(File.separator) + 1);
                        }
                        lutNames.add(path + value);
                    } else if (this.isPreviewName(value)) {
                        value = value.replaceAll("/", File.separator);
                        value = value.replace('\\', File.separatorChar);
                        while (value.indexOf("GST") != -1) {
                            String first = value.substring(0, value.indexOf("GST"));
                            ndx = value.indexOf(File.separator) < value.indexOf("GST") ? value.length() : value.indexOf(File.separator);
                            last = value.substring(value.lastIndexOf("=", ndx) + 1);
                            value = first + last;
                        }
                        if (mappedOIF) {
                            value = value.substring(value.lastIndexOf(File.separator) + 1);
                        }
                        this.previewNames.add(path + value.trim());
                    }
                    this.addMeta(prefix + key, value);
                    if (prefix.startsWith("[Axis ") && prefix.endsWith("Parameters Common] - ")) {
                        int ndx2 = Integer.parseInt(prefix.substring(6, prefix.indexOf("P")).trim());
                        if (key.equals("AxisCode")) {
                            this.code[ndx2] = value;
                            continue;
                        }
                        if (key.equals("MaxSize")) {
                            this.size[ndx2] = value;
                            continue;
                        }
                        if (!key.equals("Interval")) continue;
                        this.pixelSize[ndx2] = value;
                        continue;
                    }
                    if ((prefix + key).equals("[Reference Image Parameter] - ImageDepth")) {
                        this.imageDepth = Integer.parseInt(value);
                        continue;
                    }
                    if ((prefix + key).equals("[Reference Image Parameter] - WidthConvertValue")) {
                        this.pixelSizeX = value;
                        continue;
                    }
                    if ((prefix + key).equals("[Reference Image Parameter] - HeightConvertValue")) {
                        this.pixelSizeY = value;
                        continue;
                    }
                    if (prefix.indexOf("[Channel ") != -1 && prefix.indexOf("Parameters] - ") != -1) {
                        if (key.equals("CH Name")) {
                            this.channelNames.add(value);
                            continue;
                        }
                        if (key.equals("DyeName")) {
                            this.dyeNames.add(value);
                            continue;
                        }
                        if (key.equals("EmissionWavelength")) {
                            this.emWaves.add(new Integer(value));
                            continue;
                        }
                        if (key.equals("ExcitationWavelength")) {
                            this.exWaves.add(new Integer(value));
                            continue;
                        }
                        if (key.equals("SequentialNumber")) {
                            channels.add(value);
                            continue;
                        }
                        if (!key.equals("LightType")) continue;
                        String illumination = value.toLowerCase();
                        illumination = illumination.indexOf("fluorescence") != -1 ? "Epifluorescence" : (illumination.indexOf("transmitted") != -1 ? "Transmitted" : null);
                        this.illuminations.add(illumination);
                        continue;
                    }
                    if (prefix.startsWith("[Laser ") && key.equals("Laser Enable")) {
                        laserEnabled = value.equals("1");
                        continue;
                    }
                    if (prefix.startsWith("[Laser ") && key.equals("LaserWavelength")) {
                        if (!laserEnabled) continue;
                        this.wavelengths.add(new Integer(value));
                        continue;
                    }
                    if (!key.equals("ImageCaputreDate") && !key.equals("ImageCaptureDate")) continue;
                    this.creationDate = value;
                    continue;
                }
                if (line.length() <= 0) continue;
                if (line.indexOf("[") == 2) {
                    line = line.substring(2, line.length());
                }
                prefix = line + " - ";
            }
            if (ptyStart != null && ptyEnd != null && ptyPattern != null) {
                String[] prefixes = ptyPattern.split("%03d");
                int[] first = new int[prefixes.length - 1];
                int index = 0;
                for (int i4 = 0; i4 < first.length; ++i4) {
                    first[i4] = Integer.parseInt(ptyStart.substring(index += prefixes[i4].length(), index + 3));
                    index += 3;
                }
                int[] last = new int[prefixes.length - 1];
                index = 0;
                for (int i5 = 0; i5 < last.length; ++i5) {
                    last[i5] = Integer.parseInt(ptyEnd.substring(index += prefixes[i5].length(), index + 3));
                    index += 3;
                }
                int[] lengths = new int[first.length];
                for (int i6 = 0; i6 < lengths.length; ++i6) {
                    lengths[i6] = last[i6] - first[i6] + 1;
                }
                int totalFiles = 1;
                for (i2 = 0; i2 < lengths.length; ++i2) {
                    totalFiles *= lengths[i2];
                }
                for (int file = 0; file < totalFiles; ++file) {
                    int[] pos = FormatTools.rasterToPosition(lengths, file);
                    StringBuffer pty = new StringBuffer();
                    for (int block = 0; block < prefixes.length; ++block) {
                        pty.append(prefixes[block]);
                        if (block >= pos.length) continue;
                        String num = String.valueOf(pos[block] + 1);
                        for (q = 0; q < 3 - num.length(); ++q) {
                            pty.append("0");
                        }
                        pty.append(num);
                    }
                    filenames.put(new Integer(file), pty.toString());
                }
            }
            this.channelIndexes = new int[channels.size()];
            for (i = 0; i < this.channelIndexes.length; ++i) {
                this.channelIndexes[i] = Integer.parseInt((String)channels.get(i));
            }
            for (i = 0; i < this.channelIndexes.length; ++i) {
                for (int q2 = 0; q2 < this.channelIndexes.length; ++q2) {
                    if (i == q2 || this.channelIndexes[i] != this.channelIndexes[q2]) continue;
                    for (int n = 0; n < this.channelIndexes.length; ++n) {
                        if (this.channelIndexes[n] <= this.channelIndexes[q2]) continue;
                        this.channelIndexes[q2] = this.channelIndexes[n];
                    }
                    int n = q2;
                    this.channelIndexes[n] = this.channelIndexes[n] + 1;
                }
            }
            int nextIndex = 0;
            for (int i7 = 0; i7 < this.channelIndexes.length; ++i7) {
                int min = Integer.MAX_VALUE;
                int minIndex = -1;
                for (int q3 = 0; q3 < this.channelIndexes.length; ++q3) {
                    if (this.channelIndexes[q3] >= min || this.channelIndexes[q3] < nextIndex) continue;
                    min = this.channelIndexes[q3];
                    minIndex = q3;
                }
                this.channelIndexes[minIndex] = nextIndex++;
            }
            int reference = ((String)filenames.get(new Integer(0))).length();
            int numFiles = filenames.size();
            for (int i8 = 0; i8 < numFiles; ++i8) {
                Integer ii = new Integer(i8);
                value = (String)filenames.get(ii);
                if (value == null || value.length() <= reference) continue;
                filenames.remove(ii);
            }
            this.status("Initializing helper readers");
            if (this.previewNames.size() > 0) {
                Vector<String> v = new Vector<String>();
                for (int i9 = 0; i9 < this.previewNames.size(); ++i9) {
                    String ss = (String)this.previewNames.get(i9);
                    if (!(ss = ss.replaceAll("pty", "tif")).endsWith(".tif")) continue;
                    v.add(ss);
                }
                this.previewNames = v;
                if (this.previewNames.size() > 0) {
                    String previewName = (String)this.previewNames.get(0);
                    this.core = new CoreMetadata[2];
                    this.core[0] = new CoreMetadata();
                    this.core[1] = new CoreMetadata();
                    Hashtable[] ifds = TiffTools.getIFDs(this.getFile(previewName));
                    this.core[1].imageCount = ifds.length * this.previewNames.size();
                    this.core[1].sizeX = (int)TiffTools.getImageWidth(ifds[0]);
                    this.core[1].sizeY = (int)TiffTools.getImageLength(ifds[0]);
                    this.core[1].sizeZ = 1;
                    this.core[1].sizeT = 1;
                    this.core[1].sizeC = this.core[1].imageCount;
                    this.core[1].rgb = false;
                    int bits = TiffTools.getBitsPerSample(ifds[0])[0];
                    while (bits % 8 != 0) {
                        ++bits;
                    }
                    switch (bits) {
                        case 8: {
                            this.core[1].pixelType = 1;
                            break;
                        }
                        case 16: {
                            this.core[1].pixelType = 3;
                            break;
                        }
                        case 32: {
                            this.core[1].pixelType = 5;
                        }
                    }
                    this.core[1].dimensionOrder = "XYCZT";
                    this.core[1].indexed = false;
                }
            }
            this.core[0].imageCount = filenames.size();
            this.tiffs = new Vector(this.getImageCount());
            this.thumbReader = new BMPReader();
            this.thumbId = this.thumbId.replaceAll("pty", "bmp");
            this.thumbId = this.sanitizeFile(this.thumbId, this.isOIB || mappedOIF ? "" : path);
            this.status("Reading additional metadata");
            String tiffPath = null;
            this.pinholeSizes = new Vector();
            int i10 = 0;
            for (int ii = 0; ii < this.getImageCount(); ++ii) {
                String file = (String)filenames.get(new Integer(i10));
                while (file == null) {
                    file = (String)filenames.get(new Integer(++i10));
                }
                file = this.sanitizeFile(file, this.isOIB || mappedOIF ? "" : path);
                tiffPath = file.indexOf(File.separator) != -1 ? file.substring(0, file.lastIndexOf(File.separator)) : file;
                RandomAccessStream ptyReader = this.getFile(file);
                s = ptyReader.readString((int)ptyReader.length());
                ptyReader.close();
                st = new StringTokenizer(s, "\n");
                while (st.hasMoreTokens()) {
                    line = st.nextToken().trim();
                    if (line.startsWith("[") || line.indexOf("=") <= 0) continue;
                    key = line.substring(0, line.indexOf("=") - 1).trim();
                    value = line.substring(line.indexOf("=") + 1).trim();
                    key = DataTools.stripString(key);
                    value = DataTools.stripString(value);
                    if (key.equals("DataName") && !this.isPreviewName(value = value.substring(1, value.length() - 1))) {
                        value = value.replaceAll("/", File.separator);
                        value = value.replace('\\', File.separatorChar);
                        while (value.indexOf("GST") != -1) {
                            String first = value.substring(0, value.indexOf("GST"));
                            int ndx = value.indexOf(File.separator) < value.indexOf("GST") ? value.length() : value.indexOf(File.separator);
                            String last = value.substring(value.lastIndexOf("=", ndx) + 1);
                            value = first + last;
                        }
                        if (mappedOIF) {
                            this.tiffs.add(ii, value);
                        } else {
                            this.tiffs.add(ii, tiffPath + File.separator + value);
                        }
                    }
                    value = value.replaceAll("\"", "");
                    this.addMeta("Image " + ii + " : " + key, value);
                    if (key.equals("AnalogPMTGain") || key.equals("CountingPMTGain")) {
                        this.gain = value;
                        continue;
                    }
                    if (key.equals("AnalogPMTOffset") || key.equals("CountingPMTOffset")) {
                        this.offset = value;
                        continue;
                    }
                    if (key.equals("Magnification")) {
                        this.magnification = value;
                        continue;
                    }
                    if (key.equals("ObjectiveLens NAValue")) {
                        this.lensNA = value;
                        continue;
                    }
                    if (key.equals("ObjectiveLens Name")) {
                        this.objectiveName = value;
                        continue;
                    }
                    if (key.equals("ObjectiveLens WDValue")) {
                        this.workingDistance = value;
                        continue;
                    }
                    if (key.equals("PMTVoltage")) {
                        this.voltage = value;
                        continue;
                    }
                    if (!key.equals("PinholeDiameter")) continue;
                    this.pinholeSize = value;
                }
                ++i10;
            }
            this.usedFiles = new Vector();
            if (tiffPath != null) {
                this.usedFiles.add(id);
                if (!this.isOIB) {
                    Location dir = new Location(tiffPath);
                    String[] list = mappedOIF ? Location.getIdMap().keySet().toArray(new String[0]) : dir.list();
                    for (i2 = 0; i2 < list.length; ++i2) {
                        if (mappedOIF) {
                            this.usedFiles.add(list[i2]);
                            continue;
                        }
                        String p = new Location(tiffPath, list[i2]).getAbsolutePath();
                        String check = p.toLowerCase();
                        if (!check.endsWith(".tif") && !check.endsWith(".pty") && !check.endsWith(".roi") && !check.endsWith(".lut") && !check.endsWith(".bmp")) continue;
                        this.usedFiles.add(p);
                    }
                }
            }
            this.status("Populating metadata");
            sizeZ = 1.0f;
            sizeT = 1.0f;
            int realChannels = 0;
            for (int i11 = 0; i11 < 9; ++i11) {
                int ss = Integer.parseInt(this.size[i11]);
                if (this.pixelSize[i11] == null) {
                    this.pixelSize[i11] = "1.0";
                }
                this.pixelSize[i11] = this.pixelSize[i11].replaceAll("\"", "");
                Float pixel = new Float(this.pixelSize[i11]);
                if (this.code[i11].equals("X")) {
                    this.core[0].sizeX = ss;
                    continue;
                }
                if (this.code[i11].equals("Y")) {
                    this.core[0].sizeY = ss;
                    continue;
                }
                if (this.code[i11].equals("Z")) {
                    this.core[0].sizeZ = ss;
                    sizeZ = (float)((double)pixel.floatValue() * 0.001);
                    continue;
                }
                if (this.code[i11].equals("T")) {
                    this.core[0].sizeT = ss;
                    sizeT = pixel.floatValue() / 1000.0f;
                    continue;
                }
                if (ss <= 0) continue;
                this.core[0].sizeC = this.getSizeC() == 0 ? ss : (this.core[0].sizeC *= ss);
                if (!this.code[i11].equals("C")) continue;
                realChannels = ss;
            }
            if (this.getSizeZ() == 0) {
                this.core[0].sizeZ = 1;
            }
            if (this.getSizeC() == 0) {
                this.core[0].sizeC = 1;
            }
            if (this.getSizeT() == 0) {
                this.core[0].sizeT = 1;
            }
            if (this.getImageCount() == this.getSizeC() && this.getSizeY() == 1) {
                this.core[0].imageCount *= this.getSizeZ() * this.getSizeT();
            } else if (this.getImageCount() == this.getSizeC()) {
                this.core[0].sizeZ = 1;
                this.core[0].sizeT = 1;
            }
            if (this.getSizeZ() * this.getSizeT() * this.getSizeC() > this.getImageCount()) {
                int diff = this.getSizeZ() * this.getSizeC() * this.getSizeT() - this.getImageCount();
                if (diff == this.previewNames.size()) {
                    if (this.getSizeT() > 1 && this.getSizeZ() == 1) {
                        this.core[0].sizeT -= diff;
                    } else if (this.getSizeZ() > 1 && this.getSizeT() == 1) {
                        this.core[0].sizeZ -= diff;
                    }
                } else {
                    this.core[0].imageCount += diff;
                }
            }
            this.core[0].dimensionOrder = "XYCZT";
            switch (this.imageDepth) {
                case 1: {
                    this.core[0].pixelType = 1;
                    break;
                }
                case 2: {
                    this.core[0].pixelType = 3;
                    break;
                }
                case 4: {
                    this.core[0].pixelType = 5;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported pixel depth: " + this.imageDepth);
                }
            }
            this.in.close();
            this.in = null;
            try {
                RandomAccessStream thumb = this.getFile(this.thumbId);
                byte[] b = new byte[(int)thumb.length()];
                thumb.read(b);
                thumb.close();
                Location.mapFile("thumbnail.bmp", new RABytes(b));
                this.thumbReader.setId("thumbnail.bmp");
                for (int i12 = 0; i12 < this.getSeriesCount(); ++i12) {
                    this.core[i12].thumbSizeX = this.thumbReader.getSizeX();
                    this.core[i12].thumbSizeY = this.thumbReader.getSizeY();
                }
            }
            catch (IOException e) {
                if (!debug) break block185;
                LogTools.trace(e);
            }
        }
        this.lut = new short[this.getSizeC()][3][65536];
        byte[] buffer = new byte[262144];
        int count = Math.min(this.getSizeC(), lutNames.size());
        for (int c = 0; c < count; ++c) {
            try {
                RandomAccessStream stream = this.getFile((String)lutNames.get(c));
                stream.seek(stream.length() - 262144L);
                stream.read(buffer);
                for (q = 0; q < buffer.length; q += 4) {
                    this.lut[c][0][q / 4] = buffer[q + 1];
                    this.lut[c][1][q / 4] = buffer[q + 2];
                    this.lut[c][2][q / 4] = buffer[q + 3];
                }
                continue;
            }
            catch (IOException e) {
                if (debug) {
                    LogTools.trace(e);
                }
                this.lut = null;
                break;
            }
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].rgb = false;
            this.core[i].littleEndian = true;
            this.core[i].interleaved = false;
            this.core[i].metadataComplete = true;
            this.core[i].indexed = false;
            this.core[i].falseColor = false;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        if (this.creationDate != null) {
            this.creationDate = this.creationDate.replaceAll("'", "");
            SimpleDateFormat parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = parse.parse(this.creationDate, new ParsePosition(0));
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.creationDate = fmt.format(date);
        }
        store.setInstrumentID("Instrument:0", 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
            if (this.creationDate != null) {
                store.setImageCreationDate(this.creationDate, i);
            } else {
                MetadataTools.setDefaultCreationDate(store, id, i);
            }
            store.setImageInstrumentRef("Instrument:0", i);
            if (this.pixelSizeX != null) {
                store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), i, 0);
            }
            if (this.pixelSizeY != null) {
                store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), i, 0);
            }
            store.setDimensionsPhysicalSizeZ(new Float(sizeZ), i, 0);
            store.setDimensionsTimeIncrement(new Float(sizeT), i, 0);
            for (int c = 0; c < this.core[i].sizeC; ++c) {
                if (c < this.channelNames.size()) {
                    store.setLogicalChannelName((String)this.channelNames.get(c), i, c);
                }
                if (c < this.emWaves.size()) {
                    store.setLogicalChannelEmWave((Integer)this.emWaves.get(c), i, c);
                }
                if (c < this.exWaves.size()) {
                    store.setLogicalChannelExWave((Integer)this.exWaves.get(c), i, c);
                }
                if (c >= this.illuminations.size()) continue;
                store.setLogicalChannelIlluminationType((String)this.illuminations.get(c), i, c);
            }
        }
        int nLasers = Math.min(this.dyeNames.size(), this.wavelengths.size());
        for (int i = 0; i < nLasers; ++i) {
            store.setLaserLaserMedium((String)this.dyeNames.get(i), 0, i);
            store.setLaserWavelength((Integer)this.wavelengths.get(i), 0, i);
            store.setLightSourceID("LightSource:" + i, 0, i);
            store.setLightSourceSettingsLightSource("LightSource:" + i, 0, i);
            if (i >= this.exWaves.size()) continue;
            store.setLightSourceSettingsWavelength((Integer)this.exWaves.get(i), 0, i);
        }
        if (this.gain != null) {
            store.setDetectorGain(new Float(this.gain), 0, 0);
        }
        if (this.offset != null) {
            store.setDetectorOffset(new Float(this.offset), 0, 0);
        }
        if (this.voltage != null) {
            store.setDetectorVoltage(new Float(this.voltage), 0, 0);
        }
        store.setDetectorType("Unknown", 0, 0);
        store.setDetectorID("Detector:0", 0, 0);
        store.setDetectorSettingsDetector("Detector:0", 0, 0);
        if (this.lensNA != null) {
            store.setObjectiveLensNA(new Float(this.lensNA), 0, 0);
        }
        store.setObjectiveModel(this.objectiveName, 0, 0);
        if (this.magnification != null) {
            store.setObjectiveNominalMagnification(new Integer((int)Float.parseFloat(this.magnification)), 0, 0);
        }
        if (this.workingDistance != null) {
            store.setObjectiveWorkingDistance(new Float(this.workingDistance), 0, 0);
        }
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveImmersion("Unknown", 0, 0);
        store.setObjectiveID("Objective:0", 0, 0);
        store.setObjectiveSettingsObjective("Objective:0", 0);
        int nextROI = -1;
        for (int i = 0; i < roiFilenames.size() && i < this.getImageCount(); ++i) {
            int[] coordinates = this.getZCTCoords(i);
            String filename = (String)roiFilenames.get(new Integer(i));
            filename = this.sanitizeFile(filename, this.isOIB || mappedOIF ? "" : path);
            RandomAccessStream stream = this.getFile(filename);
            String data = stream.readString((int)stream.length());
            stream.close();
            String[] lines = data.split("\n");
            boolean validROI = false;
            int nextShape = -1;
            int shapeType = -1;
            String[] xc = null;
            String[] yc = null;
            int divide = 0;
            int color = 0;
            int fontSize = 0;
            int lineWidth = 0;
            int angle = 0;
            String fontName = null;
            String name = null;
            for (int q4 = 0; q4 < lines.length; ++q4) {
                int point;
                int centerY;
                int height;
                lines[q4] = DataTools.stripString(lines[q4]);
                int eq = lines[q4].indexOf("=");
                if (eq == -1) continue;
                key = lines[q4].substring(0, eq).trim();
                value = lines[q4].substring(eq + 1).trim();
                if (key.equals("Name")) {
                    value = value.replaceAll("\"", "");
                    try {
                        validROI = Integer.parseInt(value) > 1;
                    }
                    catch (NumberFormatException e) {
                        validROI = false;
                    }
                }
                if (!validROI) continue;
                if (key.equals("SHAPE")) {
                    shapeType = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("DIVIDE")) {
                    divide = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("FONT")) {
                    String[] fontAttributes = value.split(",");
                    fontName = fontAttributes[0];
                    fontSize = Integer.parseInt(fontAttributes[1]);
                    continue;
                }
                if (key.equals("LINEWIDTH")) {
                    lineWidth = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("FORECOLOR")) {
                    color = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("NAME")) {
                    name = value;
                    continue;
                }
                if (key.equals("ANGLE")) {
                    angle = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("X")) {
                    xc = value.split(",");
                    continue;
                }
                if (!key.equals("Y")) continue;
                yc = value.split(",");
                int x = Integer.parseInt(xc[0]);
                int width = xc.length > 1 ? Integer.parseInt(xc[1]) - x : 0;
                int y = Integer.parseInt(yc[0]);
                int n = height = yc.length > 1 ? Integer.parseInt(yc[1]) - y : 0;
                if (width + x > this.getSizeX() || height + y > this.getSizeY()) continue;
                if (++nextShape == 0) {
                    store.setROIZ0(new Integer(coordinates[0]), 0, ++nextROI);
                    store.setROIZ1(new Integer(coordinates[0]), 0, nextROI);
                    store.setROIT0(new Integer(coordinates[2]), 0, nextROI);
                    store.setROIT1(new Integer(coordinates[2]), 0, nextROI);
                }
                store.setShapeTheZ(new Integer(coordinates[0]), 0, nextROI, nextShape);
                store.setShapeTheT(new Integer(coordinates[2]), 0, nextROI, nextShape);
                store.setShapeFontSize(new Integer(fontSize), 0, nextROI, nextShape);
                store.setShapeFontFamily(fontName, 0, nextROI, nextShape);
                store.setShapeText(name, 0, nextROI, nextShape);
                store.setShapeStrokeWidth(new Integer(lineWidth), 0, nextROI, nextShape);
                store.setShapeStrokeColor(String.valueOf(color), 0, nextROI, nextShape);
                if (shapeType == 2) {
                    store.setPointCx(xc[0], 0, nextROI, nextShape);
                    store.setPointCy(yc[0], 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 5) {
                    store.setRectX(String.valueOf(x), 0, nextROI, nextShape);
                    store.setRectWidth(String.valueOf(width), 0, nextROI, nextShape);
                    store.setRectY(String.valueOf(y), 0, nextROI, nextShape);
                    store.setRectHeight(String.valueOf(height), 0, nextROI, nextShape);
                    int centerX = x + width / 2;
                    centerY = y + height / 2;
                    store.setRectTransform("rotate(" + angle + " " + centerX + " " + centerY + ")", 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 11) {
                    width /= divide;
                    height /= divide;
                    for (int row = 0; row < divide; ++row) {
                        for (int col = 0; col < divide; ++col) {
                            store.setRectX(String.valueOf(x + col * width), 0, nextROI, nextShape);
                            store.setRectY(String.valueOf(y + row * height), 0, nextROI, nextShape);
                            store.setRectWidth(String.valueOf(width), 0, nextROI, nextShape);
                            store.setRectHeight(String.valueOf(height), 0, nextROI, nextShape);
                            int centerX = x + col * width + width / 2;
                            int centerY2 = y + row * height + height / 2;
                            store.setRectTransform("rotate(" + angle + " " + centerX + " " + centerY2 + ")", 0, nextROI, nextShape);
                            if (row >= divide - 1 && col >= divide - 1) continue;
                            ++nextShape;
                        }
                    }
                    continue;
                }
                if (shapeType == 3) {
                    store.setLineX1(String.valueOf(x), 0, nextROI, nextShape);
                    store.setLineY1(String.valueOf(y), 0, nextROI, nextShape);
                    store.setLineX2(String.valueOf(x + width), 0, nextROI, nextShape);
                    store.setLineY2(String.valueOf(y + height), 0, nextROI, nextShape);
                    int centerX = x + width / 2;
                    centerY = y + height / 2;
                    store.setLineTransform("rotate(" + angle + " " + centerX + " " + centerY + ")", 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 6) {
                    int r = width / 2;
                    store.setCircleCx(String.valueOf(x + r), 0, nextROI, nextShape);
                    store.setCircleCy(String.valueOf(y + r), 0, nextROI, nextShape);
                    store.setCircleR(String.valueOf(r), 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 7) {
                    int rx = width / 2;
                    int ry = height / 2;
                    store.setEllipseCx(String.valueOf(x + rx), 0, nextROI, nextShape);
                    store.setEllipseCy(String.valueOf(y + ry), 0, nextROI, nextShape);
                    store.setEllipseRx(String.valueOf(rx), 0, nextROI, nextShape);
                    store.setEllipseRy(String.valueOf(ry), 0, nextROI, nextShape);
                    store.setEllipseTransform("rotate(" + angle + " " + (x + rx) + " " + (y + ry) + ")", 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType == 8 || shapeType == 9) {
                    StringBuffer points = new StringBuffer();
                    for (point = 0; point < xc.length; ++point) {
                        points.append(xc[point]);
                        points.append(",");
                        points.append(yc[point]);
                        if (point >= xc.length - 1) continue;
                        points.append(" ");
                    }
                    store.setPolygonPoints(points.toString(), 0, nextROI, nextShape);
                    store.setPolygonTransform("rotate(" + angle + ")", 0, nextROI, nextShape);
                    continue;
                }
                if (shapeType != 4 && shapeType != 10) continue;
                StringBuffer points = new StringBuffer();
                for (point = 0; point < xc.length; ++point) {
                    points.append(xc[point]);
                    points.append(",");
                    points.append(yc[point]);
                    if (point >= xc.length - 1) continue;
                    points.append(" ");
                }
                store.setPolylinePoints(points.toString(), 0, nextROI, nextShape);
                store.setPolylineTransform("rotate(" + angle + ")", 0, nextROI, nextShape);
            }
        }
    }

    private String sanitizeFile(String file, String path) {
        String f = file;
        f = f.replaceAll("\"", "");
        f = f.replace('\\', File.separatorChar);
        f = f.replace('/', File.separatorChar);
        if (!this.isOIB && path.equals("")) {
            return f;
        }
        return path + File.separator + f;
    }

    private RandomAccessStream getFile(String name) throws FormatException, IOException {
        if (this.isOIB) {
            if (name.startsWith("/") || name.startsWith("\\")) {
                name = name.substring(1);
            }
            name = name.replace('\\', '/');
            return this.poi.getDocumentStream((String)this.oibMapping.get(name));
        }
        return new RandomAccessStream(name);
    }

    private boolean isPreviewName(String name) {
        int index = name.indexOf("-R");
        return index == name.length() - 9;
    }
}

