/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.TiffRational;
import loci.formats.TiffTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;

public abstract class BaseTiffReader
extends MinimalTiffReader {
    private static final int EXIF_VERSION = 36864;
    private static final int FLASH_PIX_VERSION = 40960;
    private static final int COLOR_SPACE = 40961;
    private static final int COMPONENTS_CONFIGURATION = 37121;
    private static final int COMPRESSED_BITS_PER_PIXEL = 37122;
    private static final int PIXEL_X_DIMENSION = 40962;
    private static final int PIXEL_Y_DIMENSION = 40963;
    private static final int MAKER_NOTE = 37500;
    private static final int USER_COMMENT = 37510;
    private static final int RELATED_SOUND_FILE = 40964;
    private static final int DATE_TIME_ORIGINAL = 36867;
    private static final int DATE_TIME_DIGITIZED = 36868;
    private static final int SUB_SEC_TIME = 37520;
    private static final int SUB_SEC_TIME_ORIGINAL = 37521;
    private static final int SUB_SEC_TIME_DIGITIZED = 37522;
    private static final int EXPOSURE_TIME = 33434;
    private static final int F_NUMBER = 33437;
    private static final int EXPOSURE_PROGRAM = 34850;
    private static final int SPECTRAL_SENSITIVITY = 34852;
    private static final int ISO_SPEED_RATINGS = 34855;
    private static final int OECF = 34856;
    private static final int SHUTTER_SPEED_VALUE = 37377;
    private static final int APERTURE_VALUE = 37378;
    private static final int BRIGHTNESS_VALUE = 37379;
    private static final int EXPOSURE_BIAS_VALUE = 37380;
    private static final int MAX_APERTURE_VALUE = 37381;
    private static final int SUBJECT_DISTANCE = 37382;
    private static final int METERING_MODE = 37383;
    private static final int LIGHT_SOURCE = 37384;
    private static final int FLASH = 37385;
    private static final int FOCAL_LENGTH = 37386;
    private static final int FLASH_ENERGY = 41483;
    private static final int SPATIAL_FREQUENCY_RESPONSE = 41484;
    private static final int FOCAL_PLANE_X_RESOLUTION = 41486;
    private static final int FOCAL_PLANE_Y_RESOLUTION = 41487;
    private static final int FOCAL_PLANE_RESOLUTION_UNIT = 41488;
    private static final int SUBJECT_LOCATION = 41492;
    private static final int EXPOSURE_INDEX = 41493;
    private static final int SENSING_METHOD = 41495;
    private static final int FILE_SOURCE = 41728;
    private static final int SCENE_TYPE = 41729;
    private static final int CFA_PATTERN = 41730;

    public BaseTiffReader(String name, String suffix) {
        super(name, suffix);
    }

    public BaseTiffReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    protected void initMetadata() throws FormatException, IOException {
        this.initStandardMetadata();
        this.initMetadataStore();
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        Hashtable ifd = this.ifds[0];
        this.put("ImageWidth", ifd, 256);
        this.put("ImageLength", ifd, 257);
        this.put("BitsPerSample", ifd, 258);
        long exifOffset = TiffTools.getIFDLongValue(ifd, 34665, false, 0L);
        if (exifOffset != 0L) {
            Hashtable exif = TiffTools.getIFD(this.in, 1L, exifOffset);
            Enumeration keys = exif.keys();
            while (keys.hasMoreElements()) {
                int key = (Integer)keys.nextElement();
                this.addMeta(BaseTiffReader.getExifTagName(key), exif.get(new Integer(key)));
            }
        }
        int comp = TiffTools.getCompression(ifd);
        String compression = null;
        switch (comp) {
            case 1: {
                compression = "None";
                break;
            }
            case 2: {
                compression = "CCITT Group 3 1-Dimensional Modified Huffman";
                break;
            }
            case 3: {
                compression = "CCITT T.4 bilevel encoding";
                break;
            }
            case 4: {
                compression = "CCITT T.6 bilevel encoding";
                break;
            }
            case 5: {
                compression = "LZW";
                break;
            }
            case 7: {
                compression = "JPEG";
                break;
            }
            case 32773: {
                compression = "PackBits";
            }
        }
        this.put("Compression", compression);
        int photo = TiffTools.getPhotometricInterpretation(ifd);
        String photoInterp = null;
        String metaDataPhotoInterp = null;
        switch (photo) {
            case 0: {
                photoInterp = "WhiteIsZero";
                metaDataPhotoInterp = "Monochrome";
                break;
            }
            case 1: {
                photoInterp = "BlackIsZero";
                metaDataPhotoInterp = "Monochrome";
                break;
            }
            case 2: {
                photoInterp = "RGB";
                metaDataPhotoInterp = "RGB";
                break;
            }
            case 3: {
                photoInterp = "Palette";
                metaDataPhotoInterp = "Monochrome";
                break;
            }
            case 4: {
                photoInterp = "Transparency Mask";
                metaDataPhotoInterp = "RGB";
                break;
            }
            case 5: {
                photoInterp = "CMYK";
                metaDataPhotoInterp = "CMYK";
                break;
            }
            case 6: {
                photoInterp = "YCbCr";
                metaDataPhotoInterp = "RGB";
                break;
            }
            case 8: {
                photoInterp = "CIELAB";
                metaDataPhotoInterp = "RGB";
                break;
            }
            case 32803: {
                photoInterp = "Color Filter Array";
                metaDataPhotoInterp = "RGB";
            }
        }
        this.put("PhotometricInterpretation", photoInterp);
        this.put("MetaDataPhotometricInterpretation", metaDataPhotoInterp);
        this.putInt("CellWidth", ifd, 264);
        this.putInt("CellLength", ifd, 265);
        int or = TiffTools.getIFDIntValue(ifd, 274);
        if (or == 8) {
            this.put("ImageWidth", ifd, 257);
            this.put("ImageLength", ifd, 256);
        }
        String orientation = null;
        switch (or) {
            case 1: {
                orientation = "1st row -> top; 1st column -> left";
                break;
            }
            case 2: {
                orientation = "1st row -> top; 1st column -> right";
                break;
            }
            case 3: {
                orientation = "1st row -> bottom; 1st column -> right";
                break;
            }
            case 4: {
                orientation = "1st row -> bottom; 1st column -> left";
                break;
            }
            case 5: {
                orientation = "1st row -> left; 1st column -> top";
                break;
            }
            case 6: {
                orientation = "1st row -> right; 1st column -> top";
                break;
            }
            case 7: {
                orientation = "1st row -> right; 1st column -> bottom";
                break;
            }
            case 8: {
                orientation = "1st row -> left; 1st column -> bottom";
            }
        }
        this.put("Orientation", orientation);
        this.putInt("SamplesPerPixel", ifd, 277);
        this.put("Software", ifd, 305);
        this.put("Instrument Make", ifd, 271);
        this.put("Instrument Model", ifd, 272);
        this.put("Document Name", ifd, 269);
        this.put("DateTime", ifd, 306);
        this.put("Artist", ifd, 315);
        this.put("HostComputer", ifd, 316);
        this.put("Copyright", ifd, 33432);
        this.put("NewSubfileType", ifd, 254);
        int thresh = TiffTools.getIFDIntValue(ifd, 263);
        String threshholding = null;
        switch (thresh) {
            case 1: {
                threshholding = "No dithering or halftoning";
                break;
            }
            case 2: {
                threshholding = "Ordered dithering or halftoning";
                break;
            }
            case 3: {
                threshholding = "Randomized error diffusion";
            }
        }
        this.put("Threshholding", threshholding);
        int fill = TiffTools.getIFDIntValue(ifd, 266);
        String fillOrder = null;
        switch (fill) {
            case 1: {
                fillOrder = "Pixels with lower column values are stored in the higher order bits of a byte";
                break;
            }
            case 2: {
                fillOrder = "Pixels with lower column values are stored in the lower order bits of a byte";
            }
        }
        this.put("FillOrder", fillOrder);
        this.putInt("Make", ifd, 271);
        this.putInt("Model", ifd, 272);
        this.putInt("MinSampleValue", ifd, 280);
        this.putInt("MaxSampleValue", ifd, 281);
        this.putInt("XResolution", ifd, 282);
        this.putInt("YResolution", ifd, 283);
        int planar = TiffTools.getIFDIntValue(ifd, 284);
        String planarConfig = null;
        switch (planar) {
            case 1: {
                planarConfig = "Chunky";
                break;
            }
            case 2: {
                planarConfig = "Planar";
            }
        }
        this.put("PlanarConfiguration", planarConfig);
        this.putInt("XPosition", ifd, 286);
        this.putInt("YPosition", ifd, 287);
        this.putInt("FreeOffsets", ifd, 288);
        this.putInt("FreeByteCounts", ifd, 289);
        this.putInt("GrayResponseUnit", ifd, 290);
        this.putInt("GrayResponseCurve", ifd, 291);
        this.putInt("T4Options", ifd, 292);
        this.putInt("T6Options", ifd, 293);
        int res = TiffTools.getIFDIntValue(ifd, 296);
        String resUnit = null;
        switch (res) {
            case 1: {
                resUnit = "None";
                break;
            }
            case 2: {
                resUnit = "Inch";
                break;
            }
            case 3: {
                resUnit = "Centimeter";
            }
        }
        this.put("ResolutionUnit", resUnit);
        this.putInt("PageNumber", ifd, 297);
        this.putInt("TransferFunction", ifd, 301);
        int predict = TiffTools.getIFDIntValue(ifd, 317);
        String predictor = null;
        switch (predict) {
            case 1: {
                predictor = "No prediction scheme";
                break;
            }
            case 2: {
                predictor = "Horizontal differencing";
            }
        }
        this.put("Predictor", predictor);
        this.putInt("WhitePoint", ifd, 318);
        this.putInt("PrimaryChromacities", ifd, 319);
        this.putInt("HalftoneHints", ifd, 321);
        this.putInt("TileWidth", ifd, 322);
        this.putInt("TileLength", ifd, 323);
        this.putInt("TileOffsets", ifd, 324);
        this.putInt("TileByteCounts", ifd, 325);
        int ink = TiffTools.getIFDIntValue(ifd, 332);
        String inkSet = null;
        switch (ink) {
            case 1: {
                inkSet = "CMYK";
                break;
            }
            case 2: {
                inkSet = "Other";
            }
        }
        this.put("InkSet", inkSet);
        this.putInt("InkNames", ifd, 333);
        this.putInt("NumberOfInks", ifd, 334);
        this.putInt("DotRange", ifd, 336);
        this.put("TargetPrinter", ifd, 337);
        this.putInt("ExtraSamples", ifd, 338);
        int fmt = TiffTools.getIFDIntValue(ifd, 339);
        String sampleFormat = null;
        switch (fmt) {
            case 1: {
                sampleFormat = "unsigned integer";
                break;
            }
            case 2: {
                sampleFormat = "two's complement signed integer";
                break;
            }
            case 3: {
                sampleFormat = "IEEE floating point";
                break;
            }
            case 4: {
                sampleFormat = "undefined";
            }
        }
        this.put("SampleFormat", sampleFormat);
        this.putInt("SMinSampleValue", ifd, 340);
        this.putInt("SMaxSampleValue", ifd, 341);
        this.putInt("TransferRange", ifd, 342);
        int jpeg = TiffTools.getIFDIntValue(ifd, 512);
        String jpegProc = null;
        switch (jpeg) {
            case 1: {
                jpegProc = "baseline sequential process";
                break;
            }
            case 14: {
                jpegProc = "lossless process with Huffman coding";
            }
        }
        this.put("JPEGProc", jpegProc);
        this.putInt("JPEGInterchangeFormat", ifd, 513);
        this.putInt("JPEGRestartInterval", ifd, 515);
        this.putInt("JPEGLosslessPredictors", ifd, 517);
        this.putInt("JPEGPointTransforms", ifd, 518);
        this.putInt("JPEGQTables", ifd, 519);
        this.putInt("JPEGDCTables", ifd, 520);
        this.putInt("JPEGACTables", ifd, 521);
        this.putInt("YCbCrCoefficients", ifd, 529);
        int ycbcr = TiffTools.getIFDIntValue(ifd, 530);
        String subSampling = null;
        switch (ycbcr) {
            case 1: {
                subSampling = "chroma image dimensions = luma image dimensions";
                break;
            }
            case 2: {
                subSampling = "chroma image dimensions are half the luma image dimensions";
                break;
            }
            case 4: {
                subSampling = "chroma image dimensions are 1/4 the luma image dimensions";
            }
        }
        this.put("YCbCrSubSampling", subSampling);
        this.putInt("YCbCrPositioning", ifd, 531);
        this.putInt("ReferenceBlackWhite", ifd, 532);
        int[] q = TiffTools.getBitsPerSample(ifd);
        int bps = q[0];
        int numC = q.length;
        if (photo == 3 || photo == 32803) {
            numC = 3;
        }
        this.put("BitsPerSample", bps);
        this.put("NumberOfChannels", numC);
        String comment = TiffTools.getComment(ifd);
        if (comment != null && !comment.startsWith("<?xml")) {
            comment = comment.replaceAll("\r\n", "\n");
            comment = comment.replaceAll("\r", "\n");
            this.put("Comment", comment);
        }
        int samples = TiffTools.getSamplesPerPixel(ifd);
        this.core[0].rgb = samples > 1 || photo == 2;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = TiffTools.isLittleEndian(this.ifds[0]);
        this.core[0].sizeX = (int)TiffTools.getImageWidth(this.ifds[0]);
        this.core[0].sizeY = (int)TiffTools.getImageLength(this.ifds[0]);
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.isRGB() ? samples : 1;
        this.core[0].sizeT = this.ifds.length;
        this.core[0].metadataComplete = true;
        boolean bl = this.core[0].indexed = photo == 3 && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
        }
        if (this.getSizeC() == 1 && !this.isIndexed()) {
            this.core[0].rgb = false;
        }
        this.core[0].falseColor = false;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = TiffTools.getPixelType(this.ifds[0]);
    }

    protected void initMetadataStore() throws FormatException {
        String creationDate;
        String date;
        this.status("Populating OME metadata");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        String artist = null;
        Object o = TiffTools.getIFDValue(this.ifds[0], 315);
        if (o instanceof String) {
            artist = (String)o;
        } else if (o instanceof String[]) {
            String[] s = (String[])o;
            for (int i = 0; i < s.length; ++i) {
                artist = artist + s[i];
                if (i >= s.length - 1) continue;
                artist = artist + "\n";
            }
        }
        if (artist != null) {
            String firstName = null;
            String lastName = null;
            int ndx = artist.indexOf(" ");
            if (ndx < 0) {
                lastName = artist;
            } else {
                firstName = artist.substring(0, ndx);
                lastName = artist.substring(ndx + 1);
            }
            String email = (String)TiffTools.getIFDValue(this.ifds[0], 316);
            store.setExperimenterFirstName(firstName, 0);
            store.setExperimenterLastName(lastName, 0);
            store.setExperimenterEmail(email, 0);
        }
        if ((date = BaseTiffReader.parseDate(creationDate = this.getImageCreationDate(), "yyyy:MM:dd HH:mm:ss")) == null) {
            date = BaseTiffReader.parseDate(creationDate, "dd/MM/yyyy HH:mm:ss.SS");
        }
        if (date == null) {
            date = BaseTiffReader.parseDate(creationDate, "MM/dd/yyyy hh:mm:ss.SSS aa");
        }
        if (creationDate != null && date == null && debug) {
            this.debug("Warning: unknown creation date format: " + creationDate);
        }
        creationDate = date;
        store.setImageName("", 0);
        if (creationDate != null) {
            store.setImageCreationDate(creationDate, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, this.getCurrentFile(), 0);
        }
        store.setImageDescription(TiffTools.getComment(this.ifds[0]), 0);
        int resolutionUnit = TiffTools.getIFDIntValue(this.ifds[0], 296);
        TiffRational xResolution = TiffTools.getIFDRationalValue(this.ifds[0], 282, false);
        TiffRational yResolution = TiffTools.getIFDRationalValue(this.ifds[0], 283, false);
        float pixX = xResolution == null ? 0.0f : 1.0f / xResolution.floatValue();
        float pixY = yResolution == null ? 0.0f : 1.0f / yResolution.floatValue();
        switch (resolutionUnit) {
            case 2: {
                pixX = (float)((double)pixX / 0.0254);
                pixY = (float)((double)pixY / 0.0254);
                break;
            }
            case 3: {
                pixX *= 100.0f;
                pixY *= 100.0f;
            }
        }
        store.setDimensionsPhysicalSizeX(new Float(pixX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(pixY), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Float(0.0f), 0, 0);
        Object x = TiffTools.getIFDValue(this.ifds[0], 286);
        Object y = TiffTools.getIFDValue(this.ifds[0], 287);
        if (x instanceof TiffRational) {
            Float stageX = x == null ? null : new Float(((TiffRational)x).floatValue());
            Float stageY = y == null ? null : new Float(((TiffRational)y).floatValue());
        } else {
            Float stageX = x == null ? null : new Float((String)x);
            Float stageY = y == null ? null : new Float((String)y);
        }
    }

    protected String getImageCreationDate() {
        Object o = TiffTools.getIFDValue(this.ifds[0], 306);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof String[]) {
            return ((String[])o)[0];
        }
        return null;
    }

    protected void put(String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            value = ((String)value).trim();
        }
        this.addMeta(key, value);
    }

    protected void put(String key, int value) {
        if (value == -1) {
            return;
        }
        this.addMeta(key, value);
    }

    protected void put(String key, boolean value) {
        this.put(key, new Boolean(value));
    }

    protected void put(String key, byte value) {
        this.put(key, new Byte(value));
    }

    protected void put(String key, char value) {
        this.put(key, new Character(value));
    }

    protected void put(String key, double value) {
        this.put(key, new Double(value));
    }

    protected void put(String key, float value) {
        this.put(key, new Float(value));
    }

    protected void put(String key, long value) {
        this.put(key, new Long(value));
    }

    protected void put(String key, short value) {
        this.put(key, new Short(value));
    }

    protected void put(String key, Hashtable ifd, int tag) {
        this.put(key, TiffTools.getIFDValue(ifd, tag));
    }

    protected void putInt(String key, Hashtable ifd, int tag) {
        this.put(key, TiffTools.getIFDIntValue(ifd, tag));
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("BaseTiffReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.initMetadata();
    }

    public static String getExifTagName(int tag) {
        switch (tag) {
            case 36864: {
                return "EXIF Version";
            }
            case 40960: {
                return "FlashPix Version";
            }
            case 40961: {
                return "Color Space";
            }
            case 37121: {
                return "Components Configuration";
            }
            case 37122: {
                return "Compressed Bits Per Pixel";
            }
            case 40962: {
                return "Image width";
            }
            case 40963: {
                return "Image height";
            }
            case 37500: {
                return "Maker Note";
            }
            case 37510: {
                return "User comment";
            }
            case 40964: {
                return "Related sound file";
            }
            case 36867: {
                return "Original date/time";
            }
            case 36868: {
                return "Date/time digitized";
            }
            case 37520: {
                return "Date/time subseconds";
            }
            case 37521: {
                return "Original date/time subseconds";
            }
            case 37522: {
                return "Digitized date/time subseconds";
            }
            case 33434: {
                return "Exposure time";
            }
            case 33437: {
                return "F Number";
            }
            case 34850: {
                return "Exposure program";
            }
            case 34852: {
                return "Spectral sensitivity";
            }
            case 34855: {
                return "ISO speed ratings";
            }
            case 34856: {
                return "Optoelectric conversion factor";
            }
            case 37377: {
                return "Shutter speed";
            }
            case 37378: {
                return "Aperture value";
            }
            case 37379: {
                return "Brightness value";
            }
            case 37380: {
                return "Exposure Bias value";
            }
            case 37381: {
                return "Max aperture value";
            }
            case 37382: {
                return "Subject distance";
            }
            case 37383: {
                return "Metering mode";
            }
            case 37384: {
                return "Light source";
            }
            case 37385: {
                return "Flash";
            }
            case 37386: {
                return "Focal length";
            }
            case 41483: {
                return "Flash energy";
            }
            case 41484: {
                return "Spatial frequency response";
            }
            case 41486: {
                return "Focal plane X resolution";
            }
            case 41487: {
                return "Focal plane Y resolution";
            }
            case 41488: {
                return "Focal plane resolution unit";
            }
            case 41492: {
                return "Subject location";
            }
            case 41493: {
                return "Exposure index";
            }
            case 41495: {
                return "Sensing method";
            }
            case 41728: {
                return "File source";
            }
            case 41729: {
                return "Scene type";
            }
            case 41730: {
                return "CFA Pattern";
            }
        }
        return null;
    }

    private static String parseDate(String date, String format) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat parse = new SimpleDateFormat(format);
            parse.setLenient(false);
            Date d = parse.parse(date, new ParsePosition(0));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return sdf.format(d);
        }
        catch (NullPointerException exc) {
            return null;
        }
    }
}

