/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.LogTools;
import loci.common.RandomAccessStream;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.StatusListener;
import loci.formats.meta.MetadataStore;

public class ImageReader
implements IFormatReader {
    private static ClassList defaultClasses;
    private IFormatReader[] readers;
    private String[] suffixes;
    private String currentId;
    private int current;

    private static ClassList getDefaultReaderClasses() {
        if (defaultClasses == null) {
            try {
                defaultClasses = new ClassList("readers.txt", IFormatReader.class);
            }
            catch (IOException exc) {
                defaultClasses = new ClassList(IFormatReader.class);
                LogTools.trace(exc);
            }
        }
        return defaultClasses;
    }

    public ImageReader() {
        this(ImageReader.getDefaultReaderClasses());
    }

    public ImageReader(ClassList classList) {
        Vector<IFormatReader> v = new Vector<IFormatReader>();
        Class[] c = classList.getClasses();
        for (int i = 0; i < c.length; ++i) {
            IFormatReader reader = null;
            try {
                reader = (IFormatReader)c[i].newInstance();
            }
            catch (IllegalAccessException exc) {
            }
            catch (InstantiationException exc) {
                // empty catch block
            }
            if (reader == null) {
                LogTools.println("Error: " + c[i].getName() + " cannot be instantiated.");
                continue;
            }
            v.add(reader);
        }
        this.readers = new IFormatReader[v.size()];
        v.copyInto(this.readers);
    }

    public String getFormat(String id) throws FormatException, IOException {
        return this.getReader(id).getFormat();
    }

    public IFormatReader getReader(String id) throws FormatException, IOException {
        if (!id.equals(this.currentId)) {
            boolean success = false;
            for (int i = 0; i < this.readers.length; ++i) {
                if (!this.readers[i].isThisType(id)) continue;
                this.current = i;
                this.currentId = id;
                success = true;
                break;
            }
            if (!success) {
                throw new FormatException("Unknown file format: " + id);
            }
        }
        return this.readers[this.current];
    }

    public IFormatReader getReader() {
        return this.readers[this.current];
    }

    public IFormatReader getReader(Class c) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].getClass().equals(c)) continue;
            return this.readers[i];
        }
        return null;
    }

    public IFormatReader[] getReaders() {
        IFormatReader[] r = new IFormatReader[this.readers.length];
        System.arraycopy(this.readers, 0, r, 0, this.readers.length);
        return r;
    }

    public boolean isThisType(String name, boolean open) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].isThisType(name, open)) continue;
            return true;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].isThisType(block)) continue;
            return true;
        }
        return false;
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].isThisType(stream)) continue;
            return true;
        }
        return false;
    }

    public int getImageCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getImageCount();
    }

    public boolean isRGB() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isRGB();
    }

    public int getSizeX() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeX();
    }

    public int getSizeY() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeY();
    }

    public int getSizeC() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeC();
    }

    public int getSizeZ() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeZ();
    }

    public int getSizeT() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeT();
    }

    public int getPixelType() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getPixelType();
    }

    public int getEffectiveSizeC() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getEffectiveSizeC();
    }

    public int getRGBChannelCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getRGBChannelCount();
    }

    public boolean isIndexed() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isIndexed();
    }

    public boolean isFalseColor() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isFalseColor();
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().get16BitLookupTable();
    }

    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getChannelDimLengths();
    }

    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getChannelDimTypes();
    }

    public int getThumbSizeX() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getThumbSizeX();
    }

    public int getThumbSizeY() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getThumbSizeY();
    }

    public boolean isLittleEndian() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isLittleEndian();
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getDimensionOrder();
    }

    public boolean isOrderCertain() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isOrderCertain();
    }

    public boolean isThumbnailSeries() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isThumbnailSeries();
    }

    public boolean isInterleaved() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isInterleaved();
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isInterleaved(subC);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openImage(no);
    }

    public BufferedImage openImage(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openImage(no, x, y, w, h);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openBytes(no);
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openBytes(no, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openBytes(no, buf, x, y, w, h);
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openThumbImage(no);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openThumbBytes(no);
    }

    public int getSeriesCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSeriesCount();
    }

    public void setSeries(int no) {
        FormatTools.assertId(this.currentId, true, 2);
        this.getReader().setSeries(no);
    }

    public int getSeries() {
        return this.getReader().getSeries();
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getUsedFiles();
    }

    public int getIndex(int z, int c, int t) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getIndex(z, c, t);
    }

    public int[] getZCTCoords(int index) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getZCTCoords(index);
    }

    public Object getMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getMetadataValue(field);
    }

    public Hashtable getMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getMetadata();
    }

    public CoreMetadata[] getCoreMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getCoreMetadata();
    }

    public void close(boolean fileOnly) throws IOException {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].close(fileOnly);
        }
        if (!fileOnly) {
            this.currentId = null;
        }
    }

    public void setGroupFiles(boolean group) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setGroupFiles(group);
        }
    }

    public boolean isGroupFiles() {
        return this.getReader().isGroupFiles();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.getReader(id).fileGroupOption(id);
    }

    public boolean isMetadataComplete() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isMetadataComplete();
    }

    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setNormalized(normalize);
        }
    }

    public boolean isNormalized() {
        return this.readers[0].isNormalized();
    }

    public void setMetadataCollected(boolean collect) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataCollected(collect);
        }
    }

    public boolean isMetadataCollected() {
        return this.readers[0].isMetadataCollected();
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setOriginalMetadataPopulated(populate);
        }
    }

    public boolean isOriginalMetadataPopulated() {
        return this.readers[0].isOriginalMetadataPopulated();
    }

    public String getCurrentFile() {
        return this.getReader().getCurrentFile();
    }

    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataFiltered(filter);
        }
    }

    public boolean isMetadataFiltered() {
        return this.readers[0].isMetadataFiltered();
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataStore(store);
        }
    }

    public MetadataStore getMetadataStore() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getMetadataStore();
    }

    public Object getMetadataStoreRoot() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getMetadataStoreRoot();
    }

    public IFormatReader[] getUnderlyingReaders() {
        return this.getReaders();
    }

    public boolean isThisType(String name) {
        return this.isThisType(name, false) || this.isThisType(name, true);
    }

    public String getFormat() {
        return this.getReader().getFormat();
    }

    public String[] getSuffixes() {
        if (this.suffixes == null) {
            HashSet<String> suffixSet = new HashSet<String>();
            for (int i = 0; i < this.readers.length; ++i) {
                String[] suf = this.readers[i].getSuffixes();
                for (int j = 0; j < suf.length; ++j) {
                    suffixSet.add(suf[j]);
                }
            }
            this.suffixes = new String[suffixSet.size()];
            suffixSet.toArray(this.suffixes);
            Arrays.sort(this.suffixes);
        }
        return this.suffixes;
    }

    public void setId(String id) throws FormatException, IOException {
        this.getReader(id).setId(id);
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void addStatusListener(StatusListener l) {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].addStatusListener(l);
        }
    }

    public void removeStatusListener(StatusListener l) {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].removeStatusListener(l);
        }
    }

    public StatusListener[] getStatusListeners() {
        return this.readers[0].getStatusListeners();
    }
}

