/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataRetrieve;

public abstract class FormatWriter
extends FormatHandler
implements IFormatWriter {
    protected int fps = 10;
    protected ColorModel cm;
    protected String[] compressionTypes;
    protected String compression;
    protected boolean initialized;
    protected MetadataRetrieve metadataRetrieve = new DummyMetadata();

    public FormatWriter(String format, String suffix) {
        super(format, suffix);
    }

    public FormatWriter(String format, String[] suffixes) {
        super(format, suffixes);
    }

    public void saveBytes(byte[] bytes, boolean last) throws FormatException, IOException {
        this.saveBytes(bytes, 0, last, last);
    }

    public void saveBytes(byte[] bytes, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        MetadataRetrieve r = this.getMetadataRetrieve();
        if (r == null) {
            throw new FormatException("MetadataRetrieve cannot be null");
        }
        int width = r.getPixelsSizeX(series, 0);
        int height = r.getPixelsSizeY(series, 0);
        int type = FormatTools.pixelTypeFromString(r.getPixelsPixelType(series, 0));
        boolean littleEndian = r.getPixelsBigEndian(series, 0) == false;
        int bpp = FormatTools.getBytesPerPixel(type);
        int planeSize = width * height * bpp;
        int channels = bytes.length / planeSize;
        BufferedImage img = AWTImageTools.makeImage(bytes, width, height, channels, true, bpp, FormatTools.isFloatingPoint(type), littleEndian, FormatTools.isSigned(type));
        this.saveImage(img, series, lastInSeries, last);
    }

    public void saveImage(Image image, boolean last) throws FormatException, IOException {
        this.saveImage(image, 0, last, last);
    }

    public boolean canDoStacks() {
        return false;
    }

    public void setMetadataRetrieve(MetadataRetrieve retrieve) {
        FormatTools.assertId(this.currentId, false, 1);
        if (retrieve == null) {
            throw new IllegalArgumentException("Metadata object is null");
        }
        this.metadataRetrieve = retrieve;
    }

    public MetadataRetrieve getMetadataRetrieve() {
        return this.metadataRetrieve;
    }

    public void setColorModel(ColorModel model) {
        this.cm = model;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public void setFramesPerSecond(int rate) {
        this.fps = rate;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public String[] getCompressionTypes() {
        return this.compressionTypes;
    }

    public void setCompression(String compress) throws FormatException {
        for (int i = 0; i < this.compressionTypes.length; ++i) {
            if (!this.compressionTypes[i].equals(compress)) continue;
            this.compression = compress;
            return;
        }
        throw new FormatException("Invalid compression type: " + compress);
    }

    public String getCompression() {
        return this.compression;
    }

    public int[] getPixelTypes() {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    public boolean isSupportedType(int type) {
        int[] types = this.getPixelTypes();
        for (int i = 0; i < types.length; ++i) {
            if (type != types[i]) continue;
            return true;
        }
        return false;
    }

    public void setId(String id) throws FormatException, IOException {
        if (id.equals(this.currentId)) {
            return;
        }
        this.close();
        this.currentId = id;
        this.initialized = false;
    }
}

