/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.ReaderWrapper;

public class ChannelSeparator
extends ReaderWrapper {
    private byte[] lastImage;
    private int lastImageIndex = -1;
    private int lastImageSeries = -1;

    public ChannelSeparator() {
    }

    public ChannelSeparator(IFormatReader r) {
        super(r);
    }

    public int getOriginalIndex(int no) throws FormatException, IOException {
        int originalCount;
        int imageCount = this.getImageCount();
        if (imageCount == (originalCount = this.reader.getImageCount())) {
            return no;
        }
        int[] coords = this.getZCTCoords(no);
        coords[1] = coords[1] / this.reader.getRGBChannelCount();
        return this.reader.getIndex(coords[0], coords[1], coords[2]);
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        this.lastImage = null;
        this.lastImageIndex = -1;
        this.lastImageSeries = -1;
    }

    public int getImageCount() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.reader.isRGB() && !this.reader.isIndexed() ? this.reader.getRGBChannelCount() * this.reader.getImageCount() : this.reader.getImageCount();
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String order = super.getDimensionOrder();
        if (this.reader.isRGB() && !this.reader.isIndexed()) {
            String newOrder = "XYC";
            newOrder = order.indexOf("Z") > order.indexOf("T") ? newOrder + "TZ" : newOrder + "ZT";
            return newOrder;
        }
        return order;
    }

    public boolean isRGB() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.isIndexed() && !this.isFalseColor();
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] buf = new byte[w * h * FormatTools.getBytesPerPixel(this.getPixelType())];
        return this.openBytes(no, buf, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        FormatTools.checkPlaneNumber(this, no);
        if (this.reader.isRGB() && !this.reader.isIndexed()) {
            int c = this.getSizeC() / this.reader.getEffectiveSizeC();
            int source = no / c;
            int channel = no % c;
            int series = this.getSeries();
            if (source != this.lastImageIndex || series != this.lastImageSeries) {
                this.lastImage = this.reader.openBytes(source, x, y, w, h);
                this.lastImageIndex = source;
                this.lastImageSeries = series;
            }
            byte[] n = ImageTools.splitChannels(this.lastImage, channel, c, FormatTools.getBytesPerPixel(this.getPixelType()), false, this.isInterleaved());
            System.arraycopy(n, 0, buf, 0, n.length);
            return buf;
        }
        return this.reader.openBytes(no, buf, x, y, w, h);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return this.openImage(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public BufferedImage openImage(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return AWTImageTools.openImage(this.openBytes(no, x, y, w, h), this, w, h);
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return AWTImageTools.scale(this.openImage(no), this.getThumbSizeX(), this.getThumbSizeY(), true);
    }

    public void close() throws IOException {
        super.close();
        this.lastImage = null;
        this.lastImageIndex = -1;
        this.lastImageSeries = -1;
    }

    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(int index) {
        return FormatTools.getZCTCoords(this, index);
    }
}

