/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application;

import application.ResourceMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jhotdraw.application.AbstractDocumentOrientedApplication;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AboutAction;
import org.jhotdraw.application.action.Actions;
import org.jhotdraw.application.action.ArrangeAction;
import org.jhotdraw.application.action.ClearRecentFilesAction;
import org.jhotdraw.application.action.CloseAction;
import org.jhotdraw.application.action.CopyAction;
import org.jhotdraw.application.action.CutAction;
import org.jhotdraw.application.action.DeleteAction;
import org.jhotdraw.application.action.DuplicateAction;
import org.jhotdraw.application.action.ExitAction;
import org.jhotdraw.application.action.FocusAction;
import org.jhotdraw.application.action.NewAction;
import org.jhotdraw.application.action.OpenAction;
import org.jhotdraw.application.action.PasteAction;
import org.jhotdraw.application.action.PrintAction;
import org.jhotdraw.application.action.RedoAction;
import org.jhotdraw.application.action.SaveAction;
import org.jhotdraw.application.action.SaveAsAction;
import org.jhotdraw.application.action.SelectAllAction;
import org.jhotdraw.application.action.ToggleToolBarAction;
import org.jhotdraw.application.action.UndoAction;
import org.jhotdraw.gui.Arrangeable;
import org.jhotdraw.gui.MDIDesktopPane;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.util.prefs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMDIApplication
extends AbstractDocumentOrientedApplication {
    private JFrame parentFrame;
    private JScrollPane scrollPane;
    private MDIDesktopPane desktopPane;
    private DocumentView currentView;
    private LinkedList<Action> toolBarActions;

    @Override
    protected ActionMap createActionMap() {
        ActionMap m = new ActionMap();
        m.put("Application.about", new AboutAction());
        m.put("Application.exit", new ExitAction());
        m.put("File.new", new NewAction());
        m.put("File.open", new OpenAction());
        m.put("File.clearRecentFiles", new ClearRecentFilesAction());
        m.put("File.save", new SaveAction());
        m.put("File.saveAs", new SaveAsAction());
        m.put("File.close", new CloseAction());
        m.put("File.print", new PrintAction());
        m.put("Edit.undo", new UndoAction());
        m.put("Edit.redo", new RedoAction());
        m.put("Edit.cut", new CutAction());
        m.put("Edit.copy", new CopyAction());
        m.put("Edit.paste", new PasteAction());
        m.put("Edit.delete", new DeleteAction());
        m.put("Edit.duplicate", new DuplicateAction());
        m.put("Edit.selectAll", new SelectAllAction());
        m.put("View.arrangeVertical", new ArrangeAction(this.getDesktopPane(), Arrangeable.Arrangement.VERTICAL));
        m.put("View.arrangeHorizontal", new ArrangeAction(this.getDesktopPane(), Arrangeable.Arrangement.HORIZONTAL));
        m.put("View.arrangeCascade", new ArrangeAction(this.getDesktopPane(), Arrangeable.Arrangement.CASCADE));
        return m;
    }

    protected MDIDesktopPane getDesktopPane() {
        if (this.desktopPane == null) {
            this.desktopPane = new MDIDesktopPane();
        }
        return this.desktopPane;
    }

    @Override
    public void initMainFrame() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        this.parentFrame = new JFrame(this.getResourceMap().getString("Application.name", new Object[0]));
        this.parentFrame.setDefaultCloseOperation(0);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.getDesktopPane());
        this.toolBarActions = new LinkedList();
        this.createActionMap();
        this.parentFrame.getContentPane().add(this.wrapDesktopPane(this.scrollPane, this.toolBarActions));
        this.parentFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AbstractMDIApplication.this.getAction("Application.exit").actionPerformed(new ActionEvent(AbstractMDIApplication.this.parentFrame, 1001, "windowClosing"));
            }
        });
        this.parentFrame.setJMenuBar(this.createMenuBar(null, new LinkedList<Action>()));
        PreferencesUtil.installFramePrefsHandler(prefs, "parentFrame", this.parentFrame);
        this.parentFrame.setVisible(true);
    }

    public static void initAWT(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        System.setProperty("com.apple.macos.useScreenMenuBar", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        System.setProperty("swing.aatext", "true");
    }

    @Override
    public void add(DocumentView v) {
        this.updateName(v);
        v.putAction("View.focus", new FocusAction(v));
        super.add(v);
    }

    @Override
    public void show(final DocumentView p) {
        boolean moved;
        ResourceMap labels = this.getResourceMap();
        this.updateName(p);
        final JInternalFrame f = new JInternalFrame();
        f.setTitle(labels.getString("MDIWindow.Frame.title", new Object[]{p.getName()}));
        f.setDefaultCloseOperation(0);
        f.setClosable(true);
        f.setMaximizable(true);
        f.setResizable(true);
        f.setIconifiable(false);
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        PreferencesUtil.installInternalFramePrefsHandler(prefs, "documentView", f, this.desktopPane);
        Point loc = f.getLocation();
        block2: do {
            moved = false;
            for (DocumentView aProject : this.getViews()) {
                if (aProject == p || !SwingUtilities.getRootPane(aProject.getComponent()).getParent().getLocation().equals(loc)) continue;
                loc.x += 22;
                loc.y += 22;
                moved = true;
                continue block2;
            }
        } while (moved);
        f.setLocation(loc);
        f.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent evt) {
                AbstractMDIApplication.this.setCurrentView(p);
                AbstractMDIApplication.this.getAction("File.close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
            }
        });
        p.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals("hasUnsavedChanges")) {
                    ((JInternalFrame)f.getRootPane().getParent()).putClientProperty("windowModified", new Boolean(p.isModified()));
                } else if (name.equals("file")) {
                    f.setTitle(p.getFile() == null ? "Unnamed" : p.getFile().getName());
                }
            }
        });
        f.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals("selected") && evt.getNewValue().equals(Boolean.TRUE)) {
                    AbstractMDIApplication.this.setCurrentView(p);
                }
            }
        });
        f.getContentPane().add(p.getComponent());
        f.setVisible(true);
        this.desktopPane.add(f);
        f.toFront();
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        p.getComponent().requestFocusInWindow();
    }

    @Override
    public void hide(DocumentView p) {
        JInternalFrame f = (JInternalFrame)SwingUtilities.getRootPane(p.getComponent()).getParent();
        f.setVisible(false);
        f.remove(p.getComponent());
        this.desktopPane.remove(f);
        f.dispose();
    }

    @Override
    public DocumentView getCurrentView() {
        return this.currentView;
    }

    public void setCurrentView(DocumentView newValue) {
        DocumentView oldValue = this.currentView;
        this.currentView = newValue;
        this.firePropertyChange("currentView", oldValue, newValue);
    }

    @Override
    public boolean isEditorShared() {
        return true;
    }

    @Override
    public Component getComponent() {
        return this.parentFrame;
    }

    protected Component wrapDesktopPane(Component c, LinkedList<Action> toolBarActions) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        int id = 0;
        for (JToolBar tb : new ReversedList<JToolBar>(this.createToolBars(null))) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)tb, "North");
            panel.add(c, "Center");
            c = panel;
            PreferencesUtil.installToolBarPrefsHandler(prefs, "toolbar." + ++id, tb);
            toolBarActions.addFirst(new ToggleToolBarAction(tb, tb.getName()));
        }
        return c;
    }

    @Override
    protected JMenu createFileMenu(final DocumentView p) {
        ResourceMap labels = this.getFrameworkResourceMap();
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu();
        m.setName("File.Menu");
        labels.injectComponent((Component)m);
        m.add(this.getAction("File.new"));
        m.add(this.getAction("File.open"));
        final JMenu openRecentMenu = new JMenu();
        openRecentMenu.setName("File.openRecent.Menu");
        labels.injectComponent((Component)openRecentMenu);
        openRecentMenu.add(this.getAction("File.clearRecentFiles"));
        this.updateOpenRecentMenu(openRecentMenu);
        m.add(openRecentMenu);
        m.addSeparator();
        m.add(this.getAction("File.save"));
        m.add(this.getAction("File.saveAs"));
        if (this.getAction("File.export") != null) {
            JMenuItem jMenuItem = m.add(this.getAction("File.export"));
        }
        if (this.getAction("File.print") != null) {
            m.addSeparator();
            m.add(this.getAction("File.print"));
        }
        m.addSeparator();
        m.add(this.getAction("Application.exit"));
        mb.add(m);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "projectCount") {
                    if (p != null && !AbstractMDIApplication.this.getViews().contains(p)) {
                        AbstractMDIApplication.this.removePropertyChangeListener(this);
                    }
                } else if (name == "recentFiles") {
                    AbstractMDIApplication.this.updateOpenRecentMenu(openRecentMenu);
                }
            }
        });
        return m;
    }

    @Override
    protected JMenu createWindowMenu(DocumentView p) {
        JMenu m;
        ResourceMap labels = this.getResourceMap();
        final JMenu windowMenu = m = new JMenu();
        m.setName("Window.Menu");
        labels.injectComponent((Component)m);
        m.add(this.getAction("View.arrangeCascade"));
        m.add(this.getAction("View.arrangeVertical"));
        m.add(this.getAction("View.arrangeHorizontal"));
        m.addSeparator();
        for (DocumentView pr : this.getViews()) {
            if (pr.getAction("View.focus") == null) continue;
            windowMenu.add(pr.getAction("View.focus"));
        }
        if (this.toolBarActions.size() > 0) {
            m.addSeparator();
            for (Action a : this.toolBarActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                Actions.configureJCheckBoxMenuItem(cbmi, a);
                m.add(cbmi);
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                System.out.println(this + "." + name);
                if (name == "viewCount") {
                    JMenu m = windowMenu;
                    m.removeAll();
                    m.add(AbstractMDIApplication.this.getAction("View.arrangeCascade"));
                    m.add(AbstractMDIApplication.this.getAction("View.arrangeVertical"));
                    m.add(AbstractMDIApplication.this.getAction("View.arrangeHorizontal"));
                    m.addSeparator();
                    for (DocumentView v : AbstractMDIApplication.this.getViews()) {
                        if (v.getAction("View.focus") == null) continue;
                        m.add(v.getAction("View.focus"));
                    }
                    if (AbstractMDIApplication.this.toolBarActions.size() > 0) {
                        m.addSeparator();
                        for (Action a : AbstractMDIApplication.this.toolBarActions) {
                            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                            Actions.configureJCheckBoxMenuItem(cbmi, a);
                            m.add(cbmi);
                        }
                    }
                }
            }
        });
        return m;
    }

    @Override
    protected JMenu createHelpMenu(DocumentView p) {
        ResourceMap labels = this.getFrameworkResourceMap();
        JMenu m = new JMenu();
        m.setName("Help.Menu");
        labels.injectComponent((Component)m);
        m.add(this.getAction("Application.about"));
        return m;
    }
}

