/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.app.action.ExportableProject;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.ResourceBundleUtil;

public class ExportAction
extends AbstractProjectAction {
    public static final String ID = "export";
    private Component oldFocusOwner;

    public ExportAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    public void actionPerformed(ActionEvent evt) {
        final ExportableProject project = (ExportableProject)this.getCurrentProject();
        if (project.isEnabled()) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(project.getComponent()).getFocusOwner();
            project.setEnabled(false);
            JFileChooser fileChooser = project.getExportChooser();
            JSheet.showSheet(fileChooser, project.getComponent(), labels.getString("filechooser.export"), new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getSelectedFile();
                        ExportAction.this.exportToFile(project, file, evt.getFileChooser().getFileFilter(), evt.getFileChooser().getAccessory());
                    } else {
                        project.setEnabled(true);
                        if (ExportAction.this.oldFocusOwner != null) {
                            ExportAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
        }
    }

    protected void exportToFile(final ExportableProject project, final File file, final FileFilter filter, final Component accessory) {
        project.execute(new Worker(){

            public Object construct() {
                try {
                    project.export(file, filter, accessory);
                    return null;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            public void finished(Object value) {
                ExportAction.this.fileExported(project, file, value);
            }
        });
    }

    protected void fileExported(ExportableProject project, File file, Object value) {
        if (value != null) {
            System.out.flush();
            ((Throwable)value).printStackTrace();
            JSheet.showMessageSheet((Component)project.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't export to the file \"" + file + "\".<p>" + "Reason: " + value), 0);
        }
        project.setEnabled(true);
        SwingUtilities.getWindowAncestor(project.getComponent()).toFront();
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }
}

