/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.subset;

import ch.randelshofer.quaqua.LookAndFeelProxy;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.ResourceBundleUtil;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;

public class Quaqua14FileChooserLAF
extends LookAndFeelProxy {
    protected static final String commonDir = "/ch/randelshofer/quaqua/images/";
    protected static final String jaguarDir = "/ch/randelshofer/quaqua/jaguar/images/";
    protected static final String pantherDir = "/ch/randelshofer/quaqua/panther/images/";
    private UIDefaults myDefaults;
    protected static final FontUIResource SMALL_SYSTEM_FONT = new FontUIResource("Lucida Grande", 0, 11);

    public Quaqua14FileChooserLAF() {
        String targetClassName = "apple.laf.AquaLookAndFeel";
        try {
            this.setTarget((LookAndFeel)Class.forName(targetClassName).newInstance());
        }
        catch (Exception e) {
            throw new InternalError("Unable to instanciate target Look and Feel \"" + targetClassName + "\". " + e.getMessage());
        }
    }

    public String getDescription() {
        return "The Quaqua Panther FileChooser Look and Feel for Java 1.4";
    }

    public String getName() {
        return "Quaqua FileChooser-only LAF";
    }

    public void initialize() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Quaqua14FileChooserLAF.this.target.initialize();
                Quaqua14FileChooserLAF.this.myDefaults = Quaqua14FileChooserLAF.this.target.getDefaults();
                Quaqua14FileChooserLAF.this.initClassDefaults(Quaqua14FileChooserLAF.this.myDefaults);
                Quaqua14FileChooserLAF.this.initComponentDefaults(Quaqua14FileChooserLAF.this.myDefaults);
                return null;
            }
        });
    }

    public UIDefaults getDefaults() {
        return this.myDefaults;
    }

    protected void initClassDefaults(UIDefaults table) {
        String basicPrefix = "javax.swing.plaf.basic.Basic";
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaquaPantherPrefix = "ch.randelshofer.quaqua.panther.QuaquaPanther";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "FileChooserUI", quaquaPantherPrefix + "FileChooserUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        Icon[] browserIcons = this.makeIcons("/ch/randelshofer/quaqua/images/Browser.disclosureIcons.png", 4, true);
        FontUIResource smallSystemFont = SMALL_SYSTEM_FONT;
        Object[] objects = new Object[]{"Browser.expandedIcon", browserIcons[0], "Browser.expandingIcon", browserIcons[1], "Browser.selectedExpandedIcon", browserIcons[2], "Browser.selectedExpandingIcon", browserIcons[3], "Browser.selectionBackground", new ColorUIResource(56, 117, 215), "Browser.selectionForeground", new ColorUIResource(255, 255, 255), "Browser.inactiveSelectionBackground", new ColorUIResource(208, 208, 208), "Browser.inactiveSelectionForeground", new ColorUIResource(0, 0, 0), "FileChooser.homeFolderIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileChooser.homeFolderIcon.png"), "FileView.computerIcon", LookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/FileView.computerIcon.png"), "FileChooser.previewLabelForeground", new ColorUIResource(0), "FileChooser.previewValueForeground", new ColorUIResource(0), "FileChooser.previewLabelFont", smallSystemFont, "FileChooser.previewValueFont", smallSystemFont, "FileChooser.splitPaneDividerSize", new Integer(6), "FileChooser.previewLabelInsets", new InsetsUIResource(0, 0, 0, 4), "FileChooser.cellTipOrigin", new Point(18, 1), "Labels", ResourceBundleUtil.getBundle("ch.randelshofer.quaqua.Labels")};
        table.putDefaults(objects);
    }

    protected URL getResource(String location) {
        URL url = this.getClass().getResource(location);
        if (url == null) {
            throw new InternalError("image resource missing: " + location);
        }
        return url;
    }

    protected Image createImage(String location) {
        return Toolkit.getDefaultToolkit().createImage(this.getResource(location));
    }

    protected Icon[] makeIcons(String location, int count, boolean horizontal) {
        Icon[] icons = new Icon[count];
        BufferedImage[] images = Images.split(this.createImage(location), count, horizontal);
        for (int i = 0; i < count; ++i) {
            icons[i] = new IconUIResource(new ImageIcon(images[i]));
        }
        return icons;
    }
}

