/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tpane;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.util.ui.tpane.TinyObserver;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPane;
import org.openmicroscopy.shoola.util.ui.tpane.TitlePainter;

class TinyPaneTitle
extends JComponent
implements TinyObserver,
PropertyChangeListener {
    private TinyPane model;
    private TitlePainter titlePainter;

    TinyPaneTitle(TinyPane model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.titlePainter = new TitlePainter(new Font("SansSerif", 0, 16));
    }

    public void attach() {
        this.model.addPropertyChangeListener("title", this);
        this.propertyChange(null);
    }

    public void detach() {
        this.model.removePropertyChangeListener("title", this);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        this.titlePainter.setTitle(this.model.getTitle() + this.model.getNote());
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        this.titlePainter.paint(g2D, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }
}

