/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import layout.TableLayout;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.util.ui.SeparatorPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.SearchContext;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;
import org.openmicroscopy.shoola.util.ui.search.SearchPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchComponent
extends JPanel
implements ActionListener {
    public static final String UNTAGGED_TEXT = "Untagged";
    public static final String TAGGED_TEXT = "Tagged";
    public static final String COMMENTED_TEXT = "Commented";
    public static final String UNCOMMENTED_TEXT = "Uncommented";
    public static final String UNRATED = "Unrated";
    public static final String NAME_TEXT = "Name";
    public static final String NAME_DESCRIPTION = "Description";
    public static final String NAME_TAGS = "Tags";
    public static final String NAME_COMMENTS = "Comments";
    public static final String NAME_URL = "URL";
    public static final String NAME_ATTACHMENT = "Attachments";
    public static final String NAME_RATE = "Rate";
    public static final String SEARCH_PROPERTY = "search";
    public static final String CANCEL_SEARCH_PROPERTY = "cancelSearch";
    public static final String OWNER_PROPERTY = "owner";
    public static final String NODES_EXPANDED_PROPERTY = "nodesExpanded";
    public static final int CANCEL = 0;
    public static final int SEARCH = 1;
    public static final int COLLAPSE = 2;
    public static final int HELP = 3;
    static final int DATE = 4;
    static final int OWNER = 5;
    static final int ANNOTATOR = 6;
    static final int ADVANCED_SEARCH = 7;
    static final int BASIC_SEARCH = 8;
    static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private SearchPanel uiDelegate;
    private JButton cancelButton;
    private JButton searchButton;
    private JXBusyLabel busyLabel;
    private JLabel progressLabel;
    private List<SearchObject> nodes;
    private List<SearchObject> types;
    private int userIndex;
    private SearchContext searchContext;
    private JComponent resultPane;

    private void initComponents() {
        this.uiDelegate = new SearchPanel(this);
        this.cancelButton = new JButton();
        this.cancelButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.cancelButton.setToolTipText("Cancel the search");
        this.cancelButton.setActionCommand("0");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.searchButton = new JButton("Search");
        this.searchButton.setToolTipText("Search");
        this.searchButton.setActionCommand("1");
        this.searchButton.addActionListener(this);
        this.searchButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.busyLabel = new JXBusyLabel();
        this.busyLabel.setEnabled(false);
        this.progressLabel = new JLabel("");
        this.progressLabel.setEnabled(false);
        this.progressLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setBorder(null);
        bar.add(this.searchButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancelButton);
        JPanel p = UIUtilities.buildComponentPanel(bar);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        return p;
    }

    private JPanel buildStatusBar() {
        JPanel bar = new JPanel();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.progressLabel);
        JPanel p = UIUtilities.buildComponentPanelCenter((JComponent)this.busyLabel);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.add(p);
        return bar;
    }

    private void buildGUI(boolean showControl) {
        double[][] size = new double[][]{{-1.0}, {-2.0, -2.0, -2.0, -2.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)this.uiDelegate, "0, 0");
        if (showControl) {
            this.add((Component)this.buildToolBar(), "0, 1");
        }
        this.add((Component)this.buildStatusBar(), "0, 2");
        this.resultPane = new JPanel();
        this.resultPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        SeparatorPane sep = new SeparatorPane();
        sep.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)sep, "0, 3");
        this.add((Component)this.resultPane, "0, 3");
    }

    private void cancel() {
        this.firePropertyChange(CANCEL_SEARCH_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    private void setDefaultContext() {
        this.nodes = new ArrayList<SearchObject>();
        SearchObject node = new SearchObject(6, null, NAME_TEXT);
        this.nodes.add(node);
        node = new SearchObject(9, null, NAME_DESCRIPTION);
        this.nodes.add(node);
        node = new SearchObject(3, null, NAME_COMMENTS);
        this.nodes.add(node);
        node = new SearchObject(4, null, NAME_TAGS);
        this.nodes.add(node);
        node = new SearchObject(8, null, NAME_URL);
        this.nodes.add(node);
        node = new SearchObject(7, null, NAME_ATTACHMENT);
        this.nodes.add(node);
        this.types = new ArrayList<SearchObject>();
        node = new SearchObject(0, null, "Image");
        this.types.add(node);
        node = new SearchObject(1, null, "Dataset");
        this.types.add(node);
        node = new SearchObject(2, null, "Project");
        this.types.add(node);
    }

    public SearchComponent(SearchContext context, boolean showControl) {
        this.searchContext = context;
        this.setDefaultContext();
        this.initComponents();
        this.buildGUI(showControl);
    }

    public SearchComponent() {
        this((SearchContext)null, true);
    }

    SearchContext getSearchContext() {
        return this.searchContext;
    }

    List<SearchObject> getNodes() {
        return this.nodes;
    }

    List<SearchObject> getTypes() {
        return this.types;
    }

    void notifyNodeExpanded() {
        this.firePropertyChange(NODES_EXPANDED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    void search() {
        String[] some = this.uiDelegate.getSome();
        String[] must = this.uiDelegate.getMust();
        String[] none = this.uiDelegate.getNone();
        List<Integer> scope = this.uiDelegate.getScope();
        SearchContext ctx = new SearchContext(some, must, none, scope);
        int index = this.uiDelegate.getSelectedDate();
        switch (index) {
            case 5: {
                Timestamp start = this.uiDelegate.getFromDate();
                Timestamp end = this.uiDelegate.getToDate();
                if (start != null && end != null && start.after(end)) {
                    ctx.setTime(end, start);
                    break;
                }
                ctx.setTime(start, end);
                break;
            }
            default: {
                ctx.setTime(index);
            }
        }
        ctx.setOwnerSearchContext(this.uiDelegate.getOwnerSearchContext());
        ctx.setAnnotatorSearchContext(this.uiDelegate.getAnnotatorSearchContext());
        ctx.setOwners(this.uiDelegate.getOwners());
        ctx.setAnnotators(this.uiDelegate.getAnnotators());
        ctx.setCaseSensitive(this.uiDelegate.isCaseSensitive());
        ctx.setType(this.uiDelegate.getType());
        ctx.setAttachmentType(this.uiDelegate.getAttachment());
        ctx.setTimeType(this.uiDelegate.getTimeIndex());
        ctx.setExcludedOwners(this.uiDelegate.getExcludedOwners());
        ctx.setExcludedAnnotators(this.uiDelegate.getExcludedAnnotators());
        this.firePropertyChange(SEARCH_PROPERTY, null, ctx);
    }

    public void setSearchEnabled(boolean b) {
        if (b) {
            this.setSearchEnabled("Searching", b);
        } else {
            this.setSearchEnabled("", b);
        }
    }

    public void setSearchEnabled(String text, boolean b) {
        this.searchButton.setEnabled(!b);
        this.busyLabel.setEnabled(b);
        this.busyLabel.setBusy(b);
        this.progressLabel.setText(text);
    }

    public void setUserString(long userID, String name) {
        if (name == null) {
            return;
        }
        if ((name = name.trim()).length() == 0) {
            return;
        }
        switch (this.userIndex) {
            case 5: {
                this.uiDelegate.setOwnerString(userID, name);
                break;
            }
            case 6: {
                this.uiDelegate.setAnnotatorString(name);
            }
        }
        this.validate();
        this.repaint();
    }

    public void displayResult(JComponent result) {
        this.remove(this.resultPane);
        this.resultPane = result;
        this.add((Component)this.resultPane, "0, 4");
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.search();
                break;
            }
            case 4: {
                this.uiDelegate.setDateIndex();
                break;
            }
            case 5: {
                this.userIndex = 5;
                this.firePropertyChange(OWNER_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                break;
            }
            case 6: {
                this.userIndex = 6;
                this.firePropertyChange(OWNER_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                break;
            }
            case 3: {
                this.help();
                break;
            }
            case 7: {
                this.uiDelegate.advancedSearch(true);
                break;
            }
            case 8: {
                this.uiDelegate.advancedSearch(false);
            }
        }
    }

    protected void help() {
    }
}

