/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.openmicroscopy.shoola.util.ui.omeeditpane.FormatSelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.Position;
import org.openmicroscopy.shoola.util.ui.omeeditpane.SelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.TextFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiView
extends PlainView {
    private JEditorPane editorPane;
    private Map<Position, String> tokenLocations;
    private Map<String, List<Position>> regexMap;
    private Map<String, FormatSelectionAction> formatMap;

    String[] getRegexList() {
        Set<String> keys = this.regexMap.keySet();
        String[] array = new String[keys.size()];
        Iterator<String> i = keys.iterator();
        int index = 0;
        while (i.hasNext()) {
            array[index] = i.next();
            ++index;
        }
        return array;
    }

    List<Position> getPositionList(String regex) {
        return this.regexMap.get(regex);
    }

    private void parse(String text) {
        this.createTokenMaps();
        for (String regex : this.formatMap.keySet()) {
            List<Position> positionList = this.createPositionList(regex);
            this.findAllExpressions(text, regex, positionList);
            this.regexMap.put(regex, positionList);
        }
    }

    private void findAllExpressions(String text, String regex, List<Position> positionList) {
        positionList.clear();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int e;
            int s = matcher.start();
            Position p = new Position(s, e = matcher.end());
            if (this.alreadyMatched(p)) continue;
            positionList.add(p);
            this.tokenLocations.put(p, regex);
        }
    }

    public static void findExpressions(String text, String regex, List<Position> positionList) {
        positionList.clear();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int s = matcher.start();
            int e = matcher.end();
            Position p = new Position(s, e);
            positionList.add(p);
        }
    }

    private boolean alreadyMatched(Position p) {
        for (Position mapPosition : this.tokenLocations.keySet()) {
            if (!mapPosition.contains(p)) continue;
            return true;
        }
        return false;
    }

    public Map<Position, String> getTokenLocations() {
        return this.tokenLocations;
    }

    private void createTokenMaps() {
        this.tokenLocations = new TreeMap<Position, String>();
        this.regexMap = new HashMap<String, List<Position>>();
    }

    private List<Position> createPositionList(String regex) {
        ArrayList<Position> positionList;
        if (!this.regexMap.containsKey(regex)) {
            positionList = new ArrayList();
            this.regexMap.put(regex, positionList);
        } else {
            positionList = this.regexMap.get(regex);
        }
        return positionList;
    }

    WikiView(Element elem, Map<String, FormatSelectionAction> formatMap, JEditorPane editorPane) {
        super(elem);
        this.formatMap = formatMap;
        this.editorPane = editorPane;
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        TextFormatter.removeHighlights(this.editorPane);
        Document doc = this.getDocument();
        String text = doc.getText(p0, p1 - p0);
        Segment segment = this.getLineBuffer();
        this.parse(text);
        int i = 0;
        for (Position p : this.tokenLocations.keySet()) {
            if (i < p.getStart()) {
                graphics.setColor(this.editorPane.getForeground());
                doc.getText(p0 + i, p.getStart() - i, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
            }
            i = p.getEnd();
            doc.getText(p0 + p.getStart(), i - p.getStart(), segment);
            String regex = this.tokenLocations.get(p);
            FormatSelectionAction fs = this.formatMap.get(regex);
            x = fs.getFormatter().formatText(this.editorPane, segment, x, y, graphics, this, i, p.getStart(), p.getEnd());
        }
        if (i < text.length()) {
            graphics.setColor(this.editorPane.getForeground());
            doc.getText(p0 + i, text.length() - i, segment);
            x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
        }
        return x;
    }

    @Override
    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        return this.drawUnselectedText(g, x, y, p0, p1);
    }

    SelectionAction getSelectionAction(int index) {
        Document doc = this.getDocument();
        try {
            this.parse(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        for (Position p : this.tokenLocations.keySet()) {
            if (!p.contains(index, index)) continue;
            String regex = this.tokenLocations.get(p);
            FormatSelectionAction fsa = this.formatMap.get(regex);
            if (fsa == null) {
                return null;
            }
            return fsa.getSelectionAction();
        }
        return null;
    }

    String getSelectedText(int index) {
        Document doc = this.getDocument();
        for (Position p : this.tokenLocations.keySet()) {
            if (!p.contains(index, index)) continue;
            try {
                return doc.getText(p.getStart(), p.length());
            }
            catch (BadLocationException e) {
                return "";
            }
        }
        try {
            return doc.getText(index, index);
        }
        catch (BadLocationException e) {
            return "";
        }
    }
}

