/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JTextPane;
import org.openmicroscopy.shoola.util.ui.omeeditpane.FormatSelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEEditorKit;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;
import org.openmicroscopy.shoola.util.ui.omeeditpane.SelectionAction;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OMEEditPane
extends JTextPane
implements FocusListener {
    private static String DOC_TYPE = "text/wiki";
    private OMEEditorKit editorKit;
    private OMEWikiComponent component;

    private void onTextSelection(MouseEvent e) {
        int index = this.viewToModel(new Point(e.getX(), e.getY()));
        WikiView view = this.editorKit.getView();
        SelectionAction action = view.getSelectionAction(index);
        this.component.onSelection(action, view.getSelectedText(index), e.getClickCount());
    }

    OMEEditPane(OMEWikiComponent component, Map<String, FormatSelectionAction> formatters) {
        this.component = component;
        this.editorKit = new OMEEditorKit(formatters);
        this.setEditorKitForContentType(DOC_TYPE, this.editorKit);
        this.setContentType(DOC_TYPE);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                OMEEditPane.this.onTextSelection(e);
            }
        });
        this.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        String text = this.getText();
        if (text != null) {
            if (this.component.getDefaultText().equals(text)) {
                this.selectAll();
            } else {
                this.setText(text);
                int n = text.length() - 1;
                if (n >= 0) {
                    this.setCaretPosition(n);
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.select(0, 0);
    }
}

