/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openmicroscopy.shoola.util.ui.login.ServerEditor;
import org.openmicroscopy.shoola.util.ui.login.ServerListEditor;
import org.openmicroscopy.shoola.util.ui.login.ServerListRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServerTable
extends JTable {
    private static final Color LINE_COLOR = Color.LIGHT_GRAY;
    private static final int INDENT = 4;
    private static final int DEFAULT_ICON_SIZE = 22;
    private int previousRow;
    private ServerEditor parent;

    private void handleClickCount(int clickCount) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    private void initComponents(Map<String, String> servers, Icon icon) {
        Object[][] objects;
        Object[] columnNames = new String[]{"", "", ""};
        Boolean focus = Boolean.TRUE;
        if (servers == null || servers.size() == 0) {
            objects = new Object[1][3];
            objects[0][0] = icon;
            objects[0][1] = "";
            objects[0][2] = this.parent.getDefaultPort();
            focus = Boolean.FALSE;
        } else {
            objects = new Object[servers.size()][3];
            Iterator<String> i = servers.keySet().iterator();
            int j = 0;
            while (i.hasNext()) {
                String s = i.next();
                objects[j][0] = icon;
                objects[j][1] = s;
                objects[j][2] = servers.get(s);
                ++j;
            }
        }
        int w = 22;
        int h = 22;
        if (icon != null) {
            w = icon.getIconWidth();
            h = icon.getIconHeight();
        }
        focus = Boolean.FALSE;
        this.putClientProperty("terminateEditOnFocusLost", focus);
        this.setSelectionMode(0);
        this.setModel(new ServerTableModel(objects, columnNames));
        ServerListRenderer rnd = new ServerListRenderer();
        this.setDefaultRenderer(Object.class, rnd);
        this.setRowHeight(h + 4);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(false);
        this.setTableHeader(null);
        this.setGridColor(LINE_COLOR);
        Dimension d = this.getIntercellSpacing();
        this.setIntercellSpacing(new Dimension(0, d.height));
        TableColumnModel tcm = this.getColumnModel();
        TableColumn column = tcm.getColumn(0);
        int n = w + 4;
        column.setMaxWidth(n);
        column.setMinWidth(n);
        column = tcm.getColumn(1);
        column.setCellEditor(new ServerListEditor(this));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ServerTable.this.handleClickCount(e.getClickCount());
            }
        });
        int width = rnd.getFontMetrics(rnd.getFont()).stringWidth("64000");
        width += width / 2;
        column = tcm.getColumn(2);
        column.setMaxWidth(width);
        column.setMinWidth(width);
        column.setCellEditor(new ServerListEditor(this));
    }

    ServerTable(ServerEditor parent, Map<String, String> servers, Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException("No model");
        }
        this.parent = parent;
        this.previousRow = -1;
        this.initComponents(servers, icon);
    }

    void handleKeyEnter() {
        this.parent.firePropertyChange("applyServer", Boolean.FALSE, Boolean.TRUE);
    }

    void handleTextModification(String text) {
        if (!this.parent.isEditing()) {
            return;
        }
        int m = this.getSelectedRow();
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (i == m) continue;
            values.add((String)this.getValueAt(i, 1));
        }
        String server = this.parent.getActiveServer();
        if (server != null && !values.contains(server)) {
            values.add(server);
        }
        Iterator j = values.iterator();
        boolean found = false;
        while (j.hasNext()) {
            String name = (String)j.next();
            if (!name.equals(text)) continue;
            found = true;
            break;
        }
        this.parent.showMessagePanel(found);
    }

    void finishEdition(String text) {
        this.parent.finishEdition(text);
    }

    void removeRow(int row) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.removeRow(row);
        this.previousRow = row - 1;
    }

    @Override
    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        super.changeSelection(row, column, toggle, extend);
        String v = null;
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        if (row != this.previousRow && row >= 0 && this.previousRow != -1) {
            if (model.getColumnCount() < 3) {
                return;
            }
            v = (String)model.getValueAt(this.previousRow, 1);
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            if (v == null || v.trim().length() == 0) {
                v = null;
            }
        }
        if (row >= 0 && model.getColumnCount() == 3) {
            this.handleTextModification((String)model.getValueAt(row, 1));
        }
        this.parent.changeSelection(row, this.previousRow, v);
        this.previousRow = row;
        if (this.editCellAt(row, column)) {
            this.getEditorComponent().requestFocusInWindow();
        }
    }

    class ServerTableModel
    extends DefaultTableModel {
        public ServerTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }
    }
}

