/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.login.ServerTable;

public class ServerListEditor
extends AbstractCellEditor
implements ActionListener,
DocumentListener,
TableCellEditor {
    private JTextField component;
    private JTextField textComponent;
    private JTextField numericalcomponent;
    private ServerTable table;

    private String getComponentValue() {
        String s = this.component.getText();
        s = s == null ? "" : s.trim();
        return s;
    }

    private void handleKeyEnter() {
        this.table.handleKeyEnter();
    }

    public ServerListEditor(ServerTable table) {
        if (table == null) {
            throw new IllegalArgumentException("No table.");
        }
        this.table = table;
        this.numericalcomponent = new NumericalTextField(0.0, 64000.0);
        this.textComponent = new JTextField();
        this.textComponent.addActionListener(this);
        this.textComponent.getDocument().addDocumentListener(this);
        this.textComponent.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ServerListEditor.this.handleKeyEnter();
                }
            }
        });
        this.component = this.textComponent;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
        this.component = colIndex == 2 ? this.numericalcomponent : this.textComponent;
        if (value != null) {
            String v = (String)value;
            if (v == null || v.trim().length() == 0) {
                v = " ";
            }
            this.component.setText(v);
        }
        return this.component;
    }

    public Object getCellEditorValue() {
        return this.getComponentValue();
    }

    public void insertUpdate(DocumentEvent e) {
        this.table.handleTextModification(this.getComponentValue());
    }

    public void removeUpdate(DocumentEvent e) {
        this.table.handleTextModification(this.getComponentValue());
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
        this.table.finishEdition(this.getComponentValue());
    }
}

