/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import layout.TableLayout;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ServerDialog;
import org.openmicroscopy.shoola.util.ui.login.ServerEditor;

public class ScreenLogin
extends JFrame
implements ActionListener,
PropertyChangeListener {
    public static final String TO_FRONT_PROPERTY = "toFront";
    public static final String LOGIN_PROPERTY = "login";
    public static final String QUIT_PROPERTY = "quit";
    public static final int USERNAME_FIELD = 0;
    public static final int PASSWORD_FIELD = 1;
    public static final String DEFAULT_SERVER = "Add a new server ->";
    static final Color TEXT_COLOR = Color.WHITE;
    private static final String OMERO_USER = "omeroUser";
    private static final String OMERO_CONNECTION_SPEED = "omeroConnectionSpeed";
    private static final float VERSION_FONT_SIZE = 14.0f;
    private static final int VERSION_FONT_STYLE = 1;
    private static final int TEXT_FONT_SIZE = 16;
    private static final String TEXT_LOGIN = "Log In";
    private static final String USER_TEXT = "Username: ";
    private static final String PASSWORD_TEXT = "Password: ";
    private static final int TEXT_COLUMN = 12;
    private JTextField user;
    private JPasswordField pass;
    private JButton configButton;
    private JButton login;
    private JButton cancel;
    private String serverName;
    private JTextPane serverText;
    private JPanel serverTextPane;
    private JLabel connectionSpeedText;
    private JTextPane versionInfo;
    private ServerEditor editor;
    private int speedIndex;
    private int selectedPort = -1;
    private boolean connectionSpeed;

    private void quit() {
        this.firePropertyChange(QUIT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    private void login() {
        String s;
        this.firePropertyChange(TO_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        this.requestFocusOnField();
        StringBuffer buf = new StringBuffer();
        buf.append(this.pass.getPassword());
        String usr = this.user.getText().trim();
        String psw = buf.toString();
        if (usr != null) {
            usr = usr.trim();
        }
        if ((s = this.serverText.getText()) != null) {
            s = s.trim();
        }
        this.setControlsEnabled(false);
        LoginCredentials lc = new LoginCredentials(usr, psw, s, this.speedIndex, this.selectedPort);
        this.setUserName(usr);
        this.setControlsEnabled(false);
        this.firePropertyChange(LOGIN_PROPERTY, null, lc);
    }

    private void config() {
        ServerDialog d = this.connectionSpeed ? new ServerDialog(this, this.editor, this.speedIndex) : new ServerDialog(this, this.editor);
        d.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(d);
    }

    private void initListeners() {
        this.login.addActionListener(this);
        this.user.addActionListener(this);
        this.pass.addActionListener(this);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.quit();
            }
        });
        this.configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScreenLogin.this.config();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                ScreenLogin.this.requestFocusOnField();
            }
        });
        this.user.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (ScreenLogin.this.user.getText() != null) {
                    ScreenLogin.this.user.selectAll();
                }
            }

            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                ScreenLogin.this.user.requestFocus();
                if (ScreenLogin.this.user.getText() != null) {
                    ScreenLogin.this.user.selectAll();
                }
            }
        });
        this.pass.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
        });
    }

    private void setButtonDefault(JButton button) {
        button.setRolloverEnabled(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void initButtons() {
        this.login = new JButton("Login");
        this.login.setMnemonic('L');
        this.login.setToolTipText("Login");
        this.setButtonDefault(this.login);
        UIUtilities.enterPressesWhenFocused(this.login);
        UIUtilities.opacityCheck(this.login);
        this.cancel = new JButton("Quit");
        this.cancel.setMnemonic('Q');
        this.cancel.setToolTipText("Quit the Application.");
        this.setButtonDefault(this.cancel);
        UIUtilities.opacityCheck(this.cancel);
        this.configButton = new JButton();
        this.configButton.setMnemonic('X');
        this.configButton.setToolTipText("Enter the server's address.");
        this.configButton.setBorderPainted(false);
        this.configButton.setBorder(null);
        this.configButton.setFocusPainted(false);
        this.configButton.setContentAreaFilled(false);
        IconManager icons = IconManager.getInstance();
        this.configButton.setIcon(icons.getIcon(25));
        this.configButton.setPressedIcon(icons.getIcon(26));
        this.getRootPane().setDefaultButton(this.login);
    }

    private void initFields(String userName) {
        this.user = new JTextField();
        this.user.setText(userName);
        this.user.setToolTipText("Enter your username.");
        this.user.setColumns(12);
        this.pass = new JPasswordField();
        this.pass.setToolTipText("Enter your password.");
        this.pass.setColumns(12);
        Map<String, String> servers = this.editor.getServers();
        if (servers == null || servers.size() == 0) {
            this.serverName = DEFAULT_SERVER;
        } else {
            int n = servers.size() - 1;
            Iterator<String> i = servers.keySet().iterator();
            int k = 0;
            while (i.hasNext()) {
                String value;
                this.serverName = i.next();
                if (k == n && (value = servers.get(this.serverName)) != null) {
                    try {
                        this.selectedPort = Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++k;
            }
        }
        this.connectionSpeedText = new JLabel(this.getConnectionSpeed());
        this.connectionSpeedText.setForeground(TEXT_COLOR);
        this.connectionSpeedText.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.serverText = UIUtilities.buildTextPane(this.serverName, TEXT_COLOR);
        this.serverTextPane = UIUtilities.buildComponentPanelRight(this.serverText, false);
        this.serverTextPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    private JPanel buildMainPanel(String version) {
        JPanel mainPanel = new JPanel();
        int g = 10;
        int t = 10;
        mainPanel.setBorder(BorderFactory.createEmptyBorder(t, g, t, g));
        mainPanel.setOpaque(false);
        double[][] size = new double[][]{{-2.0, -1.0, -2.0, -1.0, -1.0, -2.0}, {-2.0, -2.0, -2.0}};
        TableLayout layout = new TableLayout((double[][])size);
        mainPanel.setLayout((LayoutManager)layout);
        JTextPane pleaseLogIn = UIUtilities.buildTextPane(TEXT_LOGIN, TEXT_COLOR);
        Font f = pleaseLogIn.getFont();
        pleaseLogIn.setFont(f.deriveFont(1, 16.0f));
        this.versionInfo = UIUtilities.buildTextPane(version, TEXT_COLOR);
        f = this.versionInfo.getFont();
        this.versionInfo.setFont(f.deriveFont(1, 14.0f));
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.serverTextPane);
        p.add(this.connectionSpeedText);
        mainPanel.add((Component)pleaseLogIn, "0, 0, l, c");
        mainPanel.add((Component)UIUtilities.buildComponentPanelRight(p, 0, 0, false), "0, 0, 4, 0");
        mainPanel.add((Component)this.configButton, "5, 0, t, c");
        JTextPane l = UIUtilities.buildTextPane(USER_TEXT, TEXT_COLOR);
        mainPanel.add((Component)l, "0, 1, l, c");
        mainPanel.add((Component)this.user, "1, 1, 2, 1");
        l = UIUtilities.buildTextPane(" Password: ", TEXT_COLOR);
        mainPanel.add((Component)l, "3, 1, r, c");
        mainPanel.add((Component)this.pass, "4, 1, 5, 1");
        mainPanel.add((Component)this.versionInfo, "0, 2, l, c");
        JPanel cPanel = new JPanel();
        cPanel.setOpaque(false);
        cPanel.add(this.login);
        cPanel.add(this.cancel);
        mainPanel.add((Component)UIUtilities.buildComponentPanelRight(cPanel, 0, 0, false), "2, 2, 5, 2");
        return mainPanel;
    }

    private void buildGUI(Icon logo, String version) {
        JLabel background = new JLabel(logo);
        background.setBorder(BorderFactory.createEmptyBorder());
        JLayeredPane layers = new JLayeredPane();
        int width = logo.getIconWidth();
        int height = logo.getIconHeight();
        layers.setBounds(0, 0, width, height);
        JPanel p = this.buildMainPanel(version);
        background.setBounds(0, 0, width, height);
        p.setBounds(0, 0, width, height);
        layers.add((Component)background, new Integer(0));
        layers.add((Component)p, new Integer(1));
        this.getContentPane().add(layers);
    }

    private String getServerName() {
        String s = this.serverText.getText();
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private String getConnectionSpeed() {
        switch (this.speedIndex) {
            case 0: {
                return " [LAN]";
            }
            case 1: {
                return " [High]";
            }
            case 2: {
                return " [Low]";
            }
        }
        return null;
    }

    private void setNewServer(String s) {
        if (s == null || s.length() == 0) {
            s = DEFAULT_SERVER;
        }
        String[] values = s.split(":", 0);
        s = values[0];
        if (values.length == 2) {
            try {
                this.selectedPort = Integer.parseInt(values[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverText.setText(s);
        this.serverTextPane.validate();
        this.serverTextPane.repaint();
    }

    private void setConnectionSpeed(int speed) {
        this.speedIndex = speed;
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        prefs.put(OMERO_CONNECTION_SPEED, "" + this.speedIndex);
    }

    private int retrieveConnectionSpeed() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        String s = prefs.get(OMERO_CONNECTION_SPEED, null);
        if (s == null || s.trim().length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    private void setUserName(String name) {
        if (name == null) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        prefs.put(OMERO_USER, name);
    }

    private String getUserName() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenLogin.class);
        return prefs.get(OMERO_USER, null);
    }

    private void setProperties(Image frameIcon) {
        this.setIconImage(frameIcon);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setUndecorated(true);
        this.toFront();
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon, String version, String defaultPort) {
        this.setTitle(title);
        if (logo == null) {
            throw new NullPointerException("No Frame icon.");
        }
        Dimension d = new Dimension(logo.getIconWidth(), logo.getIconHeight());
        this.setSize(d);
        this.setPreferredSize(d);
        this.editor = new ServerEditor(defaultPort);
        this.editor.addPropertyChangeListener("remove", this);
        this.connectionSpeed = false;
        this.speedIndex = this.retrieveConnectionSpeed();
        this.initFields(this.getUserName());
        this.initButtons();
        this.initListeners();
        this.buildGUI(logo, version);
        this.setProperties(frameIcon);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ScreenLogin.this.firePropertyChange(ScreenLogin.TO_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                ScreenLogin.this.requestFocusOnField();
            }
        });
    }

    public ScreenLogin(String title, Icon logo, Image frameIcon) {
        this(title, logo, frameIcon, null, null);
    }

    public ScreenLogin(Icon logo, Image frameIcon, String version) {
        this(null, logo, frameIcon, version, null);
    }

    public ScreenLogin(Icon logo, Image frameIcon) {
        this(null, logo, frameIcon, null, null);
    }

    public void showConnectionSpeed(boolean connectionSpeed) {
        this.connectionSpeed = connectionSpeed;
        this.connectionSpeedText.setVisible(connectionSpeed);
    }

    public void setControlsEnabled(boolean b) {
        this.user.setEnabled(b);
        this.pass.setEnabled(b);
        this.login.setEnabled(b);
        this.login.requestFocus();
        this.configButton.setEnabled(b);
        if (b) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setButtonDefault(this.login);
            this.setButtonDefault(this.cancel);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.login.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void cleanFields() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.user.setText("");
        this.pass.setText("");
    }

    public void cleanField(int fieldID) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        switch (fieldID) {
            case 0: {
                this.user.setText("");
                break;
            }
            case 1: {
                this.pass.setText("");
                break;
            }
            default: {
                this.cleanFields();
            }
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void requestFocusOnField() {
        this.setControlsEnabled(true);
        String txt = this.user.getText();
        if (txt == null || txt.trim().length() == 0) {
            this.user.requestFocus();
        } else {
            this.pass.requestFocus();
        }
    }

    public void setQuitButtonText(String text) {
        if (text == null) {
            return;
        }
        if ((text = text.trim()).length() == 0) {
            return;
        }
        if (text.equals(this.cancel.getText())) {
            return;
        }
        this.cancel.setText(text);
        char c = text.toUpperCase().charAt(0);
        this.setQuitButtonMnemonic(c);
    }

    public void setQuitButtonToolTipText(String toolTipText) {
        this.cancel.setToolTipText(toolTipText);
    }

    public void setQuitButtonMnemonic(int mnemonic) {
        this.cancel.setMnemonic(mnemonic);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("server".equals(name)) {
            String v = this.getServerName();
            String s = (String)evt.getNewValue();
            if (s == null) {
                this.setNewServer(null);
                return;
            }
            String trim = s.trim();
            if (v.equals(trim)) {
                return;
            }
            this.setNewServer(trim);
        } else if ("remove".equals(name)) {
            this.requestFocusOnField();
            String v = this.getServerName();
            String oldValue = (String)evt.getOldValue();
            if (v.equals(oldValue)) {
                this.setNewServer((String)evt.getNewValue());
            }
        } else if ("connectionSpeed".endsWith(name)) {
            this.setConnectionSpeed((Integer)evt.getNewValue());
            this.connectionSpeedText.setText(this.getConnectionSpeed());
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.login();
    }
}

