/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

public class LoginCredentials {
    public static final int HIGH = 0;
    public static final int MEDIUM = 1;
    public static final int LOW = 2;
    private String userName;
    private String password;
    private String hostName;
    private int speedLevel;
    private int port;

    private void checkSpeedLevel(int level) {
        switch (level) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Speed level not valid.");
    }

    public LoginCredentials(String userName, String password, String hostName, int speedLevel, int port) {
        this.checkSpeedLevel(speedLevel);
        this.speedLevel = speedLevel;
        this.userName = userName;
        this.password = password;
        this.hostName = hostName;
        this.port = port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getSpeedLevel() {
        return this.speedLevel;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("User Name: ");
        buf.append(this.userName);
        buf.append(" -- Password: ");
        for (int i = 0; i < this.password.length(); ++i) {
            buf.append('*');
        }
        return buf.toString();
    }
}

