/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.lens.LensMenu;
import org.openmicroscopy.shoola.util.ui.lens.StatusPanel;
import org.openmicroscopy.shoola.util.ui.lens.ZoomPanel;

class ZoomWindowUI
extends JDialog {
    private static final Dimension DEFAULT_SIZE = new Dimension(300, 300);
    private static final Point DEFAULT_LOC = new Point(900, 200);
    private ZoomPanel zoomPanel;
    private JScrollPane scrollPanel;
    private StatusPanel statusPanel;
    private LensComponent lensComponent;
    private JMenuBar menu;
    private LensMenu lensMenu;

    private void close() {
        this.lensComponent.zoomWindowClosed();
    }

    ZoomWindowUI(JFrame parent, LensComponent lensComponent) {
        super(parent);
        if (lensComponent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.lensComponent = lensComponent;
        this.setTitle("Zoom Window");
        this.setSize(DEFAULT_SIZE);
        this.setLocation(DEFAULT_LOC);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ZoomWindowUI.this.close();
            }
        });
        this.zoomPanel = new ZoomPanel();
        this.scrollPanel = new JScrollPane(this.zoomPanel);
        this.statusPanel = new StatusPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPanel, "Center");
        this.add((Component)this.statusPanel, "South");
        this.lensMenu = new LensMenu(lensComponent);
        this.menu = this.lensMenu.getMenubar();
        this.setJMenuBar(this.menu);
    }

    void setZoomedImageSize(int w, int h) {
        int y;
        this.zoomPanel.setSize(new Dimension(w, h));
        this.zoomPanel.setPreferredSize(new Dimension(w, h));
        this.zoomPanel.setMinimumSize(new Dimension(w, h));
        this.zoomPanel.setMaximumSize(new Dimension(w, h));
        JViewport currentView = this.scrollPanel.getViewport();
        int viewportW = currentView.getWidth();
        int viewportH = currentView.getHeight();
        int x = w / 2 - viewportW / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = h / 2 - viewportH / 2) < 0) {
            y = 0;
        }
        currentView.setViewPosition(new Point(x, y));
    }

    void setDisplayInPixels(boolean b) {
        this.statusPanel.setDisplayInPixels(b);
        this.statusPanel.repaint();
    }

    void setXYPixelMicron(double x, double y) {
        this.statusPanel.setXYPixelMicron(x, y);
        this.statusPanel.repaint();
    }

    void setLensXY(int x, int y) {
        this.statusPanel.setLensXY(x, y);
    }

    void setLensWidthHeight(int w, int h) {
        this.statusPanel.setLensWidthHeight(w, h);
    }

    void setLensZoomFactor(float zoomFactor) {
        this.statusPanel.setLensZoomFactor(zoomFactor);
    }

    void setZoomImage(BufferedImage zoomImage) {
        this.zoomPanel.setZoomImage(zoomImage);
    }

    void setSelectedSize(int index) {
        this.lensMenu.setSelectedSize(index);
    }

    void setZoomIndex(int index) {
        this.lensMenu.setZoomIndex(index);
    }
}

