/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.lens.LensController;
import org.openmicroscopy.shoola.util.ui.lens.LensMouseListener;

public class LensUI
extends JPanel {
    private int borderPickSize = 8;
    static final int NORTH = 0;
    static final int NORTH_WEST = 1;
    static final int NORTH_EAST = 2;
    static final int SOUTH = 3;
    static final int SOUTH_WEST = 4;
    static final int SOUTH_EAST = 5;
    static final int EAST = 6;
    static final int WEST = 7;
    static final int MINIMUM_HEIGHT = 20;
    static final int MAXIMUM_HEIGHT = 150;
    static final int MINIMUM_WIDTH = 20;
    static final int MAXIMUM_WIDTH = 150;
    static final int CROSSHAIR_SNAP = 30;
    static final int SNAPPED_CROSSHAIR = 6;
    static final int UNSNAPPED_CROSSHAIR = 8;
    static final Color DEFAULT_LENS_COLOR = new Color(128, 128, 128, 240);
    private int crosshairLength = 8;
    private int crosshairTick = this.crosshairLength / 2 - 1;
    private Color lensBorderColour = DEFAULT_LENS_COLOR;
    private Color lensCrossHairColour = new Color(194, 194, 194, 220);
    private LensController lensController;
    private boolean showCrossHair;
    private LensMouseListener mouseListener;
    private LensComponent lensComponent;
    private JPopupMenu menu;

    private void setPickParam(int w, int h) {
        if (Math.min(w, h) < 30) {
            this.crosshairLength = 6;
            this.borderPickSize = 4;
        } else {
            this.crosshairLength = 8;
            this.borderPickSize = 8;
        }
        this.crosshairTick = this.crosshairLength / 2 - 1;
    }

    LensUI(LensComponent lensComponent, int w, int h) {
        this.lensComponent = lensComponent;
        this.setSize(new Dimension(w, h));
        this.setOpaque(false);
        this.setShowCrossHair(true);
        this.mouseListener = new LensMouseListener(this);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addMouseWheelListener(this.mouseListener);
    }

    void setPopupMenu(JPopupMenu menu) {
        this.menu = menu;
    }

    void setPreferredSize(int w, int h) {
        super.setPreferredSize(new Dimension(w, h));
        this.setPickParam(w, h);
    }

    boolean lensPicked(int x, int y) {
        Rectangle rect = new Rectangle(this.borderPickSize, this.borderPickSize, this.getWidth() - this.borderPickSize * 2, this.getHeight() - this.borderPickSize * 2);
        return rect.contains(x, y);
    }

    void setImageZoomFactor() {
        this.setSize(this.lensComponent.getLensScaledSize());
        this.setLocation(this.lensComponent.getLensScaledLocation().x, this.lensComponent.getLensScaledLocation().y);
    }

    boolean lensBorderPicked(int x, int y) {
        Rectangle rect = new Rectangle(this.borderPickSize, this.borderPickSize, this.getWidth() - this.borderPickSize * 2, this.getHeight() - this.borderPickSize * 2);
        Rectangle rectBorder = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        return !rect.contains(x, y) && rectBorder.contains(x, y);
    }

    void setShowCrossHair(boolean show) {
        this.showCrossHair = show;
    }

    void mouseMoved(int x, int y) {
        this.lensController.lensMouseMoved(x, y);
        this.lensComponent.updateLensLocation();
    }

    void mouseDown(int x, int y) {
        this.lensController.lensMouseDown(x, y);
    }

    void mouseDrag(int x, int y, boolean shift) {
        this.lensController.lensMouseDrag(x, y, shift);
        this.lensComponent.updateLensLocation();
    }

    void mouseUp(int x, int y) {
        this.lensController.lensMouseUp(x, y);
        this.lensComponent.updateLensSize();
    }

    void mouseWheelMoved(int tick) {
        this.lensComponent.lensMouseWheelMoved(tick);
    }

    void showMenu(int x, int y) {
        this.menu.show(this, x, y);
    }

    void addController(LensController lensController) {
        this.lensController = lensController;
    }

    int getPickDir(int x, int y) {
        int resizeDir = -1;
        int resizeCornerSize = 0;
        if (x <= this.borderPickSize) {
            resizeDir = y < resizeCornerSize + this.borderPickSize ? 1 : (y > this.getHeight() - resizeCornerSize - this.borderPickSize ? 4 : 7);
        } else if (x >= this.getWidth() - this.borderPickSize) {
            resizeDir = y < resizeCornerSize + this.borderPickSize ? 2 : (y > this.getHeight() - resizeCornerSize - this.borderPickSize ? 5 : 6);
        } else if (y <= this.borderPickSize) {
            resizeDir = x < resizeCornerSize + this.borderPickSize ? 1 : (x > this.getWidth() - resizeCornerSize - this.borderPickSize ? 2 : 0);
        } else if (y >= this.getHeight() - this.borderPickSize) {
            resizeDir = x < resizeCornerSize + this.borderPickSize ? 4 : (x > this.getWidth() - resizeCornerSize - this.borderPickSize ? 5 : 3);
        }
        return resizeDir;
    }

    void setLensColour(Color c) {
        if (c == null) {
            return;
        }
        this.lensBorderColour = c;
        this.lensCrossHairColour = c;
        this.invalidate();
        this.repaint();
    }

    public void paintComponent(Graphics og) {
        super.paintComponent(og);
        Graphics2D g = (Graphics2D)og;
        g.setStroke(new BasicStroke(2.0f));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.lensBorderColour);
        g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
        if (this.showCrossHair) {
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(this.lensCrossHairColour);
            g.drawLine((this.getWidth() - this.crosshairTick + 1) / 2, (this.getHeight() - this.crosshairTick + 1) / 2 - this.crosshairLength, (this.getWidth() - this.crosshairTick + 1) / 2, (this.getHeight() - this.crosshairTick + 1) / 2 - this.crosshairTick);
            g.drawLine((this.getWidth() - this.crosshairTick + 1) / 2, (this.getHeight() - this.crosshairTick + 1) / 2 + this.crosshairTick, (this.getWidth() - this.crosshairTick + 1) / 2, (this.getHeight() - this.crosshairTick + 1) / 2 + this.crosshairLength);
            g.drawLine((this.getWidth() - this.crosshairTick + 1) / 2 - this.crosshairLength, (this.getHeight() - this.crosshairTick + 1) / 2, (this.getWidth() - this.crosshairTick + 1) / 2 - this.crosshairTick, (this.getHeight() - this.crosshairTick + 1) / 2);
            g.drawLine((this.getWidth() - this.crosshairTick + 1) / 2 + this.crosshairTick, (this.getHeight() - this.crosshairTick + 1) / 2, (this.getWidth() - this.crosshairTick + 1) / 2 + this.crosshairLength, (this.getHeight() - this.crosshairTick + 1) / 2);
        }
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this.getWidth(), this.getHeight());
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.setPickParam(d.width, d.height);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.setPickParam(w, h);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.setPickParam(w, h);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }
}

