/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.Cursor;
import org.openmicroscopy.shoola.util.ui.lens.LensModel;
import org.openmicroscopy.shoola.util.ui.lens.LensUI;
import org.openmicroscopy.shoola.util.ui.lens.ZoomWindow;

class LensController {
    private LensModel lensModel;
    private LensUI lens;
    private int offsetX;
    private int offsetY;
    private int startX;
    private int startY;
    private ZoomWindow zoomWindow;
    private int resizeDir;
    private boolean lensDrag;
    private boolean borderDrag;

    private boolean checkBounds(int dx, int dy, int dw, int dh) {
        int newX = this.lens.getX() + dx;
        int newY = this.lens.getY() + dy;
        int newWidth = (int)((float)(this.lens.getWidth() + dw) / this.lensModel.getImageZoomFactor());
        int newHeight = (int)((float)(this.lens.getHeight() + dh) / this.lensModel.getImageZoomFactor());
        return newX > 0 && newY > 0 && newWidth >= 20 && newWidth <= 150 && newHeight >= 20 && newHeight <= 150 && newHeight + newY <= this.lensModel.getImageScaledHeight() && newWidth + newX <= this.lensModel.getImageScaledWidth();
    }

    private void setLensBounds(int dx, int dy, int dw, int dh, boolean keepSquare) {
        int newX = this.lens.getX() + dx;
        int newY = this.lens.getY() + dy;
        if (keepSquare) {
            int mx = Math.max(dw, dh);
            int mn = Math.min(dw, dh);
            if (Math.abs(mx) > Math.abs(mn)) {
                dw = mx;
                dh = mx;
            } else {
                dw = mn;
                dh = mn;
            }
        }
        if (this.checkBounds(dx, dy, dw, dh)) {
            int newWidth = this.lens.getWidth() + dw;
            int newHeight = this.lens.getHeight() + dh;
            this.lens.setBounds(newX, newY, newWidth, newHeight);
            double f = this.lensModel.getImageZoomFactor();
            this.lensModel.setLensLocation((int)((double)newX / f), (int)((double)newY / f));
            this.lensModel.setWidth((int)((double)newWidth / f));
            this.lensModel.setHeight((int)((double)newHeight / f));
            this.zoomWindow.setLensXY(this.lensModel.getX(), this.lensModel.getY());
            this.zoomWindow.setLensWidthHeight(this.lensModel.getWidth(), this.lensModel.getHeight());
            this.setZoomUISize();
        }
    }

    private void setZoomUISize() {
        float zoomFactor = this.lensModel.getZoomFactor();
        int width = this.lensModel.getWidth();
        int height = this.lensModel.getHeight();
        this.zoomWindow.setZoomUISize((float)width * zoomFactor, (float)height * zoomFactor);
        this.zoomWindow.setLensZoomFactor(zoomFactor);
        this.zoomWindow.setZoomImage(this.lensModel.getZoomedImage());
    }

    private Cursor getCursorForDir(int resizeDir) {
        Cursor s = Cursor.getPredefinedCursor(0);
        switch (resizeDir) {
            case 3: {
                s = new Cursor(9);
                break;
            }
            case 0: {
                s = Cursor.getPredefinedCursor(8);
                break;
            }
            case 7: {
                s = Cursor.getPredefinedCursor(10);
                break;
            }
            case 6: {
                s = Cursor.getPredefinedCursor(11);
                break;
            }
            case 5: {
                s = Cursor.getPredefinedCursor(5);
                break;
            }
            case 4: {
                s = Cursor.getPredefinedCursor(4);
                break;
            }
            case 1: {
                s = Cursor.getPredefinedCursor(6);
                break;
            }
            case 2: {
                s = Cursor.getPredefinedCursor(7);
            }
        }
        return s;
    }

    LensController(LensModel model, LensUI lens, ZoomWindow zoomWindow) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (lens == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (zoomWindow == null) {
            throw new IllegalArgumentException("No window.");
        }
        this.lensModel = model;
        this.lens = lens;
        this.zoomWindow = zoomWindow;
        this.lensModel.setZoomFactor(2.0f);
        this.setZoomUISize();
        this.lensDrag = false;
        this.borderDrag = false;
    }

    void setLensLocation(int x, int y) {
        this.lensModel.setLensLocation(x, y);
        this.lens.setLocation(this.lensModel.getScaledX(), this.lensModel.getScaledY());
        this.zoomWindow.setZoomImage(this.lensModel.getZoomedImage());
        this.zoomWindow.setLensXY(this.lensModel.getX(), this.lensModel.getY());
        this.zoomWindow.setLensWidthHeight(this.lensModel.getWidth(), this.lensModel.getHeight());
    }

    void setLensSize(int w, int h) {
        int scaledW = (int)((float)w * this.lensModel.getImageZoomFactor());
        int scaledH = (int)((float)h * this.lensModel.getImageZoomFactor());
        if (this.lens.getX() + scaledW > this.lensModel.getImageScaledWidth()) {
            scaledW = this.lensModel.getImageScaledWidth() - this.lens.getX();
            w = (int)((float)scaledW / this.lensModel.getImageZoomFactor());
        }
        if (this.lens.getY() + scaledH > this.lensModel.getImageScaledHeight()) {
            scaledH = this.lensModel.getImageScaledHeight() - this.lens.getY();
            h = (int)((float)scaledH / this.lensModel.getImageZoomFactor());
        }
        this.lensModel.setWidth(w);
        this.lensModel.setHeight(h);
        this.lens.setSize(scaledW, scaledH);
        this.zoomWindow.setZoomImage(this.lensModel.getZoomedImage());
        this.zoomWindow.setLensWidthHeight(this.lensModel.getWidth(), this.lensModel.getHeight());
        this.setZoomUISize();
    }

    void setZoomFactor(float zoomFactor) {
        this.lensModel.setZoomFactor(zoomFactor);
        this.setZoomUISize();
        this.zoomWindow.setZoomImage(this.lensModel.getZoomedImage());
    }

    void setShowCrossHairs(boolean isVisible) {
        this.lens.setShowCrossHair(isVisible);
    }

    void lensMouseUp(int x, int y) {
        this.lensDrag = false;
        this.borderDrag = false;
        this.offsetX = 0;
        this.offsetY = 0;
        this.lens.setCursor(Cursor.getPredefinedCursor(12));
    }

    void lensMouseMoved(int x, int y) {
        if (this.lens.lensPicked(x, y)) {
            Cursor s = Cursor.getPredefinedCursor(12);
            this.lens.setCursor(s);
        } else if (this.lens.lensBorderPicked(x, y)) {
            this.resizeDir = this.lens.getPickDir(x, y);
            Cursor s = this.getCursorForDir(this.resizeDir);
            this.lens.setCursor(s);
        }
    }

    void lensMouseDown(int x, int y) {
        if (this.lens.lensBorderPicked(x, y)) {
            this.borderDrag = true;
            this.resizeDir = this.lens.getPickDir(x, y);
            Cursor s = this.getCursorForDir(this.resizeDir);
            this.lens.setCursor(s);
            this.startX = this.lens.getX();
            this.startY = this.lens.getY();
            this.offsetX = x;
            this.offsetY = y;
        } else if (this.lens.lensPicked(x, y)) {
            this.offsetX = x;
            this.offsetY = y;
            this.startX = this.lens.getX();
            this.startY = this.lens.getY();
            this.lensDrag = true;
        }
    }

    void lensMouseDrag(int x, int y, boolean isShiftDown) {
        if (this.borderDrag) {
            int deltaX = 0;
            int deltaY = 0;
            int deltaW = 0;
            int deltaH = 0;
            switch (this.resizeDir) {
                case 0: {
                    if (y - this.offsetY < 0) {
                        deltaY = y - this.offsetY;
                        deltaH = Math.abs(y - this.offsetY);
                        if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                        this.startY += y - this.offsetY;
                        break;
                    }
                    deltaY = y - this.offsetY;
                    deltaH = -Math.abs(y - this.offsetY);
                    if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                    this.startY += y - this.offsetY;
                    break;
                }
                case 3: {
                    if (y - this.offsetY > 0) {
                        deltaH = Math.abs(y - this.offsetY);
                        if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                        this.offsetY = y;
                        break;
                    }
                    deltaH = -Math.abs(y - this.offsetY);
                    if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                    this.offsetY = y;
                    break;
                }
                case 6: {
                    if (x - this.offsetX > 0) {
                        deltaW = Math.abs(x - this.offsetX);
                        if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                        this.offsetX = x;
                        break;
                    }
                    deltaW = -Math.abs(x - this.offsetX);
                    if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                    this.offsetX = x;
                    break;
                }
                case 7: {
                    if (x - this.offsetX > 0) {
                        deltaX = x - this.offsetX;
                        deltaW = -Math.abs(x - this.offsetX);
                        if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                        this.startX += x - this.offsetX;
                        break;
                    }
                    deltaX = -Math.abs(x - this.offsetX);
                    if (!this.checkBounds(deltaX, deltaY, deltaW = Math.abs(x - this.offsetX), deltaH)) break;
                    this.startX += x - this.offsetX;
                    break;
                }
                case 2: {
                    if (y - this.offsetY < 0) {
                        deltaY = y - this.offsetY;
                        deltaH = Math.abs(y - this.offsetY);
                        if (this.checkBounds(deltaX, deltaY, deltaW, deltaH)) {
                            this.startY += y - this.offsetY;
                        }
                    } else {
                        deltaY = y - this.offsetY;
                        deltaH = -Math.abs(y - this.offsetY);
                        if (this.checkBounds(deltaX, deltaY, deltaW, deltaH)) {
                            this.startY += y - this.offsetY;
                        }
                    }
                    if (x - this.offsetX > 0) {
                        deltaW = Math.abs(x - this.offsetX);
                        if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                        this.offsetX = x;
                        break;
                    }
                    deltaW = -Math.abs(x - this.offsetX);
                    if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                    this.offsetX = x;
                    break;
                }
                case 1: {
                    if (y - this.offsetY < 0) {
                        deltaY = y - this.offsetY;
                        deltaH = Math.abs(y - this.offsetY);
                        if (this.checkBounds(deltaX, deltaY, deltaW, deltaH)) {
                            this.startY += y - this.offsetY;
                        }
                    } else {
                        deltaY = y - this.offsetY;
                        deltaH = -Math.abs(y - this.offsetY);
                        if (this.checkBounds(deltaX, deltaY, deltaW, deltaH)) {
                            this.startY += y - this.offsetY;
                        }
                    }
                    if (x - this.offsetX > 0) {
                        deltaX = x - this.offsetX;
                        deltaW = -Math.abs(x - this.offsetX);
                        if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                        this.startX += x - this.offsetX;
                        break;
                    }
                    deltaX = -Math.abs(x - this.offsetX);
                    if (!this.checkBounds(deltaX, deltaY, deltaW = Math.abs(x - this.offsetX), deltaH)) break;
                    this.startX += x - this.offsetX;
                    break;
                }
                case 5: {
                    if (y - this.offsetY > 0) {
                        deltaH = Math.abs(y - this.offsetY);
                        if (this.checkBounds(deltaX, deltaY, deltaW, deltaH)) {
                            this.offsetY = y;
                        }
                    } else {
                        deltaH = -Math.abs(y - this.offsetY);
                        if (this.checkBounds(deltaX, deltaY, deltaW, deltaH)) {
                            this.offsetY = y;
                        }
                    }
                    if (x - this.offsetX > 0) {
                        deltaW = Math.abs(x - this.offsetX);
                        if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                        this.offsetX = x;
                        break;
                    }
                    deltaW = -Math.abs(x - this.offsetX);
                    if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                    this.offsetX = x;
                    break;
                }
                case 4: {
                    if (y - this.offsetY > 0) {
                        deltaH = Math.abs(y - this.offsetY);
                        if (this.checkBounds(deltaX, deltaY, deltaW, deltaH)) {
                            this.offsetY = y;
                        }
                    } else {
                        deltaH = -Math.abs(y - this.offsetY);
                        if (this.checkBounds(deltaX, deltaY, deltaW, deltaH)) {
                            this.offsetY = y;
                        }
                    }
                    if (x - this.offsetX > 0) {
                        deltaX = x - this.offsetX;
                        deltaW = -Math.abs(x - this.offsetX);
                        if (!this.checkBounds(deltaX, deltaY, deltaW, deltaH)) break;
                        this.startX += x - this.offsetX;
                        break;
                    }
                    deltaX = -Math.abs(x - this.offsetX);
                    if (!this.checkBounds(deltaX, deltaY, deltaW = Math.abs(x - this.offsetX), deltaH)) break;
                    this.startX += x - this.offsetX;
                }
            }
            this.setLensBounds(deltaX, deltaY, deltaW, deltaH, isShiftDown);
        }
        if (this.lensDrag) {
            double v;
            boolean moveX = true;
            boolean moveY = true;
            if (this.startX + (x - this.offsetX) < 0) {
                moveX = false;
                this.startX = 0;
            }
            if ((v = (double)((float)(this.startX + (x - this.offsetX)) / this.lensModel.getImageZoomFactor() + (float)this.lensModel.getWidth())) > (double)this.lensModel.getImageWidth()) {
                moveX = false;
                this.startX = this.lensModel.getImageScaledWidth() - this.lensModel.getScaledWidth();
            }
            if (this.startY + (y - this.offsetY) < 0) {
                moveY = false;
                this.startY = 0;
            }
            if (this.startY + (y - this.offsetY) + this.lens.getHeight() > this.lensModel.getImageScaledHeight()) {
                moveY = false;
                this.startY = this.lensModel.getImageScaledHeight() - this.lensModel.getScaledHeight();
            }
            if (moveX) {
                this.startX += x - this.offsetX;
            }
            if (moveY) {
                this.startY += y - this.offsetY;
            }
            this.setLensLocation((int)((float)this.startX / this.lensModel.getImageZoomFactor()), (int)((float)this.startY / this.lensModel.getImageZoomFactor()));
        }
    }
}

