/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.lens.LensAction;
import org.openmicroscopy.shoola.util.ui.lens.LensController;
import org.openmicroscopy.shoola.util.ui.lens.LensMenu;
import org.openmicroscopy.shoola.util.ui.lens.LensModel;
import org.openmicroscopy.shoola.util.ui.lens.LensUI;
import org.openmicroscopy.shoola.util.ui.lens.ZoomAction;
import org.openmicroscopy.shoola.util.ui.lens.ZoomWindow;

public class LensComponent
extends AbstractComponent {
    public static final String LENS_LOCATION_PROPERTY = "lensLocation";
    static final String ZOOM_WINDOW_CLOSED_PROPERTY = "zoomWindowClosed";
    static final int LENS_DEFAULT_WIDTH = 50;
    static final float DEFAULT_ZOOM = 2.0f;
    private LensUI lens;
    private LensMenu menu;
    private LensController lensController;
    private ZoomWindow zoomWindow;
    private LensModel lensModel;

    void setDisplayInPixels(boolean b) {
        this.zoomWindow.setDisplayInPixels(b);
        this.zoomWindow.setLensXY(this.lens.getX(), this.lens.getY());
        this.zoomWindow.setLensWidthHeight(this.lens.getWidth(), this.lens.getHeight());
    }

    void setLensSize(int width, int height) {
        this.lensController.setLensSize(width, height);
    }

    void updateLensLocation() {
        Rectangle bounds = this.lensModel.getLensScaledBounds();
        this.firePropertyChange(LENS_LOCATION_PROPERTY, null, bounds);
    }

    void updateLensSize() {
        int w = this.lensModel.getWidth();
        int h = this.lensModel.getHeight();
        int index = LensAction.sizeToIndex(w, h);
        this.menu.setSelectedSize(index);
        this.zoomWindow.setSelectedSize(index);
    }

    void setZoomFactor(float zoomFactor) {
        this.lensController.setZoomFactor(zoomFactor);
        int index = ZoomAction.factorToIndex(zoomFactor);
        this.menu.setZoomIndex(index);
        this.zoomWindow.setZoomIndex(index);
    }

    void lensMouseWheelMoved(int tick) {
        float zoomFactor = this.lensModel.getZoomFactor();
        zoomFactor -= 0.1f * (float)tick;
        if ((zoomFactor = (float)Math.round(zoomFactor * 10.0f) / 10.0f) < 1.0f) {
            zoomFactor = 1.0f;
        }
        if (zoomFactor > 10.0f) {
            zoomFactor = 10.0f;
        }
        this.setZoomFactor(zoomFactor);
    }

    public LensComponent(JFrame parent, BufferedImage planeImage) {
        this.lensModel = new LensModel(planeImage);
        this.zoomWindow = new ZoomWindow(parent, this);
        this.lens = new LensUI(this, 50, 50);
        this.lensController = new LensController(this.lensModel, this.lens, this.zoomWindow);
        this.lensModel.setWidth(50);
        this.lensModel.setHeight(50);
        this.lensModel.setImageZoomFactor(1.0f);
        this.lens.addController(this.lensController);
        this.lens.setLensColour(this.lensModel.getLensPreferredColour());
        this.menu = new LensMenu(this);
        this.lens.setPopupMenu(this.menu.getPopupMenu());
        this.zoomWindow.setMenu(this.menu.getMenubar());
    }

    public LensComponent(JFrame parent) {
        this(parent, null);
    }

    public void setLensPreferredColour() {
        this.lens.setLensColour(this.lensModel.getLensPreferredColour());
    }

    public void zoomWindowClosed() {
        this.zoomWindow.setVisible(false);
        this.lens.setVisible(false);
    }

    public void setXYPixelMicron(double x, double y) {
        this.zoomWindow.setXYPixelMicron(x, y);
    }

    public void setPlaneImage(BufferedImage img) {
        this.lensModel.setPlaneImage(img);
        this.zoomWindow.setZoomImage(this.lensModel.getZoomedImage());
        this.zoomWindow.repaint();
    }

    public void setVisible(boolean makeVisible) {
        this.lens.setVisible(makeVisible);
        this.zoomWindow.setVisible(makeVisible);
    }

    public void setImageZoomFactor(float imageZoomFactor) {
        if (imageZoomFactor < 1.0f) {
            imageZoomFactor = 1.0f;
        }
        if (imageZoomFactor > 10.0f) {
            imageZoomFactor = 10.0f;
        }
        this.lensModel.setImageZoomFactor(imageZoomFactor);
        this.lens.setImageZoomFactor();
    }

    public void setLensLocation(int x, int y) {
        this.lensController.setLensLocation(x, y);
    }

    public BufferedImage getZoomedImage() {
        return this.lensModel.getZoomedImage();
    }

    public LensUI getLensUI() {
        return this.lens;
    }

    public boolean isVisible() {
        return this.lens.isVisible() && this.zoomWindow.isVisible();
    }

    public void setLensLocation(Point loc) {
        this.setLensLocation(loc.x, loc.y);
    }

    public Dimension getLensScaledSize() {
        return this.lensModel.getLensScaledSize();
    }

    public Point getLensScaledLocation() {
        return this.lensModel.getLensScaledLocation();
    }

    public void setLensColour(Color color) {
        if (color == null) {
            return;
        }
        this.lens.setLensColour(color);
    }

    public Rectangle getLensScaledBounds() {
        return this.lensModel.getLensScaledBounds();
    }

    public Point getLensLocation() {
        return this.lensModel.getLensLocation();
    }

    public Component getZoomWindowUI() {
        return this.zoomWindow.getUI();
    }

    public BufferedImage createZoomedImage(BufferedImage image) throws Exception {
        if (image == null) {
            return null;
        }
        return this.lensModel.createZoomedImage(image);
    }

    public void resetLens(BufferedImage image, float f, int x, int y) {
        this.lensModel.setImageZoomFactor(f);
        this.lensModel.setPlaneImage(image);
        this.lensModel.setLensLocation(x, y);
        this.lens.setImageZoomFactor();
        this.lensController.setLensLocation(x, y);
        this.zoomWindow.setZoomImage(this.lensModel.getZoomedImage());
        this.zoomWindow.repaint();
    }

    public void resetDataBuffered() {
        this.lensModel.resetDataBuffer();
    }
}

