/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.filechooser;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.RegExFileFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.filechooser.FileSaverUI;

class CustomizedFileChooser
extends JFileChooser
implements DocumentListener,
KeyListener {
    private static final String LOAD_LABEL = "Load:";
    private static final String FOLDER_LABEL = "Save in:";
    private FileChooser model;
    private FileSaverUI view;
    private JTextField nameArea;
    private RegExFileFilter filter;

    private void initComponents() {
        this.nameArea = (JTextField)UIUtilities.findComponent(this, JTextField.class);
        if (this.nameArea != null) {
            this.nameArea.setVisible(true);
            this.nameArea.getDocument().addDocumentListener(this);
            if (this.model.getChooserType() == 0) {
                this.nameArea.addKeyListener(this);
            }
        }
    }

    private void buildGUI() {
        File f;
        this.setAcceptAllFileFilterUsed(false);
        this.setControlButtonsAreShown(this.nameArea == null);
        List<FileFilter> filters = this.model.getFilters();
        if (filters != null) {
            for (FileFilter filter : filters) {
                this.addChoosableFileFilter(filter);
            }
            this.setFileFilter(filters.get(0));
        }
        if ((f = UIUtilities.getDefaultFolder()) != null) {
            this.setCurrentDirectory(f);
        }
        switch (this.model.getChooserType()) {
            case 1: {
                this.setDialogType(1);
                this.setFileSelectionMode(0);
                break;
            }
            case 0: {
                JLabel label = (JLabel)UIUtilities.findComponent(this, JLabel.class);
                if (label != null) {
                    label.setText(LOAD_LABEL);
                }
                this.setFileSelectionMode(0);
                break;
            }
            case 2: {
                JLabel label = (JLabel)UIUtilities.findComponent(this, JLabel.class);
                if (label != null) {
                    label.setText(FOLDER_LABEL);
                }
                this.setFileSelectionMode(1);
                this.setCurrentDirectory(this.getFileSystemView().getHomeDirectory());
                return;
            }
        }
    }

    private String getFormat(FileFilter selectedFilter) {
        List<FileFilter> filters = this.model.getFilters();
        if (filters == null) {
            return "";
        }
        for (FileFilter filter : filters) {
            if (!selectedFilter.equals(filter)) continue;
            return filter.getDescription();
        }
        return "";
    }

    private String getExtension(FileFilter selectedFilter) {
        List<FileFilter> filters = this.model.getFilters();
        if (filters == null) {
            return "";
        }
        for (FileFilter filter : filters) {
            if (!selectedFilter.equals(filter) || !(filter instanceof CustomizedFileFilter)) continue;
            return ((CustomizedFileFilter)filter).getExtension();
        }
        return "";
    }

    private void handleTextUpdate() {
        if (this.nameArea == null) {
            return;
        }
        String text = this.nameArea.getText();
        boolean b = text == null || text.trim().length() == 0;
        this.view.setControlsEnabled(!b);
    }

    private Object setSelection() {
        File f = this.getSelectedFile();
        if (f == null) {
            return null;
        }
        String format = this.getExtension(this.getFileFilter());
        String fileName = f.getAbsolutePath();
        File[] l = this.getCurrentDirectory().listFiles();
        String n = this.model.getExtendedName(fileName, format);
        boolean exist = false;
        for (int i = 0; i < l.length; ++i) {
            if (!l[i].getAbsolutePath().equals(n)) continue;
            exist = true;
            break;
        }
        this.setSelectedFile(null);
        return exist;
    }

    CustomizedFileChooser(FileChooser model, FileSaverUI view) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    boolean areControlButtonsShown() {
        return this.nameArea == null;
    }

    void createFolder(String name) {
        File dir = this.getCurrentDirectory();
        String n = dir.getAbsolutePath() + File.separator + name;
        new File(n).mkdir();
    }

    File getFormattedSelectedFile() {
        File f = this.getSelectedFile();
        if (f != null) {
            String format = this.getExtension(this.getFileFilter());
            if (format == null || format.trim().length() == 0) {
                return f;
            }
            String fileName = f.getAbsolutePath();
            return new File(fileName + "." + format);
        }
        return f;
    }

    void requestFocusOnName() {
        if (this.nameArea != null) {
            String text = this.nameArea.getText();
            this.view.setControlsEnabled((text = text.trim()).length() > 0);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    public void removeUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    public void keyReleased(KeyEvent e) {
        String filterString = this.nameArea.getText();
        try {
            if (this.filter == null) {
                this.filter = new RegExFileFilter(filterString, true);
                this.setFileHidingEnabled(true);
                this.setFileFilter(this.filter);
            } else {
                this.filter.setFilter(filterString, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void cancelSelection() {
        this.model.cancelSelection();
        super.cancelSelection();
    }

    public void approveSelection() {
        if (this.model.getChooserType() == 2) {
            File f = this.getSelectedFile();
            if (f != null) {
                this.setSelectedFile(null);
                this.model.setFolderPath(f.getPath());
                this.model.acceptSelection();
            }
        } else if (this.setSelection() != null) {
            this.model.acceptSelection();
        }
        super.approveSelection();
    }

    public File getSelectedFile() {
        if (this.model == null) {
            return super.getSelectedFile();
        }
        if (this.model.getChooserType() == 2) {
            return super.getSelectedFile();
        }
        if (this.nameArea == null) {
            return super.getSelectedFile();
        }
        return new File(this.getCurrentDirectory().toString(), this.nameArea.getText());
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

