/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.texttools;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextHolderFigure;
import org.openmicroscopy.shoola.util.ui.drawingtools.texttools.DrawingFloatingTextField;

public class DrawingTextTool
extends CreationTool
implements ActionListener {
    private DrawingFloatingTextField textField;
    private TextHolderFigure typingTarget;

    private void beginEdit(TextHolderFigure textHolder) {
        if (this.textField == null) {
            this.textField = new DrawingFloatingTextField();
            this.textField.addActionListener(this);
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textField.createOverlay(this.getView(), textHolder);
        this.textField.setBounds(this.getFieldBounds(textHolder), textHolder.getText());
        this.textField.requestFocus();
        this.typingTarget = textHolder;
    }

    private Rectangle getFieldBounds(TextHolderFigure figure) {
        Rectangle textBox = this.getView().drawingToView(figure.getBounds());
        int h = (int)Math.min(24.0, textBox.getHeight());
        int y = (int)textBox.getY() + (int)(textBox.getHeight() / 2.0) - h / 2;
        Rectangle box = new Rectangle((int)textBox.getX(), y, (int)textBox.getWidth(), h);
        Insets insets = this.textField.getInsets();
        return new Rectangle(box.x - insets.left, box.y - insets.top, box.width + insets.left + insets.right, box.height + insets.top + insets.bottom);
    }

    private void endEdit() {
        if (this.typingTarget == null) {
            return;
        }
        if (this.textField.getText().length() > 0) {
            this.typingTarget.setText(this.textField.getText());
            if (this.createdFigure != null) {
                final Figure addedFigure = this.createdFigure;
                final Drawing addedDrawing = this.getDrawing();
                this.getDrawing().fireUndoableEditHappened((UndoableEdit)new AbstractUndoableEdit(){

                    public String getPresentationName() {
                        return super.getPresentationName();
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        addedDrawing.remove(addedFigure);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        addedDrawing.add(addedFigure);
                    }
                });
                this.createdFigure = null;
            }
        } else if (this.createdFigure != null) {
            this.getDrawing().remove(this.getAddedFigure());
        } else {
            this.typingTarget.setText("");
        }
        this.typingTarget = null;
        this.textField.endOverlay();
    }

    public DrawingTextTool(TextHolderFigure prototype) {
        super((Figure)prototype);
    }

    public void mousePressed(MouseEvent e) {
        TextHolderFigure textHolder = null;
        Point2D.Double p = this.getView().viewToDrawing(e.getPoint());
        Figure pressedFigure = this.getDrawing().findFigureInside(p);
        if (pressedFigure instanceof TextHolderFigure && !(textHolder = ((TextHolderFigure)pressedFigure).getLabelFor()).isEditable()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            this.fireToolDone();
        } else {
            super.mousePressed(e);
            textHolder = (TextHolderFigure)this.getCreatedFigure();
            this.beginEdit(textHolder);
        }
    }

    public void deactivate(DrawingEditor editor) {
        this.endEdit();
        super.deactivate(editor);
    }

    public void actionPerformed(ActionEvent event) {
        this.endEdit();
        this.fireToolDone();
    }
}

