/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools;

import java.util.ArrayList;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.FigureSelectionListener;
import org.openmicroscopy.shoola.util.ui.drawingtools.canvas.DrawingCanvasView;

public class DrawingComponent
implements DrawingListener {
    private DefaultDrawing drawing;
    private DrawingEditor drawingEditor = new DefaultDrawingEditor();
    private DrawingCanvasView drawingView;
    private ArrayList<FigureListener> figureListeners;
    private boolean createListeners;

    public DrawingComponent() {
        this.drawing = new DefaultDrawing();
        this.drawingView = new DrawingCanvasView();
        this.drawingView.setDrawing((Drawing)this.drawing);
        this.drawingEditor.add((DrawingView)this.drawingView);
        this.createListeners = false;
    }

    public boolean willCreateFigureListeners() {
        return this.createListeners;
    }

    public void createFigureListeners() {
        this.createListeners = true;
        this.addDrawingListener(this);
    }

    public DefaultDrawing getDrawing() {
        return this.drawing;
    }

    public DrawingEditor getEditor() {
        return this.drawingEditor;
    }

    public DrawingCanvasView getDrawingView() {
        return this.drawingView;
    }

    public void addDrawingListener(DrawingListener listener) {
        if (listener == null) {
            return;
        }
        this.drawing.addDrawingListener(listener);
    }

    public void addFigureSelectionListener(FigureSelectionListener listener) {
        if (listener == null) {
            return;
        }
        this.drawingView.addFigureSelectionListener(listener);
    }

    public void addFigureListener(FigureListener listener) {
        if (listener == null) {
            return;
        }
        this.figureListeners.add(listener);
    }

    public void removeFigure(Figure f) {
        this.drawing.remove(f);
    }

    public void addFigure(Figure f) {
        this.drawing.add(f);
    }

    public boolean contains(Figure f) {
        return this.drawing.contains(f);
    }

    public void figureAdded(DrawingEvent e) {
        if (e == null) {
            return;
        }
        for (int i = 0; i < this.figureListeners.size(); ++i) {
            e.getFigure().addFigureListener(this.figureListeners.get(i));
        }
    }

    public void figureRemoved(DrawingEvent e) {
    }

    public void areaInvalidated(DrawingEvent e) {
    }
}

