/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import layout.TableLayout;

class TreeComponentNode
extends JPanel {
    static final String EXPANDED_NODE_PROPERTY = "expandedNode";
    private JLabel iconLabel;
    private JComponent elapse;
    private JComponent collapse;
    private boolean expanded;
    private TableLayout layout;
    private MouseAdapter adapter;

    void updateDisplay() {
        this.removeAll();
        this.buildGUI();
        this.validate();
        this.repaint();
        this.firePropertyChange(EXPANDED_NODE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    private void buildGUI() {
        this.add((Component)this.iconLabel, "0, 0, l, c");
        if (this.expanded) {
            this.layout.setRow(1, -1.0);
            this.add((Component)this.elapse, "1, 0, 1, 1");
        } else {
            this.layout.setRow(1, -2.0);
            this.add((Component)this.collapse, "1, 0, 1, 1");
        }
    }

    private void initialize() {
        this.iconLabel = new JLabel();
        this.adapter = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                TreeComponentNode.this.expanded = !TreeComponentNode.this.expanded;
                TreeComponentNode.this.updateDisplay();
            }
        };
        this.iconLabel.addMouseListener(this.adapter);
        double[][] tl = new double[][]{{-2.0, -1.0}, {20.0, -1.0}};
        this.layout = new TableLayout((double[][])tl);
        this.setLayout((LayoutManager)this.layout);
    }

    private void setComponentColor(JComponent comp, boolean enabled) {
        Border b = comp.getBorder();
        if (b instanceof TitledBorder) {
            TitledBorder tb = (TitledBorder)b;
            if (enabled) {
                tb.setTitleColor(Color.BLACK);
            } else {
                tb.setTitleColor(Color.GRAY);
            }
        }
    }

    TreeComponentNode(JComponent elapse, JComponent collapse) {
        this(elapse, collapse, true);
    }

    TreeComponentNode(JComponent elapse, JComponent collapse, boolean expanded) {
        if (collapse == null || elapse == null) {
            throw new IllegalArgumentException("No components to lay out.");
        }
        this.collapse = collapse;
        this.elapse = elapse;
        this.expanded = expanded;
        this.initialize();
        this.buildGUI();
    }

    void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    void setIcons(Icon collapseIcon, Icon elapseIcon) {
        if (this.expanded) {
            this.iconLabel.setIcon(elapseIcon);
        } else {
            this.iconLabel.setIcon(collapseIcon);
        }
    }

    boolean isExpanded() {
        return this.expanded;
    }

    void setNodeEnabled(boolean enabled) {
        this.iconLabel.setEnabled(enabled);
        this.iconLabel.removeMouseListener(this.adapter);
        if (enabled) {
            this.iconLabel.addMouseListener(this.adapter);
        }
        this.setComponentColor(this.collapse, enabled);
        this.setComponentColor(this.elapse, enabled);
    }
}

