/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.RatingComponent;

class RatingCanvas
extends JPanel
implements MouseMotionListener {
    static final int SPACE = 2;
    private RatingComponent model;
    private List<Rectangle> stars;
    private MouseAdapter handler;

    private void handleClick(Point p) {
        Rectangle r;
        boolean found = false;
        for (int i = 0; i < this.stars.size(); ++i) {
            r = this.stars.get(i);
            if (!r.contains(p)) continue;
            found = true;
            this.model.setValue(i + 1);
            break;
        }
        if (found) {
            return;
        }
        r = this.stars.get(0);
        if (p.x < r.x) {
            this.model.setValue(0);
            return;
        }
        r = this.stars.get(this.stars.size() - 1);
        if (p.x > r.x + r.width) {
            this.model.setValue(5);
        }
    }

    RatingCanvas(RatingComponent model) {
        if (model == null) {
            throw new IllegalArgumentException("No model");
        }
        this.model = model;
        this.setDoubleBuffered(true);
        this.stars = new ArrayList<Rectangle>();
        this.handler = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                RatingCanvas.this.handleClick(e.getPoint());
            }
        };
        this.installListeners();
    }

    void installListeners() {
        this.addMouseListener(this.handler);
        this.addMouseMotionListener(this);
    }

    void uninstallListeners() {
        this.removeMouseListener(this.handler);
        this.removeMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        int h;
        int w;
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g.setColor(this.getBackground());
        int x = 0;
        List<Image> l = this.model.getPlus();
        Iterator<Image> i = l.iterator();
        this.stars.clear();
        while (i.hasNext()) {
            Image img = i.next();
            w = img.getWidth(null);
            h = img.getHeight(null);
            this.stars.add(new Rectangle(x, 0, w, h));
            g2D.drawImage(img, x, 0, w, h, null);
            x += w + 2;
        }
        l = this.model.getMinus();
        for (Image img : l) {
            w = img.getWidth(null);
            h = img.getHeight(null);
            this.stars.add(new Rectangle(x, 0, w, h));
            g2D.drawImage(img, x, 0, w, h, null);
            x += w + 2;
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.handleClick(e.getPoint());
    }

    public void mouseMoved(MouseEvent e) {
    }
}

