/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.OutlookBarComponent;

public class OutlookBar
extends JPanel
implements ActionListener {
    private JPanel topPanel;
    private JPanel bottomPanel;
    private Map<Integer, OutlookBarComponent> bars;
    private int visibleBar;
    private JComponent visibleComponent;

    private void initComponents() {
        this.bars = new LinkedHashMap<Integer, OutlookBarComponent>();
        this.topPanel = new JPanel(new GridLayout(1, 1));
        this.bottomPanel = new JPanel(new GridLayout(1, 1));
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.bottomPanel, "South");
    }

    protected void rebuild() {
        int totalBars = this.bars.size();
        int topBars = this.visibleBar + 1;
        int bottomBars = totalBars - topBars;
        Iterator<Integer> i = this.bars.keySet().iterator();
        this.topPanel.removeAll();
        GridLayout topLayout = (GridLayout)this.topPanel.getLayout();
        topLayout.setRows(topBars);
        OutlookBarComponent bar = null;
        for (int j = 0; j < topBars; ++j) {
            bar = this.bars.get(i.next());
            this.topPanel.add(bar.getButton());
        }
        this.topPanel.validate();
        if (this.visibleComponent != null) {
            this.remove(this.visibleComponent);
        }
        this.visibleComponent = bar.getComponent();
        this.add((Component)this.visibleComponent, "Center");
        this.bottomPanel.removeAll();
        GridLayout bottomLayout = (GridLayout)this.bottomPanel.getLayout();
        bottomLayout.setRows(bottomBars);
        for (int j = 0; j < bottomBars; ++j) {
            bar = this.bars.get(i.next());
            this.bottomPanel.add(bar.getButton());
        }
        this.bottomPanel.validate();
        this.validate();
    }

    public OutlookBar() {
        this.initComponents();
        this.buildGUI();
    }

    public void addBar(String name, JComponent component) {
        if (component == null) {
            throw new NullPointerException("No component specified.");
        }
        this.addBar(name, component, null);
    }

    public void addBar(String name, JComponent component, Icon icon) {
        int i = this.bars.size();
        OutlookBarComponent bar = new OutlookBarComponent(name, component, icon, i);
        bar.getButton().addActionListener(this);
        bar.setCurrent(i == 0);
        this.bars.put(i, bar);
        this.rebuild();
    }

    public void removeBar(int index) {
        OutlookBarComponent bar = this.bars.get(index);
        if (bar == null) {
            return;
        }
        this.bars.remove(index);
        if (bar.getIndex() == this.visibleBar) {
            this.visibleBar = 0;
        }
        this.rebuild();
    }

    public void setVisibleBar(int index) {
        this.visibleBar = index >= 0 && index < this.bars.size() ? index : 0;
        this.rebuild();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        int currentBar = 0;
        Iterator<Integer> i = this.bars.keySet().iterator();
        while (i.hasNext()) {
            OutlookBarComponent bar = this.bars.get(i.next());
            if (src == bar.getButton()) {
                this.visibleBar = currentBar;
                this.rebuild();
                break;
            }
            ++currentBar;
        }
    }
}

