/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class OptionsDialog
extends JDialog {
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private JXHeader contentPanel;
    private JButton noButton;
    private JButton yesButton;
    private JButton cancelButton;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private JPanel body;

    private void yesSelection() {
        this.onYesSelection();
        this.close();
    }

    private void noSelection() {
        this.onNoSelection();
        this.close();
    }

    private void cancel() {
        this.onCancel();
        this.close();
    }

    private void createComponents() {
        this.body = new JPanel();
        this.body.setBackground(UIUtilities.WINDOW_BACKGROUND_COLOR);
        this.mainPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.contentPanel = new JXHeader();
        this.noButton = new JButton("No");
        this.yesButton = new JButton("Yes");
        this.getRootPane().setDefaultButton(this.yesButton);
    }

    private void attachListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                OptionsDialog.this.close();
            }
        });
        this.noButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.noSelection();
            }
        });
        this.yesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.yesSelection();
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel buildCommentPanel(String instructions, Icon icon) {
        this.contentPanel.setBackgroundPainter((Painter)new RectanglePainter(UIUtilities.WINDOW_BACKGROUND_COLOR, null));
        this.contentPanel.setDescription(instructions);
        this.contentPanel.setIcon(icon);
        this.contentPanel.setIconPosition(JXHeader.IconPosition.LEFT);
        return this.contentPanel;
    }

    private JPanel buildControlPanel() {
        this.controlPanel.setBackground(UIUtilities.WINDOW_BACKGROUND_COLOR);
        this.controlPanel.setBorder(null);
        this.controlPanel.add(this.yesButton);
        this.controlPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.controlPanel.add(this.noButton);
        this.controlPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 1));
        bar.setBackground(UIUtilities.WINDOW_BACKGROUND_COLOR);
        bar.add(this.controlPanel);
        bar.add(Box.createVerticalStrut(10));
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setBackground(UIUtilities.WINDOW_BACKGROUND_COLOR);
        return p;
    }

    private void buildGUI(String message, Icon icon) {
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mainPanel.add(this.buildCommentPanel(message, icon));
        this.mainPanel.add(this.body);
        this.mainPanel.add(this.buildControlPanel());
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    private void initialize(String message, Icon messageIcon) {
        this.createComponents();
        this.attachListeners();
        this.buildGUI(message, messageIcon);
        this.pack();
    }

    public OptionsDialog(JFrame owner, String title, String message, Icon messageIcon) {
        super(owner, title, true);
        this.initialize(message, messageIcon);
    }

    public OptionsDialog(JDialog owner, String title, String message, Icon messageIcon) {
        super(owner, title, true);
        this.initialize(message, messageIcon);
    }

    public void addBodyComponent(JComponent c) {
        c.setBackground(UIUtilities.WINDOW_BACKGROUND_COLOR);
        this.body.add(c);
        this.body.validate();
        this.body.repaint();
        this.pack();
    }

    public void setYesText(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return;
        }
        this.yesButton.setText(txt);
    }

    public void setNoText(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return;
        }
        this.noButton.setText(txt);
    }

    public void hideNoButton() {
        this.controlPanel.remove(this.noButton);
        this.controlPanel.revalidate();
        this.repaint();
    }

    public void addCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.cancel();
                }
            });
        }
        this.controlPanel.add(this.cancelButton);
        this.repaint();
    }

    protected void onYesSelection() {
    }

    protected void onNoSelection() {
    }

    protected void onCancel() {
    }
}

