/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.AnimatedJFrame;

class AnimatedPane
extends JPanel {
    private Dimension animatedSize;
    private JComponent source;
    private BufferedImage image;
    private GraphicsConfiguration config;
    private AnimatedJFrame parent;

    private void makeOffscreenImage(JComponent src) {
        if (this.source == null) {
            return;
        }
        this.image = this.config.createCompatibleImage(src.getWidth(), src.getHeight());
        Graphics2D g2D = (Graphics2D)this.image.getGraphics();
        src.paint(g2D);
    }

    AnimatedPane(AnimatedJFrame parent) {
        this.parent = parent;
        this.animatedSize = new Dimension(1, 1);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.config = env.getDefaultScreenDevice().getDefaultConfiguration();
        this.setOpaque(false);
    }

    void setSource(JComponent source) {
        this.source = source;
        if (source == null) {
            return;
        }
        this.animatedSize.width = source.getWidth();
        if (this.parent.getOrientation() == 0) {
            this.animatedSize.height = source.getHeight();
        }
        this.makeOffscreenImage(source);
    }

    void setAnimatingHeight(int height) {
        this.animatedSize.height = height;
        if (this.parent.getOrientation() != 0) {
            this.setSize(this.animatedSize);
        }
    }

    public Dimension getPreferredSize() {
        return this.animatedSize;
    }

    public Dimension getMinimumSize() {
        return this.animatedSize;
    }

    public Dimension getMaximumSize() {
        return this.animatedSize;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        try {
            if (this.parent.getOrientation() == 0) {
                BufferedImage img = this.image.getSubimage(0, 0, this.source.getWidth(), this.animatedSize.height);
                g.drawImage(img, 0, this.source.getHeight() - this.animatedSize.height, this);
            } else {
                BufferedImage img = this.image.getSubimage(0, this.image.getHeight() - this.animatedSize.height, this.source.getWidth(), this.animatedSize.height);
                g.drawImage(img, 0, 0, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

