/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.PointTextFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurePointFigure
extends PointTextFigure
implements ROIFigure {
    private Rectangle2D bounds;
    protected ROI roi;
    protected ROIShape shape;
    private MeasurementUnits units;
    private int status;

    public MeasurePointFigure(String text, double x, double y, double width, double height) {
        super(text, x, y, width, height);
        this.setAttributeEnabled(MeasurementAttributes.TEXT_COLOR, true);
        this.shape = null;
        this.roi = null;
        this.status = 0;
    }

    public MeasurePointFigure(double x, double y, double width, double height) {
        this("Text", x, y, width, height);
    }

    public MeasurePointFigure() {
        this("Text", 0.0, 0.0, 0.0, 0.0);
    }

    public double getMeasurementX() {
        if (this.units.isInMicrons()) {
            return this.getX() * this.units.getMicronsPixelX();
        }
        return this.getX();
    }

    public Point2D getMeasurementCentre() {
        if (this.units.isInMicrons()) {
            return new Point2D.Double(this.getCentre().getX() * this.units.getMicronsPixelX(), this.getCentre().getY() * this.units.getMicronsPixelY());
        }
        return this.getCentre();
    }

    public double getMeasurementY() {
        if (this.units.isInMicrons()) {
            return this.getY() * this.units.getMicronsPixelY();
        }
        return this.getY();
    }

    public double getMeasurementWidth() {
        if (this.units.isInMicrons()) {
            return this.getWidth() * this.units.getMicronsPixelX();
        }
        return this.getWidth();
    }

    public double getMeasurementHeight() {
        if (this.units.isInMicrons()) {
            return this.getHeight() * this.units.getMicronsPixelY();
        }
        return this.getHeight();
    }

    public double getX() {
        return this.ellipse.getX();
    }

    public double getY() {
        return this.ellipse.getY();
    }

    public double getWidth() {
        return this.ellipse.getWidth();
    }

    public double getHeight() {
        return this.ellipse.getHeight();
    }

    public void draw(Graphics2D g) {
        super.draw(g);
        if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue() || ((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
            DecimalFormat formatter = new DecimalFormat("###.#");
            String pointCentre = "(" + formatter.format(this.getMeasurementCentre().getX()) + "," + formatter.format(this.getMeasurementCentre().getY()) + ")";
            double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
            g.setFont(new Font("Arial", 0, (int)sz));
            this.bounds = g.getFontMetrics().getStringBounds(pointCentre, g);
            this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
            if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
                g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(pointCentre, (int)this.bounds.getX(), (int)this.bounds.getY());
            }
            if (((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
                Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.getROI().getID() + "", g);
                bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - bounds.getWidth() / 2.0, this.getBounds().getCenterY() + bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight());
                g.setColor(this.getTextColor());
                g.drawString(this.getROI().getID() + "", (int)bounds.getX(), (int)bounds.getY());
            }
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.bounds != null) {
            double diff;
            if (newBounds.getX() > this.bounds.getX()) {
                diff = newBounds.x - this.bounds.getX();
                newBounds.x = this.bounds.getX();
                newBounds.width += diff;
            }
            if (newBounds.getY() > this.bounds.getY()) {
                diff = newBounds.y - this.bounds.getY();
                newBounds.y = this.bounds.getY();
                newBounds.height += diff;
            }
            if (this.bounds.getX() + this.bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                diff = this.bounds.getX() + this.bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                newBounds.width += diff;
            }
            if (this.bounds.getY() + this.bounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
                diff = this.bounds.getY() + this.bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public String addUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m" + "\u00b2";
        }
        return str + "px" + "\u00b2";
    }

    public Point2D getCentre() {
        return new Point2D.Double(Math.round(this.ellipse.getCenterX()), Math.round(this.ellipse.getCenterY()));
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        AnnotationKeys.CENTREX.set(this.shape, (Double)this.getMeasurementCentre().getX());
        AnnotationKeys.CENTREY.set(this.shape, (Double)this.getMeasurementCentre().getY());
    }

    @Override
    public String getType() {
        return "Point";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        ArrayList<Point> points = new ArrayList<Point>(1);
        points.add(new Point((int)this.getX(), (int)this.getY()));
        return points;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }
}

