/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.math.geom2D;

import java.awt.Rectangle;
import java.util.ArrayList;
import org.openmicroscopy.shoola.util.math.geom2D.PlaneArea;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint;

class RectangleAreaAdapter
extends Rectangle
implements PlaneArea {
    RectangleAreaAdapter() {
    }

    RectangleAreaAdapter(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void scale(double factor) {
        Rectangle r = this.getBounds();
        this.setBounds((int)((double)r.x * factor), (int)((double)r.y * factor), (int)((double)r.width * factor), (int)((double)r.height * factor));
    }

    public PlanePoint[] getPoints() {
        Rectangle r = this.getBounds();
        ArrayList<PlanePoint> vector = new ArrayList<PlanePoint>(r.height * r.width);
        int xEnd = r.x + r.width;
        int yEnd = r.y + r.height;
        for (int y = r.y; y < yEnd; ++y) {
            for (int x = r.x; x < xEnd; ++x) {
                if (!this.contains(x, y)) continue;
                vector.add(new PlanePoint(x, y));
            }
        }
        return vector.toArray(new PlanePoint[vector.size()]);
    }

    public boolean onBoundaries(double x, double y) {
        double xCorner = this.getX();
        double yCorner = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        return x == xCorner && y >= yCorner && y <= yCorner + h || x == xCorner + w && y >= yCorner && y <= yCorner + h || y == yCorner && x >= xCorner && x <= xCorner + w || y == yCorner + h && x >= xCorner && x <= xCorner + w;
    }

    public Object copy() {
        return super.clone();
    }
}

