/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tdialog;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.openmicroscopy.shoola.util.ui.tdialog.BorderListener;
import org.openmicroscopy.shoola.util.ui.tdialog.DialogControl;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialogUI;

public class TinyDialog
extends JDialog {
    public static final String COLLAPSED_PROPERTY = "collapsed";
    public static final String CLOSED_PROPERTY = "closedDialog";
    public static final String TITLE_PROPERTY = "title";
    public static final int BOTH = 0;
    public static final int CLOSE_ONLY = 1;
    public static final int SIZE_ONLY = 2;
    static final int MINIMUM_ZOOM = 1;
    static final int MAXIMUM_ZOOM = 2;
    private Dimension restoreSize;
    protected TinyDialogUI uiDelegate;
    protected DialogControl controller;
    private boolean collapsed;
    private boolean closed;
    private BufferedImage originalImage;
    private float zoomFactor;
    private int buttonIndex;
    protected String title;

    private void setProperties() {
        this.setModal(false);
        this.setResizable(false);
        this.setUndecorated(true);
        this.setRestoreSize(new Dimension(this.getWidth(), this.getHeight()));
        this.zoomFactor = 1.0f;
    }

    BufferedImage getOriginalImage() {
        return this.originalImage;
    }

    float getZoomFactor() {
        return this.zoomFactor;
    }

    void setZoomFactor(float v) {
        this.zoomFactor = v;
    }

    void setRestoreSize(Dimension d) {
        this.restoreSize = d;
    }

    Dimension getRestoreSize() {
        return this.restoreSize;
    }

    int getButtonIndex() {
        return this.buttonIndex;
    }

    public TinyDialog(Frame owner, BufferedImage image) {
        this(owner, image, null);
    }

    public TinyDialog(Frame owner, BufferedImage image, String title) {
        super(owner);
        this.setProperties();
        if (owner == null) {
            throw new NullPointerException("No owner.");
        }
        if (image == null) {
            throw new NullPointerException("No image.");
        }
        this.title = title;
        this.originalImage = image;
        this.zoomFactor = 1.0f;
        this.buttonIndex = 0;
        this.uiDelegate = new TinyDialogUI(this, image);
        this.controller = new DialogControl(this, this.uiDelegate);
        this.uiDelegate.attachMouseWheelListener(this.controller);
    }

    public TinyDialog(Frame owner, JComponent c) {
        this(owner, c, null);
    }

    public TinyDialog(Frame owner, JComponent c, int index) {
        this(owner, c, index, null);
    }

    public TinyDialog(Frame owner, JComponent c, int index, String title) {
        super(owner);
        if (owner == null) {
            throw new NullPointerException("No owner.");
        }
        this.title = title;
        this.buttonIndex = index;
        this.uiDelegate = c == null ? new TinyDialogUI(this) : new TinyDialogUI(this, c);
        this.controller = new DialogControl(this, this.uiDelegate);
        this.setProperties();
    }

    public TinyDialog(Frame owner, JComponent c, String title) {
        this(owner, c, 0, title);
    }

    public TinyDialog(Frame owner, String title, int index) {
        super(owner);
        this.title = title;
        this.buttonIndex = index;
        if (owner == null) {
            throw new NullPointerException("No owner.");
        }
        this.uiDelegate = new TinyDialogUI(this);
        this.controller = new DialogControl(this, this.uiDelegate);
        this.setProperties();
    }

    public void moveToFront() {
        this.setVisible(true);
    }

    public void moveToFront(int x, int y) {
        this.setLocation(x, y);
        this.setVisible(true);
    }

    public void moveToFront(Point p) {
        this.moveToFront(p.x, p.y);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange(TITLE_PROPERTY, oldValue, title);
    }

    public void setCollapsed(boolean b) {
        if (b == this.collapsed) {
            return;
        }
        if (!this.collapsed) {
            this.setRestoreSize(new Dimension(this.getWidth(), this.getHeight()));
        }
        Boolean oldValue = this.collapsed ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.collapsed = b;
        this.firePropertyChange(COLLAPSED_PROPERTY, oldValue, newValue);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setClosed(boolean b) {
        if (b == this.closed) {
            return;
        }
        Boolean oldValue = this.closed ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.closed = b;
        this.firePropertyChange(CLOSED_PROPERTY, oldValue, newValue);
    }

    public void setDecoration(List l) {
        if (this.uiDelegate == null) {
            return;
        }
        this.uiDelegate.setDecoration(l);
    }

    public void setCanvas(JComponent c) {
        if (this.uiDelegate == null || c == null) {
            return;
        }
        this.uiDelegate.setCanvas(c);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void closeWindow() {
        this.uiDelegate.updateClosedState();
    }

    public void setResizable(boolean b) {
        super.setResizable(b);
        if (b) {
            this.getRootPane().addMouseMotionListener(new BorderListener(this));
        }
    }

    public void setUndecorated(boolean b) {
        super.setUndecorated(true);
    }
}

