/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSliderModel;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSliderUI;

public class TwoKnobsSlider
extends JPanel {
    public static final int DEFAULT_MIN = 0;
    public static final int DEFAULT_MAX = 100;
    public static final String KNOB_RELEASED_PROPERTY = "knobReleased";
    public static final String LEFT_MOVED_PROPERTY = "leftMoved";
    public static final String RIGHT_MOVED_PROPERTY = "rightMoved";
    public static final String START_VALUE_PROPERTY = "startValue";
    public static final String END_VALUE_PROPERTY = "endValue";
    public static final String MAX_VALUE_PROPERTY = "maxValue";
    public static final String MIN_VALUE_PROPERTY = "minValue";
    public static final String SET_VALUES_PROPERTY = "setValues";
    public static final int HORIZONTAL = 100;
    public static final int VERTICAL = 101;
    public static final int INITIAL = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    protected static final Dimension MIN_HORIZONTAL = new Dimension(36, 21);
    protected static final Dimension MIN_VERTICAL = new Dimension(21, 36);
    protected static final Dimension PREFERRED_VERTICAL = new Dimension(21, 200);
    protected static final Dimension PREFERRED_HORIZONTAL = new Dimension(200, 21);
    protected Insets insetCache = null;
    private int knobWidth;
    private int knobHeight;
    private TwoKnobsSliderModel model;
    private TwoKnobsSliderUI uiDelegate;
    private int knobControl;
    private Dimension preferredSize_;
    private int fontHeight;

    private void calculatePreferredSize() {
        int h = this.knobHeight;
        if (this.model.isPaintTicks()) {
            h += this.knobHeight;
        }
        if (this.model.isPaintLabels() || this.model.isPaintEndLabels()) {
            h += 3 + this.fontHeight + 2;
        }
        this.preferredSize_ = this.model.getOrientation() == 101 ? PREFERRED_VERTICAL : new Dimension(TwoKnobsSlider.PREFERRED_HORIZONTAL.width, h);
    }

    private void setDefault() {
        this.insetCache = this.getInsets();
        this.fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        this.knobControl = 0;
        this.knobWidth = this.uiDelegate.getKnobWidth();
        this.knobHeight = this.uiDelegate.getKnobHeight();
        this.calculatePreferredSize();
    }

    private void attachListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                TwoKnobsSlider.this.handleMouseEvent(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                TwoKnobsSlider.this.release();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                TwoKnobsSlider.this.handleMouseEvent(evt);
            }
        });
    }

    private void release() {
        if (!this.model.isEnabled()) {
            return;
        }
        this.firePropertyChange(KNOB_RELEASED_PROPERTY, new Integer(0), new Integer(this.knobControl));
        this.knobControl = 0;
    }

    private void handleMouseEvent(MouseEvent me) {
        if (!this.model.isEnabled()) {
            return;
        }
        int oldStart = this.getStartValue();
        int oldEnd = this.getEndValue();
        if (this.model.getOrientation() == 100) {
            this.handleMouseEventForHorizSlider((int)me.getPoint().getX());
            switch (this.knobControl) {
                case 1: {
                    if (oldStart == this.getStartValue()) break;
                    this.firePropertyChange(LEFT_MOVED_PROPERTY, oldStart, this.getStartValue());
                    break;
                }
                case 2: {
                    if (oldEnd == this.getEndValue()) break;
                    this.firePropertyChange(RIGHT_MOVED_PROPERTY, oldEnd, this.getEndValue());
                }
            }
        } else {
            this.handleMouseEventForVertSlider((int)me.getPoint().getY());
            switch (this.knobControl) {
                case 1: {
                    if (oldEnd == this.getEndValue()) break;
                    this.firePropertyChange(LEFT_MOVED_PROPERTY, oldEnd, this.getEndValue());
                    break;
                }
                case 2: {
                    if (oldStart == this.getStartValue()) break;
                    this.firePropertyChange(RIGHT_MOVED_PROPERTY, oldStart, this.getStartValue());
                }
            }
        }
    }

    private void handleMouseEventForHorizSlider(int x) {
        int leftKnob = this.uiDelegate.xPositionForValue(this.model.getStartValue());
        int rightKnob = this.uiDelegate.xPositionForValue(this.model.getEndValue());
        int left = leftKnob;
        int right = rightKnob;
        int xmin = this.uiDelegate.xPositionForValue(this.model.getPartialMinimum());
        int xmax = this.uiDelegate.xPositionForValue(this.model.getPartialMaximum());
        int limit = leftKnob + (rightKnob - leftKnob) / 2;
        if (x < limit && this.knobControl != 2) {
            this.knobControl = 1;
            left = x;
        } else if (x > limit && this.knobControl != 1) {
            this.knobControl = 2;
            right = x;
        }
        if (this.knobControl == 1) {
            if (left < xmin) {
                left = xmin;
            } else if (left > xmax - this.knobWidth) {
                left = xmax - this.knobWidth;
            } else if (left > right && right < xmax) {
                left = right - 1;
            }
            this.model.setStartValue(this.uiDelegate.xValueForPosition(left));
        } else if (this.knobControl == 2) {
            if (right > xmax) {
                right = xmax;
            } else if (right < xmin + this.knobWidth) {
                right = xmin + this.knobWidth;
            } else if (right < left && left > xmin) {
                right = left + 1;
            }
            this.model.setEndValue(this.uiDelegate.xValueForPosition(right));
        }
        this.repaint();
    }

    private void handleMouseEventForVertSlider(int y) {
        int upKnob = this.uiDelegate.yPositionForValue(this.model.getEndValue());
        int downKnob = this.uiDelegate.yPositionForValue(this.model.getStartValue());
        int up = upKnob;
        int down = downKnob;
        int ymin = this.uiDelegate.yPositionForValue(this.model.getPartialMaximum());
        int ymax = this.uiDelegate.yPositionForValue(this.model.getPartialMinimum());
        int limit = upKnob + (downKnob - upKnob) / 2;
        if (y < limit && this.knobControl != 2) {
            this.knobControl = 1;
            up = y;
        } else if (y > limit && this.knobControl != 1) {
            this.knobControl = 2;
            down = y;
        }
        if (this.knobControl == 1) {
            if (up < ymin) {
                up = ymin;
            } else if (up > ymax - this.knobHeight) {
                up = ymax - this.knobHeight;
            } else if (up > down && down < ymax) {
                up = down - 1;
            }
            this.model.setEndValue(this.uiDelegate.yValueForPosition(up));
        } else if (this.knobControl == 2) {
            if (down > ymax) {
                down = ymax;
            } else if (down < ymin + this.knobHeight) {
                down = ymin + this.knobHeight;
            } else if (down < up && up > ymin) {
                down = up + 1;
            }
            this.model.setStartValue(this.uiDelegate.yValueForPosition(down));
        }
        this.repaint();
    }

    protected Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL;
    }

    protected Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL;
    }

    protected Dimension getMinimumHorizontalSize() {
        return MIN_HORIZONTAL;
    }

    protected Dimension getMinimumVerticalSize() {
        return MIN_VERTICAL;
    }

    int getKnobControl() {
        return this.knobControl;
    }

    public TwoKnobsSlider() {
        this(0, 100, 0, 100);
    }

    public TwoKnobsSlider(int min, int max, int start, int end) {
        this(min, max, min, max, start, end);
    }

    public TwoKnobsSlider(int absoluteMin, int absoluteMax, int min, int max, int start, int end) {
        this.model = new TwoKnobsSliderModel(absoluteMax, absoluteMin, max, min, start, end);
        this.uiDelegate = new TwoKnobsSliderUI(this, this.model);
        this.attachListeners();
        this.setDefault();
    }

    public int getKnobHeight() {
        return this.knobHeight;
    }

    public int getKnobWidth() {
        return this.knobWidth;
    }

    public void setFontColor(Color c) {
        if (c == null) {
            return;
        }
        this.uiDelegate.setFontColor(c);
    }

    public int getStartValue() {
        return this.model.getStartValue();
    }

    public int getEndValue() {
        return this.model.getEndValue();
    }

    public void setStartValue(int v) {
        int old = this.model.getStartValue();
        this.model.setStartValue(v);
        this.firePropertyChange(START_VALUE_PROPERTY, new Integer(old), new Integer(v));
        this.repaint();
    }

    public void setEndValue(int v) {
        int max = this.model.getAbsoluteMaximum();
        if (v > max) {
            return;
        }
        if (v <= this.getStartValue()) {
            return;
        }
        int old = this.model.getEndValue();
        this.model.setEndValue(v);
        this.firePropertyChange(END_VALUE_PROPERTY, new Integer(old), new Integer(v));
        this.repaint();
    }

    public void setValues(int absoluteMax, int absoluteMin, int max, int min, int start, int end) {
        this.model.checkValues(absoluteMax, absoluteMin, max, min, start, end);
        this.firePropertyChange(SET_VALUES_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        this.repaint();
    }

    public void setInterval(int start, int end) {
        if (start > end) {
            return;
        }
        int max = this.model.getAbsoluteMaximum();
        if (end > max) {
            return;
        }
        int oldEnd = this.model.getEndValue();
        int oldStart = this.model.getStartValue();
        this.model.setInterval(start, end);
        this.firePropertyChange(START_VALUE_PROPERTY, new Integer(oldStart), new Integer(start));
        this.firePropertyChange(END_VALUE_PROPERTY, new Integer(oldEnd), new Integer(end));
        this.repaint();
    }

    public void setPaintLabels(boolean paintLabel) {
        if (this.model.isPaintLabels() == paintLabel) {
            return;
        }
        this.model.setPaintLabels(paintLabel);
        this.calculatePreferredSize();
        this.repaint();
    }

    public void setPaintEndLabels(boolean paintLabel) {
        if (this.model.isPaintEndLabels() == paintLabel) {
            return;
        }
        this.model.setPaintEndLabels(paintLabel);
        this.calculatePreferredSize();
        this.repaint();
    }

    public void setPaintTicks(boolean paintTicks) {
        if (this.model.isPaintTicks() == paintTicks) {
            return;
        }
        this.model.setPaintTicks(paintTicks);
        this.calculatePreferredSize();
        this.repaint();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.model.setEnabled(b);
    }

    public int getOrientation() {
        return this.model.getOrientation();
    }

    public void setOrientation(int v) {
        if (v != 100 && v != 101) {
            throw new IllegalArgumentException("Orientation not supported.");
        }
        this.model.setOrientation(v);
    }

    public void setPaintMinorTicks(boolean b) {
        if (b) {
            int m = this.model.getMinorTickSpacing();
            if (m == 0) {
                m = 1;
            }
            this.model.setMinorTickSpacing(m);
        }
        this.model.setMinorTickSpacing(0);
        this.repaint();
    }

    public void setMinorTickSpacing(int s) {
        this.model.setMinorTickSpacing(s);
    }

    public int getPartialMinimum() {
        return this.model.getPartialMinimum();
    }

    public int getPartialMaximum() {
        return this.model.getPartialMaximum();
    }

    public Dimension getPreferredSize() {
        if (this.getOrientation() == 101) {
            return this.getPreferredVerticalSize();
        }
        int width = this.getPreferredHorizontalSize().width;
        int height = this.insetCache.top + this.insetCache.bottom;
        return new Dimension(width, height += this.preferredSize_.height);
    }

    public Dimension getMinimumSize() {
        return this.preferredSize_;
    }

    public void update(Graphics g) {
        this.paintComponent(g);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.calculatePreferredSize();
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.uiDelegate.paintComponent((Graphics2D)g, this.getSize());
    }

    static /* synthetic */ void access$000(TwoKnobsSlider x0, MouseEvent x1) {
        x0.handleMouseEvent(x1);
    }

    static /* synthetic */ void access$100(TwoKnobsSlider x0) {
        x0.release();
    }
}

