/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import layout.TableLayout;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;

public class TextualTwoKnobsSlider
extends JPanel
implements ActionListener,
DocumentListener,
FocusListener,
PropertyChangeListener {
    public static final int LAYOUT_ALL = 0;
    public static final int LAYOUT_FIELDS = 1;
    private static final int START = 0;
    private static final int END = 1;
    private static final String NAME_DOC = "name";
    private TwoKnobsSlider slider;
    private NumericalTextField startField;
    private NumericalTextField endField;
    private JLabel startLabel;
    private JLabel endLabel;
    private JLabel sliderLabel;
    private int start;
    private int end;

    private void attachListeners() {
        this.slider.addPropertyChangeListener(this);
        this.installFieldListener(this.startField, 0);
        this.installFieldListener(this.endField, 1);
    }

    private void installFieldListener(JTextField field, int id) {
        field.setActionCommand("" + id);
        field.addActionListener(this);
        field.addFocusListener(this);
        Document doc = field.getDocument();
        doc.addDocumentListener(this);
        doc.putProperty(NAME_DOC, "" + id);
    }

    private void uninstallFieldListener(JTextField field) {
        field.removeActionListener(this);
        field.removeFocusListener(this);
        field.getDocument().removeDocumentListener(this);
    }

    private void initComponents(int min, int max, int start, int end) {
        this.sliderLabel = new JLabel();
        this.startLabel = new JLabel("Start");
        this.endLabel = new JLabel("End");
        this.slider = new TwoKnobsSlider(min, max, start, end);
        this.setSliderPaintingDefault(false);
        int length = ("" + max).length();
        this.startField = new NumericalTextField(start, (double)end);
        this.startField.setColumns(length);
        this.endField = new NumericalTextField(start, (double)end);
        this.endField.setColumns(length);
        this.startField.setText("" + start);
        this.endField.setText("" + end);
        this.start = start;
        this.end = end;
    }

    private void setStartValue() {
        boolean valid = false;
        int val = 0;
        try {
            val = Integer.parseInt(this.startField.getText());
            if (this.slider.getPartialMinimum() <= val && val < this.end) {
                valid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!valid) {
            this.startField.selectAll();
            return;
        }
        this.start = val;
        this.endField.setMinimum(this.start);
        this.slider.setStartValue(this.start);
    }

    private void setEndValue() {
        boolean valid = false;
        int val = 0;
        try {
            val = Integer.parseInt(this.endField.getText());
            if (this.start < val && val <= this.slider.getPartialMaximum()) {
                valid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!valid) {
            this.endField.selectAll();
            return;
        }
        this.end = val;
        this.startField.setMaximum(this.end);
        this.slider.setEndValue(this.end);
    }

    private void synchStartValue(int value) {
        this.start = value;
        this.uninstallFieldListener(this.startField);
        this.startField.setText("" + this.start);
        this.endField.setMinimum(this.start);
        this.installFieldListener(this.startField, 0);
    }

    private void synchEndValue(int value) {
        this.end = value;
        this.uninstallFieldListener(this.endField);
        this.endField.setText("" + this.end);
        this.startField.setMaximum(this.end);
        this.installFieldListener(this.endField, 1);
    }

    private void updateTextValue(Document doc) {
        String value = (String)doc.getProperty(NAME_DOC);
        int index = Integer.parseInt(value);
        switch (index) {
            case 0: {
                this.setStartValue();
                break;
            }
            case 1: {
                this.setEndValue();
            }
        }
    }

    private void handleFocusLost() {
        String s = "" + this.start;
        String e = "" + this.end;
        String startVal = this.startField.getText();
        String endVal = this.endField.getText();
        if (startVal == null || !startVal.equals(s)) {
            this.startField.setText(s);
        }
        if (endVal == null || !endVal.equals(e)) {
            this.endField.setText(e);
        }
    }

    private JPanel buildFieldsPane() {
        JPanel p = new JPanel();
        int charWidth = this.getFontMetrics(this.getFont()).charWidth('m');
        Insets insets = this.endField.getInsets();
        int length = this.endField.getColumns();
        int x = insets.left + length * charWidth + insets.left;
        Dimension d = this.startField.getPreferredSize();
        this.startField.setPreferredSize(new Dimension(x, d.height));
        d = this.endField.getPreferredSize();
        this.endField.setPreferredSize(new Dimension(x, d.height));
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.weightx = 0.0;
        c.anchor = 17;
        p.add((Component)this.startLabel, c);
        c.gridx = 1;
        c.ipadx = x;
        c.weightx = 0.5;
        p.add((Component)UIUtilities.buildComponentPanel(this.startField), c);
        c.gridx = 2;
        c.ipadx = 0;
        c.weightx = 0.0;
        p.add((Component)this.endLabel, c);
        c.gridx = 3;
        c.ipadx = x;
        c.weightx = 0.5;
        p.add((Component)UIUtilities.buildComponentPanel(this.endField), c);
        return p;
    }

    public TextualTwoKnobsSlider() {
        this(0, 100);
    }

    public TextualTwoKnobsSlider(int min, int max) {
        this(min, max, min, max);
    }

    public TextualTwoKnobsSlider(int min, int max, int start, int end) {
        this.initComponents(min, max, start, end);
        this.attachListeners();
    }

    public void setStartLabelText(String text) {
        this.startLabel.setText(text);
    }

    public void setEndLabelText(String text) {
        this.endLabel.setText(text);
    }

    public void setSliderLabelText(String text) {
        this.sliderLabel.setText(text);
    }

    public int getStartValue() {
        return this.start;
    }

    public int getEndValue() {
        return this.end;
    }

    public void layoutComponents() {
        this.layoutComponents(0);
    }

    public void layoutComponents(int index) {
        switch (index) {
            case 1: {
                this.add(this.buildFieldsPane());
                break;
            }
            default: {
                double[][] size = new double[][]{{-2.0, -2.0}, {-2.0, -2.0}};
                JPanel content = new JPanel();
                content.setLayout((LayoutManager)new TableLayout((double[][])size));
                content.add((Component)this.sliderLabel, "0, 0");
                content.add((Component)UIUtilities.buildComponentPanel(this.slider), "1, 0");
                content.add((Component)this.buildFieldsPane(), "1, 1");
                this.add(content);
            }
        }
    }

    public void setSliderPaintingDefault(boolean paint) {
        this.slider.setPaintLabels(paint);
        this.slider.setPaintEndLabels(paint);
        this.slider.setPaintTicks(paint);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.slider.setEnabled(enabled);
        this.endField.setEnabled(enabled);
        this.startField.setEnabled(enabled);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("leftMoved".equals(name)) {
            Integer value = (Integer)evt.getNewValue();
            this.synchStartValue(value);
        } else if ("rightMoved".equals(name)) {
            Integer value = (Integer)evt.getNewValue();
            this.synchEndValue(value);
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.setStartValue();
                break;
            }
            case 1: {
                this.setEndValue();
            }
        }
    }

    public void focusLost(FocusEvent e) {
        this.handleFocusLost();
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateTextValue(e.getDocument());
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateTextValue(e.getDocument());
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }
}

