/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import layout.TableLayout;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.SearchContextMenu;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;
import org.openmicroscopy.shoola.util.ui.search.SearchUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickSearch
extends JPanel
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final int TAGS = 0;
    public static final int COMMENTS = 1;
    public static final int FULL_TEXT = 2;
    public static final int RATED_ONE_OR_BETTER = 3;
    public static final int RATED_TWO_OR_BETTER = 4;
    public static final int RATED_THREE_OR_BETTER = 5;
    public static final int RATED_FOUR_OR_BETTER = 6;
    public static final int RATED_FIVE = 7;
    public static final int UNRATED = 8;
    public static final int SHOW_ALL = 9;
    public static final int UNTAGGED = 10;
    public static final int UNCOMMENTED = 11;
    public static final int TAGGED = 12;
    public static final int COMMENTED = 13;
    public static final String QUICK_SEARCH_PROPERTY = "quickSearch";
    public static final String VK_UP_SEARCH_PROPERTY = "vkUpSearch";
    public static final String VK_DOWN_SEARCH_PROPERTY = "vkDownSearch";
    private static final int CLEAR = 0;
    private SearchObject selectedNode;
    private JTextField searchArea;
    private JButton searchButton;
    private JButton clearButton;
    private JButton menuButton;
    private TableLayout layoutManager;
    private JPanel searchPanel;
    private SearchContextMenu menu;
    private List<SearchObject> nodes;
    private List<SearchObject> ratedNodes;
    private String label;
    private SearchObject showAll;
    private JToolBar cleanBar;
    private boolean singleSelection;

    private void initMenu() {
        Rectangle r = this.searchPanel.getBounds();
        if (this.menu == null) {
            this.menu = this.selectedNode != null ? new SearchContextMenu(this.nodes, this.ratedNodes, r.width, this.selectedNode, this.singleSelection) : new SearchContextMenu(this.nodes, this.ratedNodes, r.width, this.singleSelection);
            this.menu.addPropertyChangeListener("searchContext", this);
        }
    }

    private void initComponents() {
        this.showAll = new SearchObject(9, null, "Show All");
        IconManager icons = IconManager.getInstance();
        this.clearButton = new JButton(icons.getIcon(58));
        this.clearButton.setToolTipText("Clear Filtering and Show All");
        UIUtilities.setTextAreaDefault(this.clearButton);
        this.clearButton.setBorder(null);
        this.clearButton.addActionListener(this);
        this.clearButton.setActionCommand("0");
        this.searchArea = new JTextField(15);
        UIUtilities.setTextAreaDefault(this.searchArea);
        this.searchArea.setBorder(null);
        this.searchArea.getDocument().addDocumentListener(this);
        this.searchArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object source = e.getSource();
                if (source != QuickSearch.this.searchArea) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        QuickSearch.this.handleKeyEnter();
                        break;
                    }
                    case 38: {
                        QuickSearch.this.firePropertyChange(QuickSearch.VK_UP_SEARCH_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                        break;
                    }
                    case 40: {
                        QuickSearch.this.firePropertyChange(QuickSearch.VK_DOWN_SEARCH_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                    }
                }
            }
        });
    }

    private void initComponents(Icon icon) {
        IconManager icons = IconManager.getInstance();
        if (icon == null) {
            icon = icons.getIcon(56);
        }
        this.searchButton = new JButton(icon);
        UIUtilities.setTextAreaDefault(this.searchButton);
        this.searchButton.setBorder(null);
        this.initComponents();
    }

    private void initSearchComponents(List<SearchObject> nodes, List<SearchObject> ratedNodes) {
        if (ratedNodes == null) {
            ratedNodes = new ArrayList<SearchObject>();
        }
        this.nodes = nodes;
        this.ratedNodes = ratedNodes;
        IconManager icons = IconManager.getInstance();
        this.menuButton = new JButton(icons.getIcon(57));
        this.menuButton.setToolTipText("Display the filtering options.");
        UIUtilities.setTextAreaDefault(this.menuButton);
        this.menuButton.setBorder(null);
        this.menuButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                QuickSearch.this.initMenu();
                Rectangle r = QuickSearch.this.searchPanel.getBounds();
                QuickSearch.this.menu.show(QuickSearch.this.searchPanel, 0, r.height);
            }
        });
        this.selectedNode = nodes.get(0);
        this.searchButton = new JButton(this.selectedNode.getIcon());
        UIUtilities.setTextAreaDefault(this.searchButton);
        this.searchButton.setBorder(null);
        this.initComponents();
        this.searchArea.setToolTipText(this.selectedNode.getDescription() + ".");
    }

    private void buildGUI(String label) {
        double w = 0.0;
        if (this.menuButton != null) {
            w = -2.0;
        }
        double[][] pl = new double[][]{{-2.0, w, -1.0, -2.0}, {-2.0}};
        this.layoutManager = new TableLayout((double[][])pl);
        this.searchPanel = new JPanel();
        UIUtilities.setTextAreaDefault(this.searchPanel);
        this.searchPanel.setLayout((LayoutManager)this.layoutManager);
        this.searchPanel.setBorder(BorderFactory.createBevelBorder(1));
        if (this.menuButton != null) {
            JToolBar bar = new JToolBar();
            bar.setFloatable(false);
            bar.setRollover(true);
            bar.setBorder(null);
            bar.add(this.menuButton);
            this.searchPanel.add((Component)bar, "1, 0, f, c");
        }
        this.searchPanel.add((Component)this.searchArea, "2, 0, f, c");
        if (this.clearButton != null) {
            this.cleanBar = new JToolBar();
            this.cleanBar.setFloatable(false);
            this.cleanBar.setRollover(true);
            this.cleanBar.setBorder(null);
            this.cleanBar.add(this.clearButton);
            this.cleanBar.setVisible(false);
            this.searchPanel.add((Component)this.cleanBar, "3, 0, f, c");
        }
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(true);
        if (label != null && label.trim().length() > 0) {
            this.add(UIUtilities.setTextFont(label));
        }
        this.add(this.searchPanel);
    }

    private void handleKeyEnter() {
        List<String> l = SearchUtil.splitTerms(this.searchArea.getText(), ",");
        if (this.selectedNode == null) {
            return;
        }
        this.selectedNode.setResult(l);
        this.firePropertyChange(QUICK_SEARCH_PROPERTY, null, this.selectedNode);
    }

    private void clear() {
        this.searchArea.getDocument().removeDocumentListener(this);
        this.searchArea.setText("");
        this.searchArea.getDocument().addDocumentListener(this);
        this.searchPanel.validate();
        this.searchPanel.repaint();
        this.cleanBar.setVisible(false);
        switch (this.selectedNode.getIndex()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.setSearchContext(9);
            }
        }
        this.firePropertyChange(QUICK_SEARCH_PROPERTY, null, this.showAll);
    }

    private void setSearchContext(SearchObject oldNode) {
        String text = null;
        if (this.selectedNode == null) {
            return;
        }
        this.setSearchEnabled(true);
        switch (this.selectedNode.getIndex()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.setSearchEnabled(false);
                text = this.selectedNode.getDescription();
                this.cleanBar.setVisible(false);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.setSearchEnabled(false);
                text = "";
                this.cleanBar.setVisible(false);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                int oldIndex;
                if (oldNode == null || (oldIndex = oldNode.getIndex()) == 0 || oldIndex == 1 || oldIndex == 2) break;
                text = "";
            }
        }
        if (text == null) {
            return;
        }
        this.searchArea.getDocument().removeDocumentListener(this);
        this.searchArea.setText(text);
        this.searchArea.getDocument().addDocumentListener(this);
    }

    public QuickSearch() {
        this.initComponents(null);
        this.buildGUI(null);
    }

    public QuickSearch(Icon icon) {
        this(null, icon);
    }

    public QuickSearch(String label) {
        this.label = label;
        this.initComponents(null);
        this.buildGUI(label);
    }

    public QuickSearch(String label, Icon icon) {
        this.label = label;
        this.initComponents(icon);
        this.buildGUI(label);
    }

    public QuickSearch(List<SearchObject> nodes, List<SearchObject> ratedNodes) {
        this(null, nodes, ratedNodes);
    }

    public QuickSearch(String label, List<SearchObject> nodes, List<SearchObject> ratedNodes) {
        this.label = label;
        if (nodes == null || nodes.size() == 0) {
            this.initComponents(null);
        } else {
            this.initSearchComponents(nodes, ratedNodes);
        }
        this.buildGUI(label);
    }

    public void setSingleSelection(boolean singleSelection) {
        this.singleSelection = singleSelection;
    }

    public void setDefaultSearchContext() {
        ArrayList<SearchObject> nodes = new ArrayList<SearchObject>();
        SearchObject node = new SearchObject(9, null, "Show All");
        nodes.add(node);
        node = new SearchObject(2, null, "Name");
        nodes.add(node);
        node = new SearchObject(0, null, "Tags");
        nodes.add(node);
        node = new SearchObject(1, null, "Comments");
        nodes.add(node);
        node = new SearchObject(12, null, "Tagged");
        nodes.add(node);
        node = new SearchObject(10, null, "Untagged");
        nodes.add(node);
        node = new SearchObject(13, null, "Commented");
        nodes.add(node);
        node = new SearchObject(11, null, "Uncommented");
        nodes.add(node);
        ArrayList<SearchObject> ratedNodes = new ArrayList<SearchObject>();
        node = new SearchObject(3, null, "* or better");
        ratedNodes.add(node);
        node = new SearchObject(4, null, "** or better");
        ratedNodes.add(node);
        node = new SearchObject(5, null, "*** or better");
        ratedNodes.add(node);
        node = new SearchObject(6, null, "**** or better");
        ratedNodes.add(node);
        node = new SearchObject(7, null, "*****");
        ratedNodes.add(node);
        node = new SearchObject(8, null, "Unrated");
        ratedNodes.add(node);
        this.initSearchComponents(nodes, ratedNodes);
        this.removeAll();
        this.buildGUI(this.label);
    }

    public SearchObject getSelectedNode() {
        return this.selectedNode;
    }

    public JComponent getSelectionArea() {
        return this.searchPanel;
    }

    public void setFocusOnArea() {
        this.searchArea.requestFocus();
    }

    public String getSearchValue() {
        return this.searchArea.getText();
    }

    public void setSearchValue(String text) {
        if (text == null) {
            return;
        }
        List<String> l = SearchUtil.splitTerms(this.getSearchValue(), ",");
        String result = SearchUtil.formatString(text, l);
        this.searchArea.getDocument().removeDocumentListener(this);
        this.searchArea.setText(result);
        this.searchArea.getDocument().addDocumentListener(this);
    }

    public void setSearchEnabled(boolean enabled) {
        this.searchArea.setEnabled(enabled);
    }

    public void setSearchValue(List<String> text) {
        if (text == null || text.size() == 0) {
            return;
        }
        List<String> l = SearchUtil.splitTerms(this.getSearchValue(), ",");
        Iterator<String> i = text.iterator();
        String term = "";
        int index = 0;
        int n = text.size() - 1;
        while (i.hasNext()) {
            term = term + i.next();
            if (index < n) {
                term = term + ",";
            }
            ++index;
        }
        String result = SearchUtil.formatString(term, l);
        this.searchArea.getDocument().removeDocumentListener(this);
        this.searchArea.setText(result);
        this.searchArea.getDocument().addDocumentListener(this);
    }

    public void setSearchContext(int index) {
        Iterator<SearchObject> i = this.nodes.iterator();
        SearchObject selectedNode = null;
        while (i.hasNext()) {
            SearchObject node = i.next();
            if (node.getIndex() != index) continue;
            selectedNode = node;
            break;
        }
        if (selectedNode == null) {
            for (SearchObject node : this.ratedNodes) {
                if (node.getIndex() != index) continue;
                selectedNode = node;
                break;
            }
        }
        if (selectedNode != null) {
            this.initMenu();
            this.menu.setSelectedNode(selectedNode);
            this.selectedNode = selectedNode;
            this.setSearchContext(null);
        }
    }

    protected void handleTextInsert() {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleTextInsert();
        this.cleanBar.setVisible(true);
        this.searchPanel.validate();
        this.searchPanel.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (e.getDocument().getLength() == 0) {
            this.clear();
        }
    }

    public void search() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.clear();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("searchContext".equals(name)) {
            SearchObject node = (SearchObject)evt.getNewValue();
            SearchObject oldNode = this.selectedNode;
            if (node != null) {
                this.selectedNode = node;
            }
            this.searchButton.setIcon(this.selectedNode.getIcon());
            UIUtilities.setTextAreaDefault(this.searchButton);
            this.searchButton.setBorder(null);
            this.searchArea.setToolTipText(this.selectedNode.getDescription());
            this.setSearchContext(oldNode);
            this.handleKeyEnter();
        } else if (QUICK_SEARCH_PROPERTY.equals(name)) {
            this.search();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    static /* synthetic */ JTextField access$000(QuickSearch x0) {
        return x0.searchArea;
    }

    static /* synthetic */ void access$100(QuickSearch x0) {
        x0.handleKeyEnter();
    }

    static /* synthetic */ void access$200(QuickSearch x0, String x1, Object x2, Object x3) {
        x0.firePropertyChange(x1, x2, x3);
    }

    static /* synthetic */ void access$300(QuickSearch x0, String x1, Object x2, Object x3) {
        x0.firePropertyChange(x1, x2, x3);
    }

    static /* synthetic */ void access$400(QuickSearch x0) {
        x0.initMenu();
    }

    static /* synthetic */ JPanel access$500(QuickSearch x0) {
        return x0.searchPanel;
    }

    static /* synthetic */ SearchContextMenu access$600(QuickSearch x0) {
        return x0.menu;
    }
}

