/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class StatusPanel
extends JPanel {
    static final String LENS_X = "X : ";
    static final String LENS_Y = "Y : ";
    static final String LENS_W = "W : ";
    static final String LENS_H = "H : ";
    static final String LENS_MAGNIFICATION = "x";
    private JLabel lensPosition = new JLabel("X :  000 Y :  000");
    private JLabel lensSize = new JLabel("W :  000 H :  000");
    private JLabel lensZoom = new JLabel("x00");
    private double micronInXAxis = 1.0;
    private double micronInYAxis = 1.0;
    private boolean displayInPixels = true;

    StatusPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.lensPosition);
        Dimension minSize = new Dimension(15, 1);
        Dimension prefSize = new Dimension(15, 1);
        Dimension maxSize = new Dimension(15, 1);
        this.add(new Box.Filler(minSize, prefSize, maxSize));
        this.add(this.lensSize);
        this.add(new Box.Filler(minSize, prefSize, maxSize));
        this.add(this.lensZoom);
    }

    void setDisplayInPixels(boolean b) {
        this.displayInPixels = b;
    }

    void setLensXY(int x, int y) {
        if (this.displayInPixels) {
            this.lensPosition.setText(LENS_X + x + " " + LENS_Y + y);
        } else {
            this.lensPosition.setText(LENS_X + UIUtilities.twoDecimalPlaces((double)x / this.micronInXAxis) + " " + LENS_Y + UIUtilities.twoDecimalPlaces((double)y / this.micronInYAxis));
        }
    }

    void setLensWidthHeight(int w, int h) {
        if (this.displayInPixels) {
            this.lensSize.setText(LENS_W + w + " " + LENS_H + h);
        } else {
            this.lensSize.setText(LENS_W + UIUtilities.twoDecimalPlaces((double)w / this.micronInXAxis) + " " + LENS_H + UIUtilities.twoDecimalPlaces((double)h / this.micronInYAxis));
        }
    }

    void setLensZoomFactor(float zoomFactor) {
        this.lensZoom.setText(LENS_MAGNIFICATION + zoomFactor);
    }

    public void setXYPixelMicron(double x, double y) {
        this.micronInXAxis = x;
        this.micronInYAxis = y;
    }
}

