/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.filechooser;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.RegExFactory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileSaverDialog;
import org.openmicroscopy.shoola.util.ui.filechooser.FileSaverUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChooser
extends JDialog {
    public static final String APPROVE_SELECTION_PROPERTY = "approveSelection";
    public static final String CANCEL_SELECTION_PROPERTY = "cancelSelection";
    public static final String LOCATION_PROPERTY = "location";
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    public static final int FOLDER_CHOOSER = 2;
    public static final int LEFT = 100;
    public static final int CENTER = 101;
    public static final int RIGHT = 102;
    private int option;
    private FileSaverUI uiDelegate;
    private int dialogType;
    private String title;
    private String message;
    private List<FileFilter> filters;
    private String folderPath;

    private void setProperties() {
        this.setTitle(this.title);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FileChooser.this.cancelSelection();
            }

            public void windowOpened(WindowEvent e) {
                FileChooser.this.uiDelegate.requestFocusOnName();
            }
        });
    }

    private void checkType(int v) {
        switch (v) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Type not supported");
    }

    private String getPartialName(String originalName) {
        int n;
        String name = originalName;
        String[] l = UIUtilities.splitString(originalName);
        if (l != null && (n = l.length) >= 1) {
            name = l[n - 1];
        }
        if (Pattern.compile(".").matcher(name).find() && (l = name.split("\\.")).length >= 1) {
            name = "";
            n = l.length - 1;
            for (int i = 0; i < n; ++i) {
                name = name + l[i];
                if (i >= n - 1) continue;
                name = name + ".";
            }
        }
        return name;
    }

    public FileChooser(JFrame owner, int dialogType, String title, String message, List<FileFilter> filters) {
        super(owner);
        this.checkType(dialogType);
        this.dialogType = dialogType;
        this.title = title;
        this.message = message;
        this.filters = filters;
        this.setProperties();
        this.folderPath = null;
        this.uiDelegate = new FileSaverUI(this);
        this.pack();
    }

    public FileChooser(JFrame owner, int dialogType, String title, String message) {
        this(owner, dialogType, title, message, null);
    }

    String getNote() {
        return this.message;
    }

    List<FileFilter> getFilters() {
        return this.filters;
    }

    String getExtendedName(String name, String format) {
        String extension = "." + format;
        Pattern pattern = RegExFactory.createPattern(extension);
        String n = RegExFactory.find(pattern, name) ? name : (RegExFactory.find(pattern = RegExFactory.createCaseInsensitivePattern(extension), name) ? name : name + "." + format);
        return n;
    }

    void cancelSelection() {
        this.firePropertyChange(CANCEL_SELECTION_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        this.option = 1;
        this.setVisible(false);
        this.dispose();
    }

    void acceptSelection() {
        this.option = 0;
        if (this.getChooserType() == 2) {
            this.firePropertyChange(APPROVE_SELECTION_PROPERTY, Boolean.FALSE, this.getFolderPath());
        } else {
            this.firePropertyChange(APPROVE_SELECTION_PROPERTY, Boolean.FALSE, this.getSelectedFile());
        }
        if (this.uiDelegate.isSetDefaultFolder() && this.getChooserType() != 2) {
            UIUtilities.setDefaultFolder(this.uiDelegate.getCurrentDirectory().toString());
        }
        this.setVisible(false);
        this.dispose();
    }

    void setFolderPath(String path) {
        if (path == null) {
            return;
        }
        char separator = File.separatorChar;
        File[] l = this.uiDelegate.getCurrentDirectory().listFiles();
        boolean exist = false;
        for (int i = 0; i < l.length; ++i) {
            if (!l[i].getAbsolutePath().equals(path)) continue;
            exist = true;
            break;
        }
        this.folderPath = path;
        this.firePropertyChange(LOCATION_PROPERTY, null, path + separator);
        this.setVisible(false);
        this.dispose();
    }

    void setSelection() {
        IconManager im = IconManager.getInstance();
        FileSaverDialog d = new FileSaverDialog(this, im.getIcon(52));
        UIUtilities.centerAndShow(d);
    }

    public File getFolderPath() {
        if (this.folderPath != null) {
            return new File(this.folderPath);
        }
        return null;
    }

    public int getChooserType() {
        return this.dialogType;
    }

    public void setSelectedFile(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("File name not valid.");
        }
        String s = this.getPartialName(name);
        if (s == null || s.trim().length() == 0) {
            s = name;
        }
        this.uiDelegate.setSelectedFile(new File(s));
    }

    public void setSelectedFile(File name) {
        if (name == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        this.uiDelegate.setSelectedFile(name);
    }

    public void setCurrentDirectory(String dir) {
        if (dir == null || dir.trim().length() == 0) {
            throw new IllegalArgumentException("Folder name not valid.");
        }
        this.uiDelegate.setCurrentDirectory(new File(dir));
    }

    public void setCurrentDirectory(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Folder cannot be null.");
        }
        this.uiDelegate.setCurrentDirectory(dir);
    }

    public File getSelectedFile() {
        return this.uiDelegate.getSelectedFile();
    }

    public File getFormattedSelectedFile() {
        return this.uiDelegate.getFormattedSelectedFile();
    }

    public FileFilter getSelectedFilter() {
        return this.uiDelegate.getSelectedFilter();
    }

    public int showDialog() {
        UIUtilities.setLocationRelativeToAndShow(this.getParent(), this);
        return this.option;
    }

    public int centerDialog() {
        UIUtilities.centerAndShow(this);
        return this.option;
    }

    public void setApproveButtonText(String text) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        this.uiDelegate.setApproveButtonText(text);
    }

    public void setApproveButtonToolTipText(String text) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        this.uiDelegate.setApproveButtonToolTipText(text);
    }

    public void addControlButton(JButton button, int location) {
        if (button == null) {
            throw new IllegalArgumentException("Button cannot be null.");
        }
        switch (location) {
            case 100: 
            case 101: 
            case 102: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Location not supported.");
            }
        }
        this.uiDelegate.addControlButton(button, location);
    }

    public void addComponentToControls(JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("The component cannot be null.");
        }
        this.uiDelegate.addComponentToControls(component);
    }

    public void setTitleIcon(Icon icon) {
        if (icon == null) {
            return;
        }
        this.uiDelegate.setTitleIcon(icon);
    }

    static /* synthetic */ FileSaverUI access$000(FileChooser x0) {
        return x0.uiDelegate;
    }
}

