/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.filechooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class CreateFolderDialog
extends JDialog
implements ActionListener {
    public static final String CREATE_FOLDER_PROPERTY = "createFolder";
    public static final String CANCEL_FOLDER_PROPERTY = "cancelFolder";
    private static final String DEFAULT_NAME = "untitled folder";
    private static final String DEFAULT_TEXT = "New Folder";
    private static final Dimension H_SPACER_SIZE = new Dimension(3, 10);
    private static final int CANCEL = 0;
    private static final int CREATE = 1;
    private JButton cancelButton;
    private JButton createButton;
    private JTextField nameField;

    private void create() {
        String n = this.nameField.getText();
        if (n == null || n.trim().length() == 0) {
            this.cancel();
            return;
        }
        this.firePropertyChange(CREATE_FOLDER_PROPERTY, null, n);
        this.cancel();
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
        this.firePropertyChange(CANCEL_FOLDER_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    private void initComponents() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        this.createButton = new JButton("Create");
        this.createButton.addActionListener(this);
        this.createButton.setActionCommand("1");
        this.nameField = new JTextField();
        this.nameField.setText(DEFAULT_NAME);
        this.nameField.selectAll();
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                CreateFolderDialog.this.nameField.requestFocus();
            }
        });
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.createButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        return p;
    }

    private void buildGUI(String name) {
        String s = "Name of " + name.toLowerCase() + ":";
        JLabel label = new JLabel(s);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(UIUtilities.buildComponentPanel(label));
        p.add(this.nameField);
        p.add(this.buildToolBar());
        this.getContentPane().add((Component)UIUtilities.buildComponentPanel(p), "Center");
    }

    private void initialize(String name) {
        if (name == null || name.length() == 0) {
            name = DEFAULT_TEXT;
        }
        this.setTitle(name);
        this.setModal(true);
        this.setResizable(false);
        this.initComponents();
        this.buildGUI(name);
    }

    public CreateFolderDialog(JDialog owner, String text) {
        super(owner);
        this.initialize(text);
    }

    public CreateFolderDialog(JFrame owner, String text) {
        super(owner);
        this.initialize(text);
    }

    public CreateFolderDialog(JDialog owner) {
        this(owner, DEFAULT_TEXT);
    }

    public CreateFolderDialog(JFrame owner) {
        this(owner, DEFAULT_TEXT);
    }

    public void setDefaultName(String text) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        this.nameField.setText(text);
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.create();
            }
        }
    }

    static /* synthetic */ JTextField access$000(CreateFolderDialog x0) {
        return x0.nameField;
    }
}

